/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the permission set provisioning status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionSetProvisioningStatusMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionSetProvisioningStatusMetadata.Builder, PermissionSetProvisioningStatusMetadata> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PermissionSetProvisioningStatusMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(PermissionSetProvisioningStatusMetadata::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(PermissionSetProvisioningStatusMetadata::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            REQUEST_ID_FIELD, CREATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String requestId;

    private final Instant createdDate;

    private PermissionSetProvisioningStatusMetadata(BuilderImpl builder) {
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final StatusValues status() {
        return StatusValues.fromValue(status);
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID)
     * workflow.
     * </p>
     * 
     * @return The identifier for tracking the request operation that is generated by the universally unique identifier
     *         (UUID) workflow.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The date that the permission set was created.
     * </p>
     * 
     * @return The date that the permission set was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionSetProvisioningStatusMetadata)) {
            return false;
        }
        PermissionSetProvisioningStatusMetadata other = (PermissionSetProvisioningStatusMetadata) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionSetProvisioningStatusMetadata").add("Status", statusAsString())
                .add("RequestId", requestId()).add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionSetProvisioningStatusMetadata, T> g) {
        return obj -> g.apply((PermissionSetProvisioningStatusMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionSetProvisioningStatusMetadata> {
        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(StatusValues status);

        /**
         * <p>
         * The identifier for tracking the request operation that is generated by the universally unique identifier
         * (UUID) workflow.
         * </p>
         * 
         * @param requestId
         *        The identifier for tracking the request operation that is generated by the universally unique
         *        identifier (UUID) workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The date that the permission set was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the permission set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String requestId;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionSetProvisioningStatusMetadata model) {
            status(model.status);
            requestId(model.requestId);
            createdDate(model.createdDate);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusValues status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public PermissionSetProvisioningStatusMetadata build() {
            return new PermissionSetProvisioningStatusMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
