/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionPermissionSetRequest extends SsoAdminRequest implements
        ToCopyableBuilder<ProvisionPermissionSetRequest.Builder, ProvisionPermissionSetRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(ProvisionPermissionSetRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(ProvisionPermissionSetRequest::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(ProvisionPermissionSetRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(ProvisionPermissionSetRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            PERMISSION_SET_ARN_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD));

    private final String instanceArn;

    private final String permissionSetArn;

    private final String targetId;

    private final String targetType;

    private ProvisionPermissionSetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.permissionSetArn = builder.permissionSetArn;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     * Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the SSO instance under which the operation will be executed. For more information about ARNs,
     *         see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS
     *         Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The ARN of the permission set.
     * </p>
     * 
     * @return The ARN of the permission set.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
     * </p>
     * 
     * @return TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ProvisionTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see ProvisionTargetType
     */
    public final ProvisionTargetType targetType() {
        return ProvisionTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ProvisionTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see ProvisionTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionPermissionSetRequest)) {
            return false;
        }
        ProvisionPermissionSetRequest other = (ProvisionPermissionSetRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionPermissionSetRequest").add("InstanceArn", instanceArn())
                .add("PermissionSetArn", permissionSetArn()).add("TargetId", targetId()).add("TargetType", targetTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionPermissionSetRequest, T> g) {
        return obj -> g.apply((ProvisionPermissionSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionPermissionSetRequest> {
        /**
         * <p>
         * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see
         * <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         * Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the SSO instance under which the operation will be executed. For more information about
         *        ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         *        AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The ARN of the permission set.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
         * </p>
         * 
         * @param targetId
         *        TargetID is an AWS account identifier, typically a 10-12 digit string (For example, 123456789012).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see ProvisionTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see ProvisionTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionTargetType
         */
        Builder targetType(ProvisionTargetType targetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String permissionSetArn;

        private String targetId;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionPermissionSetRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            permissionSetArn(model.permissionSetArn);
            targetId(model.targetId);
            targetType(model.targetType);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        public final String getTargetId() {
            return targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ProvisionTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionPermissionSetRequest build() {
            return new ProvisionPermissionSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
