/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssignmentsResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListAccountAssignmentsResponse.Builder, ListAccountAssignmentsResponse> {
    private static final SdkField<List<AccountAssignment>> ACCOUNT_ASSIGNMENTS_FIELD = SdkField
            .<List<AccountAssignment>> builder(MarshallingType.LIST)
            .memberName("AccountAssignments")
            .getter(getter(ListAccountAssignmentsResponse::accountAssignments))
            .setter(setter(Builder::accountAssignments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountAssignment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAssignment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountAssignmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSIGNMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccountAssignment> accountAssignments;

    private final String nextToken;

    private ListAccountAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignments = builder.accountAssignments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccountAssignments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAccountAssignments() {
        return accountAssignments != null && !(accountAssignments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of assignments that match the input AWS account and permission set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountAssignments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of assignments that match the input AWS account and permission set.
     */
    public List<AccountAssignment> accountAssignments() {
        return accountAssignments;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentsResponse)) {
            return false;
        }
        ListAccountAssignmentsResponse other = (ListAccountAssignmentsResponse) obj;
        return Objects.equals(accountAssignments(), other.accountAssignments()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAccountAssignmentsResponse").add("AccountAssignments", accountAssignments())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssignments":
            return Optional.ofNullable(clazz.cast(accountAssignments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentsResponse, T> g) {
        return obj -> g.apply((ListAccountAssignmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountAssignmentsResponse> {
        /**
         * <p>
         * The list of assignments that match the input AWS account and permission set.
         * </p>
         * 
         * @param accountAssignments
         *        The list of assignments that match the input AWS account and permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignments(Collection<AccountAssignment> accountAssignments);

        /**
         * <p>
         * The list of assignments that match the input AWS account and permission set.
         * </p>
         * 
         * @param accountAssignments
         *        The list of assignments that match the input AWS account and permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignments(AccountAssignment... accountAssignments);

        /**
         * <p>
         * The list of assignments that match the input AWS account and permission set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountAssignment>.Builder} avoiding the
         * need to create one manually via {@link List<AccountAssignment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountAssignment>.Builder#build()} is called immediately
         * and its result is passed to {@link #accountAssignments(List<AccountAssignment>)}.
         * 
         * @param accountAssignments
         *        a consumer that will call methods on {@link List<AccountAssignment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAssignments(List<AccountAssignment>)
         */
        Builder accountAssignments(Consumer<AccountAssignment.Builder>... accountAssignments);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AccountAssignment> accountAssignments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentsResponse model) {
            super(model);
            accountAssignments(model.accountAssignments);
            nextToken(model.nextToken);
        }

        public final Collection<AccountAssignment.Builder> getAccountAssignments() {
            return accountAssignments != null ? accountAssignments.stream().map(AccountAssignment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAssignments(Collection<AccountAssignment> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copy(accountAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(AccountAssignment... accountAssignments) {
            accountAssignments(Arrays.asList(accountAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignments(Consumer<AccountAssignment.Builder>... accountAssignments) {
            accountAssignments(Stream.of(accountAssignments).map(c -> AccountAssignment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAssignments(Collection<AccountAssignment.BuilderImpl> accountAssignments) {
            this.accountAssignments = AccountAssignmentListCopier.copyFromBuilder(accountAssignments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountAssignmentsResponse build() {
            return new ListAccountAssignmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
