/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInlinePolicyToPermissionSetRequest extends SsoAdminRequest implements
        ToCopyableBuilder<PutInlinePolicyToPermissionSetRequest.Builder, PutInlinePolicyToPermissionSetRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInlinePolicyToPermissionSetRequest::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInlinePolicyToPermissionSetRequest::permissionSetArn)).setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> INLINE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInlinePolicyToPermissionSetRequest::inlinePolicy)).setter(setter(Builder::inlinePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlinePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            PERMISSION_SET_ARN_FIELD, INLINE_POLICY_FIELD));

    private final String instanceArn;

    private final String permissionSetArn;

    private final String inlinePolicy;

    private PutInlinePolicyToPermissionSetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.permissionSetArn = builder.permissionSetArn;
        this.inlinePolicy = builder.inlinePolicy;
    }

    /**
     * <p>
     * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     * Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the SSO instance under which the operation will be executed. For more information about ARNs,
     *         see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS
     *         Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The ARN of the permission set.
     * </p>
     * 
     * @return The ARN of the permission set.
     */
    public String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The IAM inline policy to attach to a <a>PermissionSet</a>.
     * </p>
     * 
     * @return The IAM inline policy to attach to a <a>PermissionSet</a>.
     */
    public String inlinePolicy() {
        return inlinePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(inlinePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInlinePolicyToPermissionSetRequest)) {
            return false;
        }
        PutInlinePolicyToPermissionSetRequest other = (PutInlinePolicyToPermissionSetRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(inlinePolicy(), other.inlinePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutInlinePolicyToPermissionSetRequest").add("InstanceArn", instanceArn())
                .add("PermissionSetArn", permissionSetArn())
                .add("InlinePolicy", inlinePolicy() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "InlinePolicy":
            return Optional.ofNullable(clazz.cast(inlinePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInlinePolicyToPermissionSetRequest, T> g) {
        return obj -> g.apply((PutInlinePolicyToPermissionSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutInlinePolicyToPermissionSetRequest> {
        /**
         * <p>
         * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see
         * <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         * Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the SSO instance under which the operation will be executed. For more information about
         *        ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         *        AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The ARN of the permission set.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The IAM inline policy to attach to a <a>PermissionSet</a>.
         * </p>
         * 
         * @param inlinePolicy
         *        The IAM inline policy to attach to a <a>PermissionSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlinePolicy(String inlinePolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String permissionSetArn;

        private String inlinePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInlinePolicyToPermissionSetRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            permissionSetArn(model.permissionSetArn);
            inlinePolicy(model.inlinePolicy);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        public final String getInlinePolicy() {
            return inlinePolicy;
        }

        @Override
        public final Builder inlinePolicy(String inlinePolicy) {
            this.inlinePolicy = inlinePolicy;
            return this;
        }

        public final void setInlinePolicy(String inlinePolicy) {
            this.inlinePolicy = inlinePolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInlinePolicyToPermissionSetRequest build() {
            return new PutInlinePolicyToPermissionSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
