/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionSetsProvisionedToAccountResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListPermissionSetsProvisionedToAccountResponse.Builder, ListPermissionSetsProvisionedToAccountResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPermissionSetsProvisionedToAccountResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> PERMISSION_SETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPermissionSetsProvisionedToAccountResponse::permissionSets))
            .setter(setter(Builder::permissionSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PERMISSION_SETS_FIELD));

    private final String nextToken;

    private final List<String> permissionSets;

    private ListPermissionSetsProvisionedToAccountResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.permissionSets = builder.permissionSets;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PermissionSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissionSets() {
        return permissionSets != null && !(permissionSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the level of access that an AWS account has.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Defines the level of access that an AWS account has.
     */
    public List<String> permissionSets() {
        return permissionSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionSetsProvisionedToAccountResponse)) {
            return false;
        }
        ListPermissionSetsProvisionedToAccountResponse other = (ListPermissionSetsProvisionedToAccountResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(permissionSets(), other.permissionSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPermissionSetsProvisionedToAccountResponse").add("NextToken", nextToken())
                .add("PermissionSets", permissionSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PermissionSets":
            return Optional.ofNullable(clazz.cast(permissionSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionSetsProvisionedToAccountResponse, T> g) {
        return obj -> g.apply((ListPermissionSetsProvisionedToAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountResponse> {
        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Defines the level of access that an AWS account has.
         * </p>
         * 
         * @param permissionSets
         *        Defines the level of access that an AWS account has.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSets(Collection<String> permissionSets);

        /**
         * <p>
         * Defines the level of access that an AWS account has.
         * </p>
         * 
         * @param permissionSets
         *        Defines the level of access that an AWS account has.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSets(String... permissionSets);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> permissionSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionSetsProvisionedToAccountResponse model) {
            super(model);
            nextToken(model.nextToken);
            permissionSets(model.permissionSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getPermissionSets() {
            return permissionSets;
        }

        @Override
        public final Builder permissionSets(Collection<String> permissionSets) {
            this.permissionSets = PermissionSetListCopier.copy(permissionSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionSets(String... permissionSets) {
            permissionSets(Arrays.asList(permissionSets));
            return this;
        }

        public final void setPermissionSets(Collection<String> permissionSets) {
            this.permissionSets = PermissionSetListCopier.copy(permissionSets);
        }

        @Override
        public ListPermissionSetsProvisionedToAccountResponse build() {
            return new ListPermissionSetsProvisionedToAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
