/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationSettingsResponse extends SsmSapResponse implements
        ToCopyableBuilder<UpdateApplicationSettingsResponse.Builder, UpdateApplicationSettingsResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(UpdateApplicationSettingsResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<List<String>> OPERATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperationIds")
            .getter(getter(UpdateApplicationSettingsResponse::operationIds))
            .setter(setter(Builder::operationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            OPERATION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String message;

    private final List<String> operationIds;

    private UpdateApplicationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.operationIds = builder.operationIds;
    }

    /**
     * <p>
     * The update message.
     * </p>
     * 
     * @return The update message.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationIds() {
        return operationIds != null && !(operationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationIds} method.
     * </p>
     * 
     * @return The IDs of the operations.
     */
    public final List<String> operationIds() {
        return operationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationIds() ? operationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsResponse)) {
            return false;
        }
        UpdateApplicationSettingsResponse other = (UpdateApplicationSettingsResponse) obj;
        return Objects.equals(message(), other.message()) && hasOperationIds() == other.hasOperationIds()
                && Objects.equals(operationIds(), other.operationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationSettingsResponse").add("Message", message())
                .add("OperationIds", hasOperationIds() ? operationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "OperationIds":
            return Optional.ofNullable(clazz.cast(operationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("OperationIds", OPERATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationSettingsResponse, T> g) {
        return obj -> g.apply((UpdateApplicationSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationSettingsResponse> {
        /**
         * <p>
         * The update message.
         * </p>
         * 
         * @param message
         *        The update message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The IDs of the operations.
         * </p>
         * 
         * @param operationIds
         *        The IDs of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIds(Collection<String> operationIds);

        /**
         * <p>
         * The IDs of the operations.
         * </p>
         * 
         * @param operationIds
         *        The IDs of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationIds(String... operationIds);
    }

    static final class BuilderImpl extends SsmSapResponse.BuilderImpl implements Builder {
        private String message;

        private List<String> operationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsResponse model) {
            super(model);
            message(model.message);
            operationIds(model.operationIds);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Collection<String> getOperationIds() {
            if (operationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return operationIds;
        }

        public final void setOperationIds(Collection<String> operationIds) {
            this.operationIds = OperationIdListCopier.copy(operationIds);
        }

        @Override
        public final Builder operationIds(Collection<String> operationIds) {
            this.operationIds = OperationIdListCopier.copy(operationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationIds(String... operationIds) {
            operationIds(Arrays.asList(operationIds));
            return this;
        }

        @Override
        public UpdateApplicationSettingsResponse build() {
            return new UpdateApplicationSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
