/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOperationResponse extends SsmSapResponse implements
        ToCopyableBuilder<GetOperationResponse.Builder, GetOperationResponse> {
    private static final SdkField<Operation> OPERATION_FIELD = SdkField.<Operation> builder(MarshallingType.SDK_POJO)
            .memberName("Operation").getter(getter(GetOperationResponse::operation)).setter(setter(Builder::operation))
            .constructor(Operation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Operation operation;

    private GetOperationResponse(BuilderImpl builder) {
        super(builder);
        this.operation = builder.operation;
    }

    /**
     * <p>
     * Returns the details of an operation.
     * </p>
     * 
     * @return Returns the details of an operation.
     */
    public final Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationResponse)) {
            return false;
        }
        GetOperationResponse other = (GetOperationResponse) obj;
        return Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOperationResponse").add("Operation", operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOperationResponse, T> g) {
        return obj -> g.apply((GetOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOperationResponse> {
        /**
         * <p>
         * Returns the details of an operation.
         * </p>
         * 
         * @param operation
         *        Returns the details of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * Returns the details of an operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Operation.Builder} avoiding the need to
         * create one manually via {@link Operation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends SsmSapResponse.BuilderImpl implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationResponse model) {
            super(model);
            operation(model.operation);
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public GetOperationResponse build() {
            return new GetOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
