/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmsap.model.ComponentType;
import software.amazon.awssdk.services.ssmsap.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ComponentSummary.getter(ComponentSummary::applicationId)).setter(ComponentSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(ComponentSummary.getter(ComponentSummary::componentId)).setter(ComponentSummary.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentType").getter(ComponentSummary.getter(ComponentSummary::componentTypeAsString)).setter(ComponentSummary.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ComponentSummary.getter(ComponentSummary::tags)).setter(ComponentSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, COMPONENT_ID_FIELD, COMPONENT_TYPE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String componentId;
    private final String componentType;
    private final Map<String, String> tags;

    private ComponentSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.tags = builder.tags;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final ComponentType componentType() {
        return ComponentType.fromValue(this.componentType);
    }

    public final String componentTypeAsString() {
        return this.componentType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.componentTypeAsString(), other.componentTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentSummary").add("ApplicationId", (Object)this.applicationId()).add("ComponentId", (Object)this.componentId()).add("ComponentType", (Object)this.componentTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "ComponentType": {
                return Optional.ofNullable(clazz.cast(this.componentTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentSummary, T> g) {
        return obj -> g.apply((ComponentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String componentId;
        private String componentType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentSummary model) {
            this.applicationId(model.applicationId);
            this.componentId(model.componentId);
            this.componentType(model.componentType);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public final Builder componentType(ComponentType componentType) {
            this.componentType(componentType == null ? null : componentType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ComponentSummary build() {
            return new ComponentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentSummary> {
        public Builder applicationId(String var1);

        public Builder componentId(String var1);

        public Builder componentType(String var1);

        public Builder componentType(ComponentType var1);

        public Builder tags(Map<String, String> var1);
    }
}

