/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowTarget> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::windowId)).setter(MaintenanceWindowTarget.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::windowTargetId)).setter(MaintenanceWindowTarget.setter(Builder::windowTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::resourceTypeAsString)).setter(MaintenanceWindowTarget.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::targets)).setter(MaintenanceWindowTarget.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::ownerInformation)).setter(MaintenanceWindowTarget.setter(Builder::ownerInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::name)).setter(MaintenanceWindowTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowTarget.getter(MaintenanceWindowTarget::description)).setter(MaintenanceWindowTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, WINDOW_TARGET_ID_FIELD, RESOURCE_TYPE_FIELD, TARGETS_FIELD, OWNER_INFORMATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String windowTargetId;
    private final String resourceType;
    private final List<Target> targets;
    private final String ownerInformation;
    private final String name;
    private final String description;

    private MaintenanceWindowTarget(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public MaintenanceWindowResourceType resourceType() {
        return MaintenanceWindowResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTarget)) {
            return false;
        }
        MaintenanceWindowTarget other = (MaintenanceWindowTarget)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTargetId(), other.windowTargetId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowTarget").add("WindowId", (Object)this.windowId()).add("WindowTargetId", (Object)this.windowTargetId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Targets", this.targets()).add("OwnerInformation", (Object)(this.ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowTargetId": {
                return Optional.ofNullable(clazz.cast(this.windowTargetId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowTarget, T> g) {
        return obj -> g.apply((MaintenanceWindowTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTargetId;
        private String resourceType;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String ownerInformation;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTarget model) {
            this.windowId(model.windowId);
            this.windowTargetId(model.windowTargetId);
            this.resourceType(model.resourceType);
            this.targets(model.targets);
            this.ownerInformation(model.ownerInformation);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public MaintenanceWindowTarget build() {
            return new MaintenanceWindowTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowTarget> {
        public Builder windowId(String var1);

        public Builder windowTargetId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MaintenanceWindowResourceType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder ownerInformation(String var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

