/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceDataSyncRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateResourceDataSyncRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::syncName)).setter(CreateResourceDataSyncRequest.setter(Builder::syncName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()}).build();
    private static final SdkField<ResourceDataSyncS3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::s3Destination)).setter(CreateResourceDataSyncRequest.setter(Builder::s3Destination)).constructor(ResourceDataSyncS3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD, S3_DESTINATION_FIELD));
    private final String syncName;
    private final ResourceDataSyncS3Destination s3Destination;

    private CreateResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
    }

    public String syncName() {
        return this.syncName;
    }

    public ResourceDataSyncS3Destination s3Destination() {
        return this.s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDataSyncRequest)) {
            return false;
        }
        CreateResourceDataSyncRequest other = (CreateResourceDataSyncRequest)((Object)obj);
        return Objects.equals(this.syncName(), other.syncName()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceDataSyncRequest").add("SyncName", (Object)this.syncName()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.ofNullable(clazz.cast(this.syncName()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceDataSyncRequest, T> g) {
        return obj -> g.apply((CreateResourceDataSyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String syncName;
        private ResourceDataSyncS3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDataSyncRequest model) {
            super(model);
            this.syncName(model.syncName);
            this.s3Destination(model.s3Destination);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDataSyncRequest build() {
            return new CreateResourceDataSyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceDataSyncRequest> {
        public Builder syncName(String var1);

        public Builder s3Destination(ResourceDataSyncS3Destination var1);

        default public Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return this.s3Destination((ResourceDataSyncS3Destination)((ResourceDataSyncS3Destination.Builder)ResourceDataSyncS3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

