/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;

public class ListCommandInvocationsIterable
implements SdkIterable<ListCommandInvocationsResponse> {
    private final SsmClient client;
    private final ListCommandInvocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandInvocationsIterable(SsmClient client, ListCommandInvocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandInvocationsResponseFetcher();
    }

    public Iterator<ListCommandInvocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CommandInvocation> commandInvocations() {
        Function<ListCommandInvocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandInvocations() != null) {
                return response.commandInvocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommandInvocationsResponseFetcher
    implements SyncPageFetcher<ListCommandInvocationsResponse> {
        private ListCommandInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandInvocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommandInvocationsResponse nextPage(ListCommandInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandInvocationsIterable.this.client.listCommandInvocations(ListCommandInvocationsIterable.this.firstRequest);
            }
            return ListCommandInvocationsIterable.this.client.listCommandInvocations((ListCommandInvocationsRequest)((Object)ListCommandInvocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

