/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpsSummaryRequest extends SsmRequest implements
        ToCopyableBuilder<GetOpsSummaryRequest.Builder, GetOpsSummaryRequest> {
    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField
            .<List<OpsFilter>> builder(MarshallingType.LIST)
            .getter(getter(GetOpsSummaryRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<OpsAggregator>> builder(MarshallingType.LIST)
            .getter(getter(GetOpsSummaryRequest::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpsSummaryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetOpsSummaryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            AGGREGATORS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<OpsFilter> filters;

    private final List<OpsAggregator> aggregators;

    private final String nextToken;

    private final Integer maxResults;

    private GetOpsSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Optional filters used to scope down the returned OpsItems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional filters used to scope down the returned OpsItems.
     */
    public List<OpsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Optional aggregators that return counts of OpsItems based on one or more expressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional aggregators that return counts of OpsItems based on one or more expressions.
     */
    public List<OpsAggregator> aggregators() {
        return aggregators;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(aggregators());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsSummaryRequest)) {
            return false;
        }
        GetOpsSummaryRequest other = (GetOpsSummaryRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(aggregators(), other.aggregators())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOpsSummaryRequest").add("Filters", filters()).add("Aggregators", aggregators())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpsSummaryRequest, T> g) {
        return obj -> g.apply((GetOpsSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetOpsSummaryRequest> {
        /**
         * <p>
         * Optional filters used to scope down the returned OpsItems.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OpsFilter> filters);

        /**
         * <p>
         * Optional filters used to scope down the returned OpsItems.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OpsFilter... filters);

        /**
         * <p>
         * Optional filters used to scope down the returned OpsItems.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpsFilter>.Builder} avoiding the need to
         * create one manually via {@link List<OpsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<OpsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<OpsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<OpsFilter>)
         */
        Builder filters(Consumer<OpsFilter.Builder>... filters);

        /**
         * <p>
         * Optional aggregators that return counts of OpsItems based on one or more expressions.
         * </p>
         * 
         * @param aggregators
         *        Optional aggregators that return counts of OpsItems based on one or more expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<OpsAggregator> aggregators);

        /**
         * <p>
         * Optional aggregators that return counts of OpsItems based on one or more expressions.
         * </p>
         * 
         * @param aggregators
         *        Optional aggregators that return counts of OpsItems based on one or more expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(OpsAggregator... aggregators);

        /**
         * <p>
         * Optional aggregators that return counts of OpsItems based on one or more expressions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpsAggregator>.Builder} avoiding the need
         * to create one manually via {@link List<OpsAggregator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsAggregator>.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregators(List<OpsAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on {@link List<OpsAggregator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(List<OpsAggregator>)
         */
        Builder aggregators(Consumer<OpsAggregator.Builder>... aggregators);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpsSummaryRequest model) {
            super(model);
            filters(model.filters);
            aggregators(model.aggregators);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<OpsFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(OpsFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OpsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OpsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<OpsAggregator.Builder> getAggregators() {
            return aggregators != null ? aggregators.stream().map(OpsAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(OpsAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<OpsAggregator.Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> OpsAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAggregators(Collection<OpsAggregator.BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOpsSummaryRequest build() {
            return new GetOpsSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
