/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.ExecutionMode;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAutomationExecutionRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, StartAutomationExecutionRequest> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::documentName)).setter(StartAutomationExecutionRequest.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::documentVersion)).setter(StartAutomationExecutionRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::parameters)).setter(StartAutomationExecutionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::clientToken)).setter(StartAutomationExecutionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::modeAsString)).setter(StartAutomationExecutionRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::targetParameterName)).setter(StartAutomationExecutionRequest.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::targets)).setter(StartAutomationExecutionRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::targetMaps)).setter(StartAutomationExecutionRequest.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::maxConcurrency)).setter(StartAutomationExecutionRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::maxErrors)).setter(StartAutomationExecutionRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartAutomationExecutionRequest.getter(StartAutomationExecutionRequest::targetLocations)).setter(StartAutomationExecutionRequest.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, CLIENT_TOKEN_FIELD, MODE_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_LOCATIONS_FIELD));
    private final String documentName;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final String clientToken;
    private final String mode;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final String maxConcurrency;
    private final String maxErrors;
    private final List<TargetLocation> targetLocations;

    private StartAutomationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.clientToken = builder.clientToken;
        this.mode = builder.mode;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetLocations = builder.targetLocations;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public String targetParameterName() {
        return this.targetParameterName;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMaps());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionRequest)) {
            return false;
        }
        StartAutomationExecutionRequest other = (StartAutomationExecutionRequest)((Object)obj);
        return Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.targetLocations(), other.targetLocations());
    }

    public String toString() {
        return ToString.builder((String)"StartAutomationExecutionRequest").add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", this.parameters()).add("ClientToken", (Object)this.clientToken()).add("Mode", (Object)this.modeAsString()).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.targets()).add("TargetMaps", this.targetMaps()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("TargetLocations", this.targetLocations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAutomationExecutionRequest, T> g) {
        return obj -> g.apply((StartAutomationExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String documentName;
        private String documentVersion;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private String mode;
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private String maxConcurrency;
        private String maxErrors;
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationExecutionRequest model) {
            super(model);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.clientToken(model.clientToken);
            this.mode(model.mode);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.targetLocations(model.targetLocations);
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getModeAsString() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            return this.targetMaps;
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final Collection<TargetLocation.Builder> getTargetLocations() {
            return this.targetLocations != null ? (Collection)this.targetLocations.stream().map(TargetLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomationExecutionRequest build() {
            return new StartAutomationExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAutomationExecutionRequest> {
        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder clientToken(String var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

