/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.NotificationEvent;
import software.amazon.awssdk.services.ssm.model.NotificationEventListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationConfig> {
    private static final SdkField<String> NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationConfig.getter(NotificationConfig::notificationArn)).setter(NotificationConfig.setter(Builder::notificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArn").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(NotificationConfig.getter(NotificationConfig::notificationEventsAsStrings)).setter(NotificationConfig.setter(Builder::notificationEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationConfig.getter(NotificationConfig::notificationTypeAsString)).setter(NotificationConfig.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ARN_FIELD, NOTIFICATION_EVENTS_FIELD, NOTIFICATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String notificationArn;
    private final List<String> notificationEvents;
    private final String notificationType;

    private NotificationConfig(BuilderImpl builder) {
        this.notificationArn = builder.notificationArn;
        this.notificationEvents = builder.notificationEvents;
        this.notificationType = builder.notificationType;
    }

    public String notificationArn() {
        return this.notificationArn;
    }

    public List<NotificationEvent> notificationEvents() {
        return NotificationEventListCopier.copyStringToEnum(this.notificationEvents);
    }

    public List<String> notificationEventsAsStrings() {
        return this.notificationEvents;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeAsString() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEventsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)obj;
        return Objects.equals(this.notificationArn(), other.notificationArn()) && Objects.equals(this.notificationEventsAsStrings(), other.notificationEventsAsStrings()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"NotificationConfig").add("NotificationArn", (Object)this.notificationArn()).add("NotificationEvents", this.notificationEventsAsStrings()).add("NotificationType", (Object)this.notificationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationArn()));
            }
            case "NotificationEvents": {
                return Optional.ofNullable(clazz.cast(this.notificationEventsAsStrings()));
            }
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfig, T> g) {
        return obj -> g.apply((NotificationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notificationArn;
        private List<String> notificationEvents = DefaultSdkAutoConstructList.getInstance();
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfig model) {
            this.notificationArn(model.notificationArn);
            this.notificationEventsWithStrings(model.notificationEvents);
            this.notificationType(model.notificationType);
        }

        public final String getNotificationArn() {
            return this.notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        public final Collection<String> getNotificationEventsAsStrings() {
            return this.notificationEvents;
        }

        @Override
        public final Builder notificationEventsWithStrings(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEventsWithStrings(String ... notificationEvents) {
            this.notificationEventsWithStrings(Arrays.asList(notificationEvents));
            return this;
        }

        @Override
        public final Builder notificationEvents(Collection<NotificationEvent> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copyEnumToString(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(NotificationEvent ... notificationEvents) {
            this.notificationEvents(Arrays.asList(notificationEvents));
            return this;
        }

        public final void setNotificationEventsWithStrings(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
        }

        public final String getNotificationTypeAsString() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public NotificationConfig build() {
            return new NotificationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationConfig> {
        public Builder notificationArn(String var1);

        public Builder notificationEventsWithStrings(Collection<String> var1);

        public Builder notificationEventsWithStrings(String ... var1);

        public Builder notificationEvents(Collection<NotificationEvent> var1);

        public Builder notificationEvents(NotificationEvent ... var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);
    }
}

