/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersRequest extends SsmRequest implements
        ToCopyableBuilder<GetParametersRequest.Builder, GetParametersRequest> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetParametersRequest::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> WITH_DECRYPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetParametersRequest::withDecryption)).setter(setter(Builder::withDecryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithDecryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD,
            WITH_DECRYPTION_FIELD));

    private final List<String> names;

    private final Boolean withDecryption;

    private GetParametersRequest(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
        this.withDecryption = builder.withDecryption;
    }

    /**
     * <p>
     * Names of the parameters for which you want to query information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Names of the parameters for which you want to query information.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored
     * for String and StringList parameter types.
     * </p>
     * 
     * @return Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is
     *         ignored for String and StringList parameter types.
     */
    public Boolean withDecryption() {
        return withDecryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(names());
        hashCode = 31 * hashCode + Objects.hashCode(withDecryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersRequest)) {
            return false;
        }
        GetParametersRequest other = (GetParametersRequest) obj;
        return Objects.equals(names(), other.names()) && Objects.equals(withDecryption(), other.withDecryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetParametersRequest").add("Names", names()).add("WithDecryption", withDecryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "WithDecryption":
            return Optional.ofNullable(clazz.cast(withDecryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersRequest, T> g) {
        return obj -> g.apply((GetParametersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetParametersRequest> {
        /**
         * <p>
         * Names of the parameters for which you want to query information.
         * </p>
         * 
         * @param names
         *        Names of the parameters for which you want to query information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * Names of the parameters for which you want to query information.
         * </p>
         * 
         * @param names
         *        Names of the parameters for which you want to query information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is
         * ignored for String and StringList parameter types.
         * </p>
         * 
         * @param withDecryption
         *        Return decrypted secure string value. Return decrypted values for secure string parameters. This flag
         *        is ignored for String and StringList parameter types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withDecryption(Boolean withDecryption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private Boolean withDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersRequest model) {
            super(model);
            names(model.names);
            withDecryption(model.withDecryption);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        public final Boolean getWithDecryption() {
            return withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersRequest build() {
            return new GetParametersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
