/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchStatus> {
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchStatus.getter(PatchStatus::deploymentStatusAsString)).setter(PatchStatus.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<String> COMPLIANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PatchStatus.getter(PatchStatus::complianceLevelAsString)).setter(PatchStatus.setter(Builder::complianceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceLevel").build()}).build();
    private static final SdkField<Instant> APPROVAL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PatchStatus.getter(PatchStatus::approvalDate)).setter(PatchStatus.setter(Builder::approvalDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STATUS_FIELD, COMPLIANCE_LEVEL_FIELD, APPROVAL_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentStatus;
    private final String complianceLevel;
    private final Instant approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.complianceLevel = builder.complianceLevel;
        this.approvalDate = builder.approvalDate;
    }

    public PatchDeploymentStatus deploymentStatus() {
        return PatchDeploymentStatus.fromValue(this.deploymentStatus);
    }

    public String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public PatchComplianceLevel complianceLevel() {
        return PatchComplianceLevel.fromValue(this.complianceLevel);
    }

    public String complianceLevelAsString() {
        return this.complianceLevel;
    }

    public Instant approvalDate() {
        return this.approvalDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus)obj;
        return Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.complianceLevelAsString(), other.complianceLevelAsString()) && Objects.equals(this.approvalDate(), other.approvalDate());
    }

    public String toString() {
        return ToString.builder((String)"PatchStatus").add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("ComplianceLevel", (Object)this.complianceLevelAsString()).add("ApprovalDate", (Object)this.approvalDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "ComplianceLevel": {
                return Optional.ofNullable(clazz.cast(this.complianceLevelAsString()));
            }
            case "ApprovalDate": {
                return Optional.ofNullable(clazz.cast(this.approvalDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchStatus, T> g) {
        return obj -> g.apply((PatchStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private String complianceLevel;
        private Instant approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            this.deploymentStatus(model.deploymentStatus);
            this.complianceLevel(model.complianceLevel);
            this.approvalDate(model.approvalDate);
        }

        public final String getDeploymentStatusAsString() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getComplianceLevelAsString() {
            return this.complianceLevel;
        }

        @Override
        public final Builder complianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        @Override
        public final Builder complianceLevel(PatchComplianceLevel complianceLevel) {
            this.complianceLevel(complianceLevel.toString());
            return this;
        }

        public final void setComplianceLevel(String complianceLevel) {
            this.complianceLevel = complianceLevel;
        }

        public final Instant getApprovalDate() {
            return this.approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        public PatchStatus build() {
            return new PatchStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchStatus> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(PatchDeploymentStatus var1);

        public Builder complianceLevel(String var1);

        public Builder complianceLevel(PatchComplianceLevel var1);

        public Builder approvalDate(Instant var1);
    }
}

