/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.ActivationListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivationsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeActivationsResponse> {
    private static final SdkField<List<Activation>> ACTIVATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeActivationsResponse.getter(DescribeActivationsResponse::activationList)).setter(DescribeActivationsResponse.setter(Builder::activationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Activation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeActivationsResponse.getter(DescribeActivationsResponse::nextToken)).setter(DescribeActivationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Activation> activationList;
    private final String nextToken;

    private DescribeActivationsResponse(BuilderImpl builder) {
        super(builder);
        this.activationList = builder.activationList;
        this.nextToken = builder.nextToken;
    }

    public List<Activation> activationList() {
        return this.activationList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsResponse)) {
            return false;
        }
        DescribeActivationsResponse other = (DescribeActivationsResponse)((Object)obj);
        return Objects.equals(this.activationList(), other.activationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivationsResponse").add("ActivationList", this.activationList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationList": {
                return Optional.ofNullable(clazz.cast(this.activationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivationsResponse, T> g) {
        return obj -> g.apply((DescribeActivationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<Activation> activationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsResponse model) {
            super(model);
            this.activationList(model.activationList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Activation.Builder> getActivationList() {
            return this.activationList != null ? (Collection)this.activationList.stream().map(Activation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Activation ... activationList) {
            this.activationList(Arrays.asList(activationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Consumer<Activation.Builder> ... activationList) {
            this.activationList(Stream.of(activationList).map(c -> (Activation)((Activation.Builder)Activation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActivationList(Collection<Activation.BuilderImpl> activationList) {
            this.activationList = ActivationListCopier.copyFromBuilder(activationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeActivationsResponse build() {
            return new DescribeActivationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivationsResponse> {
        public Builder activationList(Collection<Activation> var1);

        public Builder activationList(Activation ... var1);

        public Builder activationList(Consumer<Activation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

