/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for Session Manager information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionFilter implements SdkPojo, Serializable, ToCopyableBuilder<SessionFilter.Builder, SessionFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SessionFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SessionFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private SessionFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link SessionFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see SessionFilterKey
     */
    public SessionFilterKey key() {
        return SessionFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link SessionFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see SessionFilterKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The filter value. Valid values for each filter key are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see
     * sessions that started August 29, 2018, and later.
     * </p>
     * </li>
     * <li>
     * <p>
     * InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see
     * sessions that started before August 29, 2018.
     * </p>
     * </li>
     * <li>
     * <p>
     * Target: Specify an instance to which session connections have been made.
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner: Specify an AWS user account to see a list of sessions started by that user.
     * </p>
     * </li>
     * <li>
     * <p>
     * Status: Specify a valid session status to see a list of all sessions with that status. Status values you can
     * specify include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Connected
     * </p>
     * </li>
     * <li>
     * <p>
     * Connecting
     * </p>
     * </li>
     * <li>
     * <p>
     * Disconnected
     * </p>
     * </li>
     * <li>
     * <p>
     * Terminated
     * </p>
     * </li>
     * <li>
     * <p>
     * Terminating
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The filter value. Valid values for each filter key are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see
     *         sessions that started August 29, 2018, and later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to
     *         see sessions that started before August 29, 2018.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Target: Specify an instance to which session connections have been made.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Owner: Specify an AWS user account to see a list of sessions started by that user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Status: Specify a valid session status to see a list of all sessions with that status. Status values you
     *         can specify include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Connected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Connecting
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Disconnected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Terminated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Terminating
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionFilter)) {
            return false;
        }
        SessionFilter other = (SessionFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SessionFilter").add("Key", keyAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionFilter, T> g) {
        return obj -> g.apply((SessionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see SessionFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see SessionFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionFilterKey
         */
        Builder key(SessionFilterKey key);

        /**
         * <p>
         * The filter value. Valid values for each filter key are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see
         * sessions that started August 29, 2018, and later.
         * </p>
         * </li>
         * <li>
         * <p>
         * InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see
         * sessions that started before August 29, 2018.
         * </p>
         * </li>
         * <li>
         * <p>
         * Target: Specify an instance to which session connections have been made.
         * </p>
         * </li>
         * <li>
         * <p>
         * Owner: Specify an AWS user account to see a list of sessions started by that user.
         * </p>
         * </li>
         * <li>
         * <p>
         * Status: Specify a valid session status to see a list of all sessions with that status. Status values you can
         * specify include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Connected
         * </p>
         * </li>
         * <li>
         * <p>
         * Connecting
         * </p>
         * </li>
         * <li>
         * <p>
         * Disconnected
         * </p>
         * </li>
         * <li>
         * <p>
         * Terminated
         * </p>
         * </li>
         * <li>
         * <p>
         * Terminating
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param value
         *        The filter value. Valid values for each filter key are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to
         *        see sessions that started August 29, 2018, and later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to
         *        see sessions that started before August 29, 2018.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Target: Specify an instance to which session connections have been made.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Owner: Specify an AWS user account to see a list of sessions started by that user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Status: Specify a valid session status to see a list of all sessions with that status. Status values
         *        you can specify include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Connected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Connecting
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Disconnected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Terminated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Terminating
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionFilter model) {
            key(model.key);
            value(model.value);
        }

        public final String getKeyAsString() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(SessionFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public SessionFilter build() {
            return new SessionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
