/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePatchBaselinesResponse extends SsmResponse implements
        ToCopyableBuilder<DescribePatchBaselinesResponse.Builder, DescribePatchBaselinesResponse> {
    private static final SdkField<List<PatchBaselineIdentity>> BASELINE_IDENTITIES_FIELD = SdkField
            .<List<PatchBaselineIdentity>> builder(MarshallingType.LIST)
            .getter(getter(DescribePatchBaselinesResponse::baselineIdentities))
            .setter(setter(Builder::baselineIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchBaselineIdentity> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchBaselineIdentity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePatchBaselinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_IDENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PatchBaselineIdentity> baselineIdentities;

    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        super(builder);
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of PatchBaselineIdentity elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of PatchBaselineIdentity elements.
     */
    public List<PatchBaselineIdentity> baselineIdentities() {
        return baselineIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse) obj;
        return Objects.equals(baselineIdentities(), other.baselineIdentities()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePatchBaselinesResponse").add("BaselineIdentities", baselineIdentities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineIdentities":
            return Optional.ofNullable(clazz.cast(baselineIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchBaselinesResponse, T> g) {
        return obj -> g.apply((DescribePatchBaselinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities);

        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities);

        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchBaselineIdentity>.Builder} avoiding
         * the need to create one manually via {@link List<PatchBaselineIdentity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchBaselineIdentity>.Builder#build()} is called
         * immediately and its result is passed to {@link #baselineIdentities(List<PatchBaselineIdentity>)}.
         * 
         * @param baselineIdentities
         *        a consumer that will call methods on {@link List<PatchBaselineIdentity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineIdentities(List<PatchBaselineIdentity>)
         */
        Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder>... baselineIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            super(model);
            baselineIdentities(model.baselineIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity.Builder> getBaselineIdentities() {
            return baselineIdentities != null ? baselineIdentities.stream().map(PatchBaselineIdentity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities) {
            baselineIdentities(Arrays.asList(baselineIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder>... baselineIdentities) {
            baselineIdentities(Stream.of(baselineIdentities).map(c -> PatchBaselineIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity.BuilderImpl> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copyFromBuilder(baselineIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
