/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;

public class DescribeMaintenanceWindowExecutionsIterable
implements SdkIterable<DescribeMaintenanceWindowExecutionsResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowExecutionsIterable(SsmClient client, DescribeMaintenanceWindowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMaintenanceWindowExecutionsResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowExecution> windowExecutions() {
        Function<DescribeMaintenanceWindowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.windowExecutions() != null) {
                return response.windowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowExecutionsResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowExecutionsResponse> {
        private DescribeMaintenanceWindowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowExecutionsResponse nextPage(DescribeMaintenanceWindowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowExecutionsIterable.this.client.describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowExecutionsIterable.this.client.describeMaintenanceWindowExecutions((DescribeMaintenanceWindowExecutionsRequest)((Object)DescribeMaintenanceWindowExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

