/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;

public class DescribeInstanceAssociationsStatusIterable
implements SdkIterable<DescribeInstanceAssociationsStatusResponse> {
    private final SsmClient client;
    private final DescribeInstanceAssociationsStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceAssociationsStatusIterable(SsmClient client, DescribeInstanceAssociationsStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceAssociationsStatusResponseFetcher();
    }

    public Iterator<DescribeInstanceAssociationsStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        Function<DescribeInstanceAssociationsStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceAssociationStatusInfos() != null) {
                return response.instanceAssociationStatusInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceAssociationsStatusResponseFetcher
    implements SyncPageFetcher<DescribeInstanceAssociationsStatusResponse> {
        private DescribeInstanceAssociationsStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceAssociationsStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceAssociationsStatusResponse nextPage(DescribeInstanceAssociationsStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceAssociationsStatusIterable.this.client.describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusIterable.this.firstRequest);
            }
            return DescribeInstanceAssociationsStatusIterable.this.client.describeInstanceAssociationsStatus((DescribeInstanceAssociationsStatusRequest)((Object)DescribeInstanceAssociationsStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

