/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.Patch;

public class DescribeAvailablePatchesPublisher
implements SdkPublisher<DescribeAvailablePatchesResponse> {
    private final SsmAsyncClient client;
    private final DescribeAvailablePatchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAvailablePatchesPublisher(SsmAsyncClient client, DescribeAvailablePatchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAvailablePatchesPublisher(SsmAsyncClient client, DescribeAvailablePatchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAvailablePatchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAvailablePatchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Patch> patches() {
        Function<DescribeAvailablePatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.patches() != null) {
                return response.patches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAvailablePatchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAvailablePatchesResponseFetcher
    implements AsyncPageFetcher<DescribeAvailablePatchesResponse> {
        private DescribeAvailablePatchesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAvailablePatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAvailablePatchesResponse> nextPage(DescribeAvailablePatchesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAvailablePatchesPublisher.this.client.describeAvailablePatches(DescribeAvailablePatchesPublisher.this.firstRequest);
            }
            return DescribeAvailablePatchesPublisher.this.client.describeAvailablePatches((DescribeAvailablePatchesRequest)((Object)DescribeAvailablePatchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

