/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemEventSummary;

public class ListOpsItemEventsIterable
implements SdkIterable<ListOpsItemEventsResponse> {
    private final SsmClient client;
    private final ListOpsItemEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpsItemEventsIterable(SsmClient client, ListOpsItemEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOpsItemEventsResponseFetcher();
    }

    public Iterator<ListOpsItemEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OpsItemEventSummary> summaries() {
        Function<ListOpsItemEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpsItemEventsResponseFetcher
    implements SyncPageFetcher<ListOpsItemEventsResponse> {
        private ListOpsItemEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsItemEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOpsItemEventsResponse nextPage(ListOpsItemEventsResponse previousPage) {
            if (previousPage == null) {
                return ListOpsItemEventsIterable.this.client.listOpsItemEvents(ListOpsItemEventsIterable.this.firstRequest);
            }
            return ListOpsItemEventsIterable.this.client.listOpsItemEvents((ListOpsItemEventsRequest)((Object)ListOpsItemEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

