/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about related-item resources for an OpsItem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemRelatedItemSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OpsItemRelatedItemSummary.Builder, OpsItemRelatedItemSummary> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(OpsItemRelatedItemSummary::opsItemId)).setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(OpsItemRelatedItemSummary::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(OpsItemRelatedItemSummary::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(OpsItemRelatedItemSummary::associationType))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final SdkField<String> RESOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceUri").getter(getter(OpsItemRelatedItemSummary::resourceUri))
            .setter(setter(Builder::resourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUri").build()).build();

    private static final SdkField<OpsItemIdentity> CREATED_BY_FIELD = SdkField
            .<OpsItemIdentity> builder(MarshallingType.SDK_POJO).memberName("CreatedBy")
            .getter(getter(OpsItemRelatedItemSummary::createdBy)).setter(setter(Builder::createdBy))
            .constructor(OpsItemIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(OpsItemRelatedItemSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<OpsItemIdentity> LAST_MODIFIED_BY_FIELD = SdkField
            .<OpsItemIdentity> builder(MarshallingType.SDK_POJO).memberName("LastModifiedBy")
            .getter(getter(OpsItemRelatedItemSummary::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(OpsItemIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(OpsItemRelatedItemSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD,
            ASSOCIATION_ID_FIELD, RESOURCE_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, RESOURCE_URI_FIELD, CREATED_BY_FIELD,
            CREATED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String opsItemId;

    private final String associationId;

    private final String resourceType;

    private final String associationType;

    private final String resourceUri;

    private final OpsItemIdentity createdBy;

    private final Instant createdTime;

    private final OpsItemIdentity lastModifiedBy;

    private final Instant lastModifiedTime;

    private OpsItemRelatedItemSummary(BuilderImpl builder) {
        this.opsItemId = builder.opsItemId;
        this.associationId = builder.associationId;
        this.resourceType = builder.resourceType;
        this.associationType = builder.associationType;
        this.resourceUri = builder.resourceUri;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The OpsItem ID.
     * </p>
     * 
     * @return The OpsItem ID.
     */
    public final String opsItemId() {
        return opsItemId;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The association type.
     * </p>
     * 
     * @return The association type.
     */
    public final String associationType() {
        return associationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the related-item resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the related-item resource.
     */
    public final String resourceUri() {
        return resourceUri;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final OpsItemIdentity createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The time the related-item association was created.
     * </p>
     * 
     * @return The time the related-item association was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final OpsItemIdentity lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The time the related-item association was last updated.
     * </p>
     * 
     * @return The time the related-item association was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(associationType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemRelatedItemSummary)) {
            return false;
        }
        OpsItemRelatedItemSummary other = (OpsItemRelatedItemSummary) obj;
        return Objects.equals(opsItemId(), other.opsItemId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(associationType(), other.associationType())
                && Objects.equals(resourceUri(), other.resourceUri()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpsItemRelatedItemSummary").add("OpsItemId", opsItemId()).add("AssociationId", associationId())
                .add("ResourceType", resourceType()).add("AssociationType", associationType()).add("ResourceUri", resourceUri())
                .add("CreatedBy", createdBy()).add("CreatedTime", createdTime()).add("LastModifiedBy", lastModifiedBy())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationType()));
        case "ResourceUri":
            return Optional.ofNullable(clazz.cast(resourceUri()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpsItemId", OPS_ITEM_ID_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("AssociationType", ASSOCIATION_TYPE_FIELD);
        map.put("ResourceUri", RESOURCE_URI_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsItemRelatedItemSummary, T> g) {
        return obj -> g.apply((OpsItemRelatedItemSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemRelatedItemSummary> {
        /**
         * <p>
         * The OpsItem ID.
         * </p>
         * 
         * @param opsItemId
         *        The OpsItem ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The association type.
         * </p>
         * 
         * @param associationType
         *        The association type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the related-item resource.
         * </p>
         * 
         * @param resourceUri
         *        The Amazon Resource Name (ARN) of the related-item resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUri(String resourceUri);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(OpsItemIdentity createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpsItemIdentity.Builder} avoiding the
         * need to create one manually via {@link OpsItemIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpsItemIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(OpsItemIdentity)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link OpsItemIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(OpsItemIdentity)
         */
        default Builder createdBy(Consumer<OpsItemIdentity.Builder> createdBy) {
            return createdBy(OpsItemIdentity.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The time the related-item association was created.
         * </p>
         * 
         * @param createdTime
         *        The time the related-item association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(OpsItemIdentity lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpsItemIdentity.Builder} avoiding the
         * need to create one manually via {@link OpsItemIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpsItemIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #lastModifiedBy(OpsItemIdentity)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link OpsItemIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(OpsItemIdentity)
         */
        default Builder lastModifiedBy(Consumer<OpsItemIdentity.Builder> lastModifiedBy) {
            return lastModifiedBy(OpsItemIdentity.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The time the related-item association was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time the related-item association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String opsItemId;

        private String associationId;

        private String resourceType;

        private String associationType;

        private String resourceUri;

        private OpsItemIdentity createdBy;

        private Instant createdTime;

        private OpsItemIdentity lastModifiedBy;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemRelatedItemSummary model) {
            opsItemId(model.opsItemId);
            associationId(model.associationId);
            resourceType(model.resourceType);
            associationType(model.associationType);
            resourceUri(model.resourceUri);
            createdBy(model.createdBy);
            createdTime(model.createdTime);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        public final String getResourceUri() {
            return resourceUri;
        }

        public final void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        @Override
        public final Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            return this;
        }

        public final OpsItemIdentity.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(OpsItemIdentity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(OpsItemIdentity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final OpsItemIdentity.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(OpsItemIdentity.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(OpsItemIdentity lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public OpsItemRelatedItemSummary build() {
            return new OpsItemRelatedItemSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
