/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowScheduleResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowScheduleResponse.Builder, DescribeMaintenanceWindowScheduleResponse> {
    private static final SdkField<List<ScheduledWindowExecution>> SCHEDULED_WINDOW_EXECUTIONS_FIELD = SdkField
            .<List<ScheduledWindowExecution>> builder(MarshallingType.LIST)
            .memberName("ScheduledWindowExecutions")
            .getter(getter(DescribeMaintenanceWindowScheduleResponse::scheduledWindowExecutions))
            .setter(setter(Builder::scheduledWindowExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledWindowExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledWindowExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledWindowExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMaintenanceWindowScheduleResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCHEDULED_WINDOW_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScheduledWindowExecution> scheduledWindowExecutions;

    private final String nextToken;

    private DescribeMaintenanceWindowScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledWindowExecutions = builder.scheduledWindowExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledWindowExecutions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScheduledWindowExecutions() {
        return scheduledWindowExecutions != null && !(scheduledWindowExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about maintenance window executions scheduled for the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledWindowExecutions} method.
     * </p>
     * 
     * @return Information about maintenance window executions scheduled for the specified time range.
     */
    public final List<ScheduledWindowExecution> scheduledWindowExecutions() {
        return scheduledWindowExecutions;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You use this token in the next call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You use this token in the next call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledWindowExecutions() ? scheduledWindowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowScheduleResponse)) {
            return false;
        }
        DescribeMaintenanceWindowScheduleResponse other = (DescribeMaintenanceWindowScheduleResponse) obj;
        return hasScheduledWindowExecutions() == other.hasScheduledWindowExecutions()
                && Objects.equals(scheduledWindowExecutions(), other.scheduledWindowExecutions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMaintenanceWindowScheduleResponse")
                .add("ScheduledWindowExecutions", hasScheduledWindowExecutions() ? scheduledWindowExecutions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledWindowExecutions":
            return Optional.ofNullable(clazz.cast(scheduledWindowExecutions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledWindowExecutions", SCHEDULED_WINDOW_EXECUTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowScheduleResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowScheduleResponse> {
        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * 
         * @param scheduledWindowExecutions
         *        Information about maintenance window executions scheduled for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> scheduledWindowExecutions);

        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * 
         * @param scheduledWindowExecutions
         *        Information about maintenance window executions scheduled for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledWindowExecutions(ScheduledWindowExecution... scheduledWindowExecutions);

        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledWindowExecutions(List<ScheduledWindowExecution>)}.
         * 
         * @param scheduledWindowExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledWindowExecutions(java.util.Collection<ScheduledWindowExecution>)
         */
        Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder>... scheduledWindowExecutions);

        /**
         * <p>
         * The token for the next set of items to return. (You use this token in the next call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You use this token in the next call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<ScheduledWindowExecution> scheduledWindowExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowScheduleResponse model) {
            super(model);
            scheduledWindowExecutions(model.scheduledWindowExecutions);
            nextToken(model.nextToken);
        }

        public final List<ScheduledWindowExecution.Builder> getScheduledWindowExecutions() {
            List<ScheduledWindowExecution.Builder> result = ScheduledWindowExecutionListCopier
                    .copyToBuilder(this.scheduledWindowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledWindowExecutions(Collection<ScheduledWindowExecution.BuilderImpl> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copyFromBuilder(scheduledWindowExecutions);
        }

        @Override
        public final Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copy(scheduledWindowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(ScheduledWindowExecution... scheduledWindowExecutions) {
            scheduledWindowExecutions(Arrays.asList(scheduledWindowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder>... scheduledWindowExecutions) {
            scheduledWindowExecutions(Stream.of(scheduledWindowExecutions)
                    .map(c -> ScheduledWindowExecution.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowScheduleResponse build() {
            return new DescribeMaintenanceWindowScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
