/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ExecutionPreview;
import software.amazon.awssdk.services.ssm.model.ExecutionPreviewStatus;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExecutionPreviewResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetExecutionPreviewResponse> {
    private static final SdkField<String> EXECUTION_PREVIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionPreviewId").getter(GetExecutionPreviewResponse.getter(GetExecutionPreviewResponse::executionPreviewId)).setter(GetExecutionPreviewResponse.setter(Builder::executionPreviewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionPreviewId").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(GetExecutionPreviewResponse.getter(GetExecutionPreviewResponse::endedAt)).setter(GetExecutionPreviewResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetExecutionPreviewResponse.getter(GetExecutionPreviewResponse::statusAsString)).setter(GetExecutionPreviewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetExecutionPreviewResponse.getter(GetExecutionPreviewResponse::statusMessage)).setter(GetExecutionPreviewResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<ExecutionPreview> EXECUTION_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionPreview").getter(GetExecutionPreviewResponse.getter(GetExecutionPreviewResponse::executionPreview)).setter(GetExecutionPreviewResponse.setter(Builder::executionPreview)).constructor(ExecutionPreview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionPreview").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_PREVIEW_ID_FIELD, ENDED_AT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_PREVIEW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExecutionPreviewResponse.memberNameToFieldInitializer();
    private final String executionPreviewId;
    private final Instant endedAt;
    private final String status;
    private final String statusMessage;
    private final ExecutionPreview executionPreview;

    private GetExecutionPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.executionPreviewId = builder.executionPreviewId;
        this.endedAt = builder.endedAt;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.executionPreview = builder.executionPreview;
    }

    public final String executionPreviewId() {
        return this.executionPreviewId;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final ExecutionPreviewStatus status() {
        return ExecutionPreviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ExecutionPreview executionPreview() {
        return this.executionPreview;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionPreviewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionPreview());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionPreviewResponse)) {
            return false;
        }
        GetExecutionPreviewResponse other = (GetExecutionPreviewResponse)((Object)obj);
        return Objects.equals(this.executionPreviewId(), other.executionPreviewId()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.executionPreview(), other.executionPreview());
    }

    public final String toString() {
        return ToString.builder((String)"GetExecutionPreviewResponse").add("ExecutionPreviewId", (Object)this.executionPreviewId()).add("EndedAt", (Object)this.endedAt()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ExecutionPreview", (Object)this.executionPreview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionPreviewId": {
                return Optional.ofNullable(clazz.cast(this.executionPreviewId()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ExecutionPreview": {
                return Optional.ofNullable(clazz.cast(this.executionPreview()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionPreviewId", EXECUTION_PREVIEW_ID_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExecutionPreview", EXECUTION_PREVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionPreviewResponse, T> g) {
        return obj -> g.apply((GetExecutionPreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String executionPreviewId;
        private Instant endedAt;
        private String status;
        private String statusMessage;
        private ExecutionPreview executionPreview;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionPreviewResponse model) {
            super(model);
            this.executionPreviewId(model.executionPreviewId);
            this.endedAt(model.endedAt);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.executionPreview(model.executionPreview);
        }

        public final String getExecutionPreviewId() {
            return this.executionPreviewId;
        }

        public final void setExecutionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
        }

        @Override
        public final Builder executionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ExecutionPreview.Builder getExecutionPreview() {
            return this.executionPreview != null ? this.executionPreview.toBuilder() : null;
        }

        public final void setExecutionPreview(ExecutionPreview.BuilderImpl executionPreview) {
            this.executionPreview = executionPreview != null ? executionPreview.build() : null;
        }

        @Override
        public final Builder executionPreview(ExecutionPreview executionPreview) {
            this.executionPreview = executionPreview;
            return this;
        }

        @Override
        public GetExecutionPreviewResponse build() {
            return new GetExecutionPreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExecutionPreviewResponse> {
        public Builder executionPreviewId(String var1);

        public Builder endedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionPreviewStatus var1);

        public Builder statusMessage(String var1);

        public Builder executionPreview(ExecutionPreview var1);

        default public Builder executionPreview(Consumer<ExecutionPreview.Builder> executionPreview) {
            return this.executionPreview((ExecutionPreview)((ExecutionPreview.Builder)ExecutionPreview.builder().applyMutation(executionPreview)).build());
        }
    }
}

