/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandFilterKey {
    INVOKED_AFTER("InvokedAfter"),
    INVOKED_BEFORE("InvokedBefore"),
    STATUS("Status"),
    EXECUTION_STAGE("ExecutionStage"),
    DOCUMENT_NAME("DocumentName"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandFilterKey> VALUE_MAP;
    private final String value;

    private CommandFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandFilterKey> knownValues() {
        EnumSet<CommandFilterKey> knownValues = EnumSet.allOf(CommandFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandFilterKey.class, CommandFilterKey::toString);
    }
}

