/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowsForTargetListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowsForTargetResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowsForTargetResponse> {
    private static final SdkField<List<MaintenanceWindowIdentityForTarget>> WINDOW_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WindowIdentities").getter(DescribeMaintenanceWindowsForTargetResponse.getter(DescribeMaintenanceWindowsForTargetResponse::windowIdentities)).setter(DescribeMaintenanceWindowsForTargetResponse.setter(Builder::windowIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowIdentityForTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowsForTargetResponse.getter(DescribeMaintenanceWindowsForTargetResponse::nextToken)).setter(DescribeMaintenanceWindowsForTargetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMaintenanceWindowsForTargetResponse.memberNameToFieldInitializer();
    private final List<MaintenanceWindowIdentityForTarget> windowIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowsForTargetResponse(BuilderImpl builder) {
        super(builder);
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWindowIdentities() {
        return this.windowIdentities != null && !(this.windowIdentities instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindowIdentityForTarget> windowIdentities() {
        return this.windowIdentities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWindowIdentities() ? this.windowIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsForTargetResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsForTargetResponse other = (DescribeMaintenanceWindowsForTargetResponse)((Object)obj);
        return this.hasWindowIdentities() == other.hasWindowIdentities() && Objects.equals(this.windowIdentities(), other.windowIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowsForTargetResponse").add("WindowIdentities", this.hasWindowIdentities() ? this.windowIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowIdentities": {
                return Optional.ofNullable(clazz.cast(this.windowIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WindowIdentities", WINDOW_IDENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowsForTargetResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowsForTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowIdentityForTarget> windowIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsForTargetResponse model) {
            super(model);
            this.windowIdentities(model.windowIdentities);
            this.nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowIdentityForTarget.Builder> getWindowIdentities() {
            List<MaintenanceWindowIdentityForTarget.Builder> result = MaintenanceWindowsForTargetListCopier.copyToBuilder(this.windowIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentityForTarget.BuilderImpl> windowIdentities) {
            this.windowIdentities = MaintenanceWindowsForTargetListCopier.copyFromBuilder(windowIdentities);
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentityForTarget> windowIdentities) {
            this.windowIdentities = MaintenanceWindowsForTargetListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentityForTarget ... windowIdentities) {
            this.windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(Consumer<MaintenanceWindowIdentityForTarget.Builder> ... windowIdentities) {
            this.windowIdentities(Stream.of(windowIdentities).map(c -> (MaintenanceWindowIdentityForTarget)((MaintenanceWindowIdentityForTarget.Builder)MaintenanceWindowIdentityForTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowsForTargetResponse build() {
            return new DescribeMaintenanceWindowsForTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowsForTargetResponse> {
        public Builder windowIdentities(Collection<MaintenanceWindowIdentityForTarget> var1);

        public Builder windowIdentities(MaintenanceWindowIdentityForTarget ... var1);

        public Builder windowIdentities(Consumer<MaintenanceWindowIdentityForTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

