/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information returned by the <code>DeleteInventory</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryDeletionStatusItem implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryDeletionStatusItem.Builder, InventoryDeletionStatusItem> {
    private static final SdkField<String> DELETION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionId").getter(getter(InventoryDeletionStatusItem::deletionId)).setter(setter(Builder::deletionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionId").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(InventoryDeletionStatusItem::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<Instant> DELETION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionStartTime").getter(getter(InventoryDeletionStatusItem::deletionStartTime))
            .setter(setter(Builder::deletionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStartTime").build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastStatus").getter(getter(InventoryDeletionStatusItem::lastStatusAsString))
            .setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatus").build()).build();

    private static final SdkField<String> LAST_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastStatusMessage").getter(getter(InventoryDeletionStatusItem::lastStatusMessage))
            .setter(setter(Builder::lastStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusMessage").build()).build();

    private static final SdkField<InventoryDeletionSummary> DELETION_SUMMARY_FIELD = SdkField
            .<InventoryDeletionSummary> builder(MarshallingType.SDK_POJO).memberName("DeletionSummary")
            .getter(getter(InventoryDeletionStatusItem::deletionSummary)).setter(setter(Builder::deletionSummary))
            .constructor(InventoryDeletionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionSummary").build()).build();

    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastStatusUpdateTime").getter(getter(InventoryDeletionStatusItem::lastStatusUpdateTime))
            .setter(setter(Builder::lastStatusUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusUpdateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_ID_FIELD,
            TYPE_NAME_FIELD, DELETION_START_TIME_FIELD, LAST_STATUS_FIELD, LAST_STATUS_MESSAGE_FIELD, DELETION_SUMMARY_FIELD,
            LAST_STATUS_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deletionId;

    private final String typeName;

    private final Instant deletionStartTime;

    private final String lastStatus;

    private final String lastStatusMessage;

    private final InventoryDeletionSummary deletionSummary;

    private final Instant lastStatusUpdateTime;

    private InventoryDeletionStatusItem(BuilderImpl builder) {
        this.deletionId = builder.deletionId;
        this.typeName = builder.typeName;
        this.deletionStartTime = builder.deletionStartTime;
        this.lastStatus = builder.lastStatus;
        this.lastStatusMessage = builder.lastStatusMessage;
        this.deletionSummary = builder.deletionSummary;
        this.lastStatusUpdateTime = builder.lastStatusUpdateTime;
    }

    /**
     * <p>
     * The deletion ID returned by the <code>DeleteInventory</code> operation.
     * </p>
     * 
     * @return The deletion ID returned by the <code>DeleteInventory</code> operation.
     */
    public final String deletionId() {
        return deletionId;
    }

    /**
     * <p>
     * The name of the inventory data type.
     * </p>
     * 
     * @return The name of the inventory data type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The UTC timestamp when the delete operation started.
     * </p>
     * 
     * @return The UTC timestamp when the delete operation started.
     */
    public final Instant deletionStartTime() {
        return deletionStartTime;
    }

    /**
     * <p>
     * The status of the operation. Possible values are InProgress and Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link InventoryDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The status of the operation. Possible values are InProgress and Complete.
     * @see InventoryDeletionStatus
     */
    public final InventoryDeletionStatus lastStatus() {
        return InventoryDeletionStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * The status of the operation. Possible values are InProgress and Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link InventoryDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastStatusAsString}.
     * </p>
     * 
     * @return The status of the operation. Possible values are InProgress and Complete.
     * @see InventoryDeletionStatus
     */
    public final String lastStatusAsString() {
        return lastStatus;
    }

    /**
     * <p>
     * Information about the status.
     * </p>
     * 
     * @return Information about the status.
     */
    public final String lastStatusMessage() {
        return lastStatusMessage;
    }

    /**
     * <p>
     * Information about the delete operation. For more information about this summary, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete"
     * >Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * 
     * @return Information about the delete operation. For more information about this summary, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete"
     *         >Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.
     */
    public final InventoryDeletionSummary deletionSummary() {
        return deletionSummary;
    }

    /**
     * <p>
     * The UTC timestamp of when the last status report.
     * </p>
     * 
     * @return The UTC timestamp of when the last status report.
     */
    public final Instant lastStatusUpdateTime() {
        return lastStatusUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deletionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(deletionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionStatusItem)) {
            return false;
        }
        InventoryDeletionStatusItem other = (InventoryDeletionStatusItem) obj;
        return Objects.equals(deletionId(), other.deletionId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(deletionStartTime(), other.deletionStartTime())
                && Objects.equals(lastStatusAsString(), other.lastStatusAsString())
                && Objects.equals(lastStatusMessage(), other.lastStatusMessage())
                && Objects.equals(deletionSummary(), other.deletionSummary())
                && Objects.equals(lastStatusUpdateTime(), other.lastStatusUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryDeletionStatusItem").add("DeletionId", deletionId()).add("TypeName", typeName())
                .add("DeletionStartTime", deletionStartTime()).add("LastStatus", lastStatusAsString())
                .add("LastStatusMessage", lastStatusMessage()).add("DeletionSummary", deletionSummary())
                .add("LastStatusUpdateTime", lastStatusUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionId":
            return Optional.ofNullable(clazz.cast(deletionId()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DeletionStartTime":
            return Optional.ofNullable(clazz.cast(deletionStartTime()));
        case "LastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        case "LastStatusMessage":
            return Optional.ofNullable(clazz.cast(lastStatusMessage()));
        case "DeletionSummary":
            return Optional.ofNullable(clazz.cast(deletionSummary()));
        case "LastStatusUpdateTime":
            return Optional.ofNullable(clazz.cast(lastStatusUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionStatusItem, T> g) {
        return obj -> g.apply((InventoryDeletionStatusItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryDeletionStatusItem> {
        /**
         * <p>
         * The deletion ID returned by the <code>DeleteInventory</code> operation.
         * </p>
         * 
         * @param deletionId
         *        The deletion ID returned by the <code>DeleteInventory</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionId(String deletionId);

        /**
         * <p>
         * The name of the inventory data type.
         * </p>
         * 
         * @param typeName
         *        The name of the inventory data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The UTC timestamp when the delete operation started.
         * </p>
         * 
         * @param deletionStartTime
         *        The UTC timestamp when the delete operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionStartTime(Instant deletionStartTime);

        /**
         * <p>
         * The status of the operation. Possible values are InProgress and Complete.
         * </p>
         * 
         * @param lastStatus
         *        The status of the operation. Possible values are InProgress and Complete.
         * @see InventoryDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryDeletionStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The status of the operation. Possible values are InProgress and Complete.
         * </p>
         * 
         * @param lastStatus
         *        The status of the operation. Possible values are InProgress and Complete.
         * @see InventoryDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryDeletionStatus
         */
        Builder lastStatus(InventoryDeletionStatus lastStatus);

        /**
         * <p>
         * Information about the status.
         * </p>
         * 
         * @param lastStatusMessage
         *        Information about the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusMessage(String lastStatusMessage);

        /**
         * <p>
         * Information about the delete operation. For more information about this summary, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete"
         * >Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * 
         * @param deletionSummary
         *        Information about the delete operation. For more information about this summary, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete"
         *        >Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionSummary(InventoryDeletionSummary deletionSummary);

        /**
         * <p>
         * Information about the delete operation. For more information about this summary, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete"
         * >Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InventoryDeletionSummary.Builder}
         * avoiding the need to create one manually via {@link InventoryDeletionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InventoryDeletionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #deletionSummary(InventoryDeletionSummary)}.
         * 
         * @param deletionSummary
         *        a consumer that will call methods on {@link InventoryDeletionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletionSummary(InventoryDeletionSummary)
         */
        default Builder deletionSummary(Consumer<InventoryDeletionSummary.Builder> deletionSummary) {
            return deletionSummary(InventoryDeletionSummary.builder().applyMutation(deletionSummary).build());
        }

        /**
         * <p>
         * The UTC timestamp of when the last status report.
         * </p>
         * 
         * @param lastStatusUpdateTime
         *        The UTC timestamp of when the last status report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusUpdateTime(Instant lastStatusUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String deletionId;

        private String typeName;

        private Instant deletionStartTime;

        private String lastStatus;

        private String lastStatusMessage;

        private InventoryDeletionSummary deletionSummary;

        private Instant lastStatusUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionStatusItem model) {
            deletionId(model.deletionId);
            typeName(model.typeName);
            deletionStartTime(model.deletionStartTime);
            lastStatus(model.lastStatus);
            lastStatusMessage(model.lastStatusMessage);
            deletionSummary(model.deletionSummary);
            lastStatusUpdateTime(model.lastStatusUpdateTime);
        }

        public final String getDeletionId() {
            return deletionId;
        }

        public final void setDeletionId(String deletionId) {
            this.deletionId = deletionId;
        }

        @Override
        public final Builder deletionId(String deletionId) {
            this.deletionId = deletionId;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final Instant getDeletionStartTime() {
            return deletionStartTime;
        }

        public final void setDeletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
        }

        @Override
        public final Builder deletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
            return this;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(InventoryDeletionStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final String getLastStatusMessage() {
            return lastStatusMessage;
        }

        public final void setLastStatusMessage(String lastStatusMessage) {
            this.lastStatusMessage = lastStatusMessage;
        }

        @Override
        public final Builder lastStatusMessage(String lastStatusMessage) {
            this.lastStatusMessage = lastStatusMessage;
            return this;
        }

        public final InventoryDeletionSummary.Builder getDeletionSummary() {
            return deletionSummary != null ? deletionSummary.toBuilder() : null;
        }

        public final void setDeletionSummary(InventoryDeletionSummary.BuilderImpl deletionSummary) {
            this.deletionSummary = deletionSummary != null ? deletionSummary.build() : null;
        }

        @Override
        public final Builder deletionSummary(InventoryDeletionSummary deletionSummary) {
            this.deletionSummary = deletionSummary;
            return this;
        }

        public final Instant getLastStatusUpdateTime() {
            return lastStatusUpdateTime;
        }

        public final void setLastStatusUpdateTime(Instant lastStatusUpdateTime) {
            this.lastStatusUpdateTime = lastStatusUpdateTime;
        }

        @Override
        public final Builder lastStatusUpdateTime(Instant lastStatusUpdateTime) {
            this.lastStatusUpdateTime = lastStatusUpdateTime;
            return this;
        }

        @Override
        public InventoryDeletionStatusItem build() {
            return new InventoryDeletionStatusItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
