/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;

public class DescribeParametersIterable
implements SdkIterable<DescribeParametersResponse> {
    private final SsmClient client;
    private final DescribeParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeParametersIterable(SsmClient client, DescribeParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeParametersResponseFetcher();
    }

    public Iterator<DescribeParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeParametersResponseFetcher
    implements SyncPageFetcher<DescribeParametersResponse> {
        private DescribeParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeParametersResponse nextPage(DescribeParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeParametersIterable.this.client.describeParameters(DescribeParametersIterable.this.firstRequest);
            }
            return DescribeParametersIterable.this.client.describeParameters((DescribeParametersRequest)((Object)DescribeParametersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

