/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;

public class DescribeInstancePatchesIterable
implements SdkIterable<DescribeInstancePatchesResponse> {
    private final SsmClient client;
    private final DescribeInstancePatchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancePatchesIterable(SsmClient client, DescribeInstancePatchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstancePatchesResponseFetcher();
    }

    public Iterator<DescribeInstancePatchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PatchComplianceData> patches() {
        Function<DescribeInstancePatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.patches() != null) {
                return response.patches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstancePatchesResponseFetcher
    implements SyncPageFetcher<DescribeInstancePatchesResponse> {
        private DescribeInstancePatchesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancePatchesResponse nextPage(DescribeInstancePatchesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePatchesIterable.this.client.describeInstancePatches(DescribeInstancePatchesIterable.this.firstRequest);
            }
            return DescribeInstancePatchesIterable.this.client.describeInstancePatches((DescribeInstancePatchesRequest)((Object)DescribeInstancePatchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

