/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AlarmConfiguration;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformation;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformationListCopier;
import software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.AssociationOverview;
import software.amazon.awssdk.services.ssm.model.AssociationStatus;
import software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance;
import software.amazon.awssdk.services.ssm.model.CalendarNameOrARNListCopier;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssociationDescription.getter(AssociationDescription::name)).setter(AssociationDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociationDescription.getter(AssociationDescription::instanceId)).setter(AssociationDescription.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(AssociationDescription.getter(AssociationDescription::associationVersion)).setter(AssociationDescription.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Date").getter(AssociationDescription.getter(AssociationDescription::date)).setter(AssociationDescription.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_ASSOCIATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateAssociationDate").getter(AssociationDescription.getter(AssociationDescription::lastUpdateAssociationDate)).setter(AssociationDescription.setter(Builder::lastUpdateAssociationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateAssociationDate").build()}).build();
    private static final SdkField<AssociationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(AssociationDescription.getter(AssociationDescription::status)).setter(AssociationDescription.setter(Builder::status)).constructor(AssociationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<AssociationOverview> OVERVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Overview").getter(AssociationDescription.getter(AssociationDescription::overview)).setter(AssociationDescription.setter(Builder::overview)).constructor(AssociationOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overview").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(AssociationDescription.getter(AssociationDescription::documentVersion)).setter(AssociationDescription.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> AUTOMATION_TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationTargetParameterName").getter(AssociationDescription.getter(AssociationDescription::automationTargetParameterName)).setter(AssociationDescription.setter(Builder::automationTargetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationTargetParameterName").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(AssociationDescription.getter(AssociationDescription::parameters)).setter(AssociationDescription.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AssociationDescription.getter(AssociationDescription::associationId)).setter(AssociationDescription.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(AssociationDescription.getter(AssociationDescription::targets)).setter(AssociationDescription.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(AssociationDescription.getter(AssociationDescription::scheduleExpression)).setter(AssociationDescription.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(AssociationDescription.getter(AssociationDescription::outputLocation)).setter(AssociationDescription.setter(Builder::outputLocation)).constructor(InstanceAssociationOutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastExecutionDate").getter(AssociationDescription.getter(AssociationDescription::lastExecutionDate)).setter(AssociationDescription.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulExecutionDate").getter(AssociationDescription.getter(AssociationDescription::lastSuccessfulExecutionDate)).setter(AssociationDescription.setter(Builder::lastSuccessfulExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulExecutionDate").build()}).build();
    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationName").getter(AssociationDescription.getter(AssociationDescription::associationName)).setter(AssociationDescription.setter(Builder::associationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(AssociationDescription.getter(AssociationDescription::maxErrors)).setter(AssociationDescription.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(AssociationDescription.getter(AssociationDescription::maxConcurrency)).setter(AssociationDescription.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceSeverity").getter(AssociationDescription.getter(AssociationDescription::complianceSeverityAsString)).setter(AssociationDescription.setter(Builder::complianceSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build()}).build();
    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncCompliance").getter(AssociationDescription.getter(AssociationDescription::syncComplianceAsString)).setter(AssociationDescription.setter(Builder::syncCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()}).build();
    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval").getter(AssociationDescription.getter(AssociationDescription::applyOnlyAtCronInterval)).setter(AssociationDescription.setter(Builder::applyOnlyAtCronInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build()}).build();
    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalendarNames").getter(AssociationDescription.getter(AssociationDescription::calendarNames)).setter(AssociationDescription.setter(Builder::calendarNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLocations").getter(AssociationDescription.getter(AssociationDescription::targetLocations)).setter(AssociationDescription.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduleOffset").getter(AssociationDescription.getter(AssociationDescription::scheduleOffset)).setter(AssociationDescription.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(AssociationDescription.getter(AssociationDescription::targetMaps)).setter(AssociationDescription.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmConfiguration").getter(AssociationDescription.getter(AssociationDescription::alarmConfiguration)).setter(AssociationDescription.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build()}).build();
    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggeredAlarms").getter(AssociationDescription.getter(AssociationDescription::triggeredAlarms)).setter(AssociationDescription.setter(Builder::triggeredAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmStateInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_ID_FIELD, ASSOCIATION_VERSION_FIELD, DATE_FIELD, LAST_UPDATE_ASSOCIATION_DATE_FIELD, STATUS_FIELD, OVERVIEW_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_TARGET_PARAMETER_NAME_FIELD, PARAMETERS_FIELD, ASSOCIATION_ID_FIELD, TARGETS_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, LAST_EXECUTION_DATE_FIELD, LAST_SUCCESSFUL_EXECUTION_DATE_FIELD, ASSOCIATION_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD, COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD, APPLY_ONLY_AT_CRON_INTERVAL_FIELD, CALENDAR_NAMES_FIELD, TARGET_LOCATIONS_FIELD, SCHEDULE_OFFSET_FIELD, TARGET_MAPS_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String instanceId;
    private final String associationVersion;
    private final Instant date;
    private final Instant lastUpdateAssociationDate;
    private final AssociationStatus status;
    private final AssociationOverview overview;
    private final String documentVersion;
    private final String automationTargetParameterName;
    private final Map<String, List<String>> parameters;
    private final String associationId;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final Instant lastExecutionDate;
    private final Instant lastSuccessfulExecutionDate;
    private final String associationName;
    private final String maxErrors;
    private final String maxConcurrency;
    private final String complianceSeverity;
    private final String syncCompliance;
    private final Boolean applyOnlyAtCronInterval;
    private final List<String> calendarNames;
    private final List<TargetLocation> targetLocations;
    private final Integer scheduleOffset;
    private final List<Map<String, List<String>>> targetMaps;
    private final AlarmConfiguration alarmConfiguration;
    private final List<AlarmStateInformation> triggeredAlarms;

    private AssociationDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationVersion = builder.associationVersion;
        this.date = builder.date;
        this.lastUpdateAssociationDate = builder.lastUpdateAssociationDate;
        this.status = builder.status;
        this.overview = builder.overview;
        this.documentVersion = builder.documentVersion;
        this.automationTargetParameterName = builder.automationTargetParameterName;
        this.parameters = builder.parameters;
        this.associationId = builder.associationId;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.lastSuccessfulExecutionDate = builder.lastSuccessfulExecutionDate;
        this.associationName = builder.associationName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
        this.calendarNames = builder.calendarNames;
        this.targetLocations = builder.targetLocations;
        this.scheduleOffset = builder.scheduleOffset;
        this.targetMaps = builder.targetMaps;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
    }

    public final String name() {
        return this.name;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String associationVersion() {
        return this.associationVersion;
    }

    public final Instant date() {
        return this.date;
    }

    public final Instant lastUpdateAssociationDate() {
        return this.lastUpdateAssociationDate;
    }

    public final AssociationStatus status() {
        return this.status;
    }

    public final AssociationOverview overview() {
        return this.overview;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String automationTargetParameterName() {
        return this.automationTargetParameterName;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public final Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public final Instant lastSuccessfulExecutionDate() {
        return this.lastSuccessfulExecutionDate;
    }

    public final String associationName() {
        return this.associationName;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(this.complianceSeverity);
    }

    public final String complianceSeverityAsString() {
        return this.complianceSeverity;
    }

    public final AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(this.syncCompliance);
    }

    public final String syncComplianceAsString() {
        return this.syncCompliance;
    }

    public final Boolean applyOnlyAtCronInterval() {
        return this.applyOnlyAtCronInterval;
    }

    public final boolean hasCalendarNames() {
        return this.calendarNames != null && !(this.calendarNames instanceof SdkAutoConstructList);
    }

    public final List<String> calendarNames() {
        return this.calendarNames;
    }

    public final boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public final List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public final Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final boolean hasTriggeredAlarms() {
        return this.triggeredAlarms != null && !(this.triggeredAlarms instanceof SdkAutoConstructList);
    }

    public final List<AlarmStateInformation> triggeredAlarms() {
        return this.triggeredAlarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateAssociationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.overview());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationTargetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnlyAtCronInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalendarNames() ? this.calendarNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLocations() ? this.targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarms() ? this.triggeredAlarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationDescription)) {
            return false;
        }
        AssociationDescription other = (AssociationDescription)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.lastUpdateAssociationDate(), other.lastUpdateAssociationDate()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.overview(), other.overview()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.automationTargetParameterName(), other.automationTargetParameterName()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.associationId(), other.associationId()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && Objects.equals(this.lastSuccessfulExecutionDate(), other.lastSuccessfulExecutionDate()) && Objects.equals(this.associationName(), other.associationName()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.complianceSeverityAsString(), other.complianceSeverityAsString()) && Objects.equals(this.syncComplianceAsString(), other.syncComplianceAsString()) && Objects.equals(this.applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval()) && this.hasCalendarNames() == other.hasCalendarNames() && Objects.equals(this.calendarNames(), other.calendarNames()) && this.hasTargetLocations() == other.hasTargetLocations() && Objects.equals(this.targetLocations(), other.targetLocations()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && this.hasTriggeredAlarms() == other.hasTriggeredAlarms() && Objects.equals(this.triggeredAlarms(), other.triggeredAlarms());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationDescription").add("Name", (Object)this.name()).add("InstanceId", (Object)this.instanceId()).add("AssociationVersion", (Object)this.associationVersion()).add("Date", (Object)this.date()).add("LastUpdateAssociationDate", (Object)this.lastUpdateAssociationDate()).add("Status", (Object)this.status()).add("Overview", (Object)this.overview()).add("DocumentVersion", (Object)this.documentVersion()).add("AutomationTargetParameterName", (Object)this.automationTargetParameterName()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("AssociationId", (Object)this.associationId()).add("Targets", this.hasTargets() ? this.targets() : null).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("LastSuccessfulExecutionDate", (Object)this.lastSuccessfulExecutionDate()).add("AssociationName", (Object)this.associationName()).add("MaxErrors", (Object)this.maxErrors()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ComplianceSeverity", (Object)this.complianceSeverityAsString()).add("SyncCompliance", (Object)this.syncComplianceAsString()).add("ApplyOnlyAtCronInterval", (Object)this.applyOnlyAtCronInterval()).add("CalendarNames", this.hasCalendarNames() ? this.calendarNames() : null).add("TargetLocations", this.hasTargetLocations() ? this.targetLocations() : null).add("ScheduleOffset", (Object)this.scheduleOffset()).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("TriggeredAlarms", this.hasTriggeredAlarms() ? this.triggeredAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "LastUpdateAssociationDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateAssociationDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Overview": {
                return Optional.ofNullable(clazz.cast(this.overview()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "AutomationTargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.automationTargetParameterName()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
            case "LastSuccessfulExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulExecutionDate()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "ComplianceSeverity": {
                return Optional.ofNullable(clazz.cast(this.complianceSeverityAsString()));
            }
            case "SyncCompliance": {
                return Optional.ofNullable(clazz.cast(this.syncComplianceAsString()));
            }
            case "ApplyOnlyAtCronInterval": {
                return Optional.ofNullable(clazz.cast(this.applyOnlyAtCronInterval()));
            }
            case "CalendarNames": {
                return Optional.ofNullable(clazz.cast(this.calendarNames()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "AlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "TriggeredAlarms": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationDescription, T> g) {
        return obj -> g.apply((AssociationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private String associationVersion;
        private Instant date;
        private Instant lastUpdateAssociationDate;
        private AssociationStatus status;
        private AssociationOverview overview;
        private String documentVersion;
        private String automationTargetParameterName;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String associationId;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private Instant lastExecutionDate;
        private Instant lastSuccessfulExecutionDate;
        private String associationName;
        private String maxErrors;
        private String maxConcurrency;
        private String complianceSeverity;
        private String syncCompliance;
        private Boolean applyOnlyAtCronInterval;
        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();
        private Integer scheduleOffset;
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private AlarmConfiguration alarmConfiguration;
        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationDescription model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.associationVersion(model.associationVersion);
            this.date(model.date);
            this.lastUpdateAssociationDate(model.lastUpdateAssociationDate);
            this.status(model.status);
            this.overview(model.overview);
            this.documentVersion(model.documentVersion);
            this.automationTargetParameterName(model.automationTargetParameterName);
            this.parameters(model.parameters);
            this.associationId(model.associationId);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.lastExecutionDate(model.lastExecutionDate);
            this.lastSuccessfulExecutionDate(model.lastSuccessfulExecutionDate);
            this.associationName(model.associationName);
            this.maxErrors(model.maxErrors);
            this.maxConcurrency(model.maxConcurrency);
            this.complianceSeverity(model.complianceSeverity);
            this.syncCompliance(model.syncCompliance);
            this.applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
            this.calendarNames(model.calendarNames);
            this.targetLocations(model.targetLocations);
            this.scheduleOffset(model.scheduleOffset);
            this.targetMaps(model.targetMaps);
            this.alarmConfiguration(model.alarmConfiguration);
            this.triggeredAlarms(model.triggeredAlarms);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final Instant getLastUpdateAssociationDate() {
            return this.lastUpdateAssociationDate;
        }

        public final void setLastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
        }

        @Override
        public final Builder lastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
            return this;
        }

        public final AssociationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        public final AssociationOverview.Builder getOverview() {
            return this.overview != null ? this.overview.toBuilder() : null;
        }

        public final void setOverview(AssociationOverview.BuilderImpl overview) {
            this.overview = overview != null ? overview.build() : null;
        }

        @Override
        public final Builder overview(AssociationOverview overview) {
            this.overview = overview;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAutomationTargetParameterName() {
            return this.automationTargetParameterName;
        }

        public final void setAutomationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
        }

        @Override
        public final Builder automationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final Instant getLastSuccessfulExecutionDate() {
            return this.lastSuccessfulExecutionDate;
        }

        public final void setLastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
            return this;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getComplianceSeverity() {
            return this.complianceSeverity;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final String getSyncCompliance() {
            return this.syncCompliance;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        @Override
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return this.applyOnlyAtCronInterval;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        @Override
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final Collection<String> getCalendarNames() {
            if (this.calendarNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.calendarNames;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        @Override
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calendarNames(String ... calendarNames) {
            this.calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
            this.triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... triggeredAlarms) {
            this.triggeredAlarms(Stream.of(triggeredAlarms).map(c -> (AlarmStateInformation)((AlarmStateInformation.Builder)AlarmStateInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssociationDescription build() {
            return new AssociationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationDescription> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder associationVersion(String var1);

        public Builder date(Instant var1);

        public Builder lastUpdateAssociationDate(Instant var1);

        public Builder status(AssociationStatus var1);

        default public Builder status(Consumer<AssociationStatus.Builder> status) {
            return this.status((AssociationStatus)((AssociationStatus.Builder)AssociationStatus.builder().applyMutation(status)).build());
        }

        public Builder overview(AssociationOverview var1);

        default public Builder overview(Consumer<AssociationOverview.Builder> overview) {
            return this.overview((AssociationOverview)((AssociationOverview.Builder)AssociationOverview.builder().applyMutation(overview)).build());
        }

        public Builder documentVersion(String var1);

        public Builder automationTargetParameterName(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder associationId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder lastExecutionDate(Instant var1);

        public Builder lastSuccessfulExecutionDate(Instant var1);

        public Builder associationName(String var1);

        public Builder maxErrors(String var1);

        public Builder maxConcurrency(String var1);

        public Builder complianceSeverity(String var1);

        public Builder complianceSeverity(AssociationComplianceSeverity var1);

        public Builder syncCompliance(String var1);

        public Builder syncCompliance(AssociationSyncCompliance var1);

        public Builder applyOnlyAtCronInterval(Boolean var1);

        public Builder calendarNames(Collection<String> var1);

        public Builder calendarNames(String ... var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder scheduleOffset(Integer var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder triggeredAlarms(Collection<AlarmStateInformation> var1);

        public Builder triggeredAlarms(AlarmStateInformation ... var1);

        public Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... var1);
    }
}

