/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.DefaultSsmBaseClientBuilder;
import software.amazon.awssdk.services.ssm.DefaultSsmClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.SsmServiceClientConfiguration;
import software.amazon.awssdk.services.ssm.endpoints.SsmEndpointProvider;

@SdkInternalApi
final class DefaultSsmClientBuilder
extends DefaultSsmBaseClientBuilder<SsmClientBuilder, SsmClient>
implements SsmClientBuilder {
    DefaultSsmClientBuilder() {
    }

    @Override
    public DefaultSsmClientBuilder endpointProvider(SsmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsmClientBuilder.validateClientOptions(clientConfiguration);
        SsmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsmClient client = new DefaultSsmClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

