/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOpsMetadataResponse extends SsmResponse implements
        ToCopyableBuilder<CreateOpsMetadataResponse.Builder, CreateOpsMetadataResponse> {
    private static final SdkField<String> OPS_METADATA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsMetadataArn").getter(getter(CreateOpsMetadataResponse::opsMetadataArn))
            .setter(setter(Builder::opsMetadataArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_METADATA_ARN_FIELD));

    private final String opsMetadataArn;

    private CreateOpsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.opsMetadataArn = builder.opsMetadataArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.
     */
    public final String opsMetadataArn() {
        return opsMetadataArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(opsMetadataArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpsMetadataResponse)) {
            return false;
        }
        CreateOpsMetadataResponse other = (CreateOpsMetadataResponse) obj;
        return Objects.equals(opsMetadataArn(), other.opsMetadataArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOpsMetadataResponse").add("OpsMetadataArn", opsMetadataArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsMetadataArn":
            return Optional.ofNullable(clazz.cast(opsMetadataArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpsMetadataResponse, T> g) {
        return obj -> g.apply((CreateOpsMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateOpsMetadataResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.
         * </p>
         * 
         * @param opsMetadataArn
         *        The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsMetadataArn(String opsMetadataArn);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String opsMetadataArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpsMetadataResponse model) {
            super(model);
            opsMetadataArn(model.opsMetadataArn);
        }

        public final String getOpsMetadataArn() {
            return opsMetadataArn;
        }

        public final void setOpsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
        }

        @Override
        public final Builder opsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
            return this;
        }

        @Override
        public CreateOpsMetadataResponse build() {
            return new CreateOpsMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
