/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StopType {
    COMPLETE("Complete"),
    CANCEL("Cancel"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StopType> VALUE_MAP;
    private final String value;

    private StopType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StopType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StopType> knownValues() {
        EnumSet<StopType> knownValues = EnumSet.allOf(StopType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StopType.class, StopType::toString);
    }
}

