/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilter;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersByPathRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetParametersByPathRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::path)).setter(GetParametersByPathRequest.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Recursive").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::recursive)).setter(GetParametersByPathRequest.setter(Builder::recursive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()}).build();
    private static final SdkField<List<ParameterStringFilter>> PARAMETER_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterFilters").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::parameterFilters)).setter(GetParametersByPathRequest.setter(Builder::parameterFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> WITH_DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithDecryption").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::withDecryption)).setter(GetParametersByPathRequest.setter(Builder::withDecryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithDecryption").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::maxResults)).setter(GetParametersByPathRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetParametersByPathRequest.getter(GetParametersByPathRequest::nextToken)).setter(GetParametersByPathRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, RECURSIVE_FIELD, PARAMETER_FILTERS_FIELD, WITH_DECRYPTION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String path;
    private final Boolean recursive;
    private final List<ParameterStringFilter> parameterFilters;
    private final Boolean withDecryption;
    private final Integer maxResults;
    private final String nextToken;

    private GetParametersByPathRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.recursive = builder.recursive;
        this.parameterFilters = builder.parameterFilters;
        this.withDecryption = builder.withDecryption;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String path() {
        return this.path;
    }

    public final Boolean recursive() {
        return this.recursive;
    }

    public final boolean hasParameterFilters() {
        return this.parameterFilters != null && !(this.parameterFilters instanceof SdkAutoConstructList);
    }

    public final List<ParameterStringFilter> parameterFilters() {
        return this.parameterFilters;
    }

    public final Boolean withDecryption() {
        return this.withDecryption;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.recursive());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterFilters() ? this.parameterFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.withDecryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersByPathRequest)) {
            return false;
        }
        GetParametersByPathRequest other = (GetParametersByPathRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.recursive(), other.recursive()) && this.hasParameterFilters() == other.hasParameterFilters() && Objects.equals(this.parameterFilters(), other.parameterFilters()) && Objects.equals(this.withDecryption(), other.withDecryption()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersByPathRequest").add("Path", (Object)this.path()).add("Recursive", (Object)this.recursive()).add("ParameterFilters", this.hasParameterFilters() ? this.parameterFilters() : null).add("WithDecryption", (Object)this.withDecryption()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Recursive": {
                return Optional.ofNullable(clazz.cast(this.recursive()));
            }
            case "ParameterFilters": {
                return Optional.ofNullable(clazz.cast(this.parameterFilters()));
            }
            case "WithDecryption": {
                return Optional.ofNullable(clazz.cast(this.withDecryption()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersByPathRequest, T> g) {
        return obj -> g.apply((GetParametersByPathRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String path;
        private Boolean recursive;
        private List<ParameterStringFilter> parameterFilters = DefaultSdkAutoConstructList.getInstance();
        private Boolean withDecryption;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersByPathRequest model) {
            super(model);
            this.path(model.path);
            this.recursive(model.recursive);
            this.parameterFilters(model.parameterFilters);
            this.withDecryption(model.withDecryption);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final List<ParameterStringFilter.Builder> getParameterFilters() {
            List<ParameterStringFilter.Builder> result = ParameterStringFilterListCopier.copyToBuilder(this.parameterFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter.BuilderImpl> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copyFromBuilder(parameterFilters);
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(Consumer<ParameterStringFilter.Builder> ... parameterFilters) {
            this.parameterFilters(Stream.of(parameterFilters).map(c -> (ParameterStringFilter)((ParameterStringFilter.Builder)ParameterStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getWithDecryption() {
            return this.withDecryption;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersByPathRequest build() {
            return new GetParametersByPathRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersByPathRequest> {
        public Builder path(String var1);

        public Builder recursive(Boolean var1);

        public Builder parameterFilters(Collection<ParameterStringFilter> var1);

        public Builder parameterFilters(ParameterStringFilter ... var1);

        public Builder parameterFilters(Consumer<ParameterStringFilter.Builder> ... var1);

        public Builder withDecryption(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

