/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentType {
    COMMAND("Command"),
    POLICY("Policy"),
    AUTOMATION("Automation"),
    SESSION("Session"),
    PACKAGE("Package"),
    APPLICATION_CONFIGURATION("ApplicationConfiguration"),
    APPLICATION_CONFIGURATION_SCHEMA("ApplicationConfigurationSchema"),
    DEPLOYMENT_STRATEGY("DeploymentStrategy"),
    CHANGE_CALENDAR("ChangeCalendar"),
    AUTOMATION_CHANGE_TEMPLATE("Automation.ChangeTemplate"),
    PROBLEM_ANALYSIS("ProblemAnalysis"),
    PROBLEM_ANALYSIS_TEMPLATE("ProblemAnalysisTemplate"),
    CLOUD_FORMATION("CloudFormation"),
    CONFORMANCE_PACK_TEMPLATE("ConformancePackTemplate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentType> VALUE_MAP;
    private final String value;

    private DocumentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentType> knownValues() {
        EnumSet<DocumentType> knownValues = EnumSet.allOf(DocumentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentType.class, DocumentType::toString);
    }
}

