/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AlarmConfiguration;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformation;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformationListCopier;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.AutomationSubtype;
import software.amazon.awssdk.services.ssm.model.AutomationType;
import software.amazon.awssdk.services.ssm.model.ExecutionMode;
import software.amazon.awssdk.services.ssm.model.ResolvedTargets;
import software.amazon.awssdk.services.ssm.model.Runbook;
import software.amazon.awssdk.services.ssm.model.RunbooksCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecutionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecutionMetadata> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationExecutionId").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionId)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentName)).setter(AutomationExecutionMetadata.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentVersion)).setter(AutomationExecutionMetadata.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationExecutionStatus").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionStatusAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionStartTime").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionStartTime)).setter(AutomationExecutionMetadata.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionEndTime").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionEndTime)).setter(AutomationExecutionMetadata.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutedBy").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executedBy)).setter(AutomationExecutionMetadata.setter(Builder::executedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()}).build();
    private static final SdkField<String> LOG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFile").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::logFile)).setter(AutomationExecutionMetadata.setter(Builder::logFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Outputs").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::outputs)).setter(AutomationExecutionMetadata.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::modeAsString)).setter(AutomationExecutionMetadata.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentAutomationExecutionId").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::parentAutomationExecutionId)).setter(AutomationExecutionMetadata.setter(Builder::parentAutomationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId").build()}).build();
    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentStepName").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::currentStepName)).setter(AutomationExecutionMetadata.setter(Builder::currentStepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()}).build();
    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAction").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::currentAction)).setter(AutomationExecutionMetadata.setter(Builder::currentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::failureMessage)).setter(AutomationExecutionMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetParameterName").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targetParameterName)).setter(AutomationExecutionMetadata.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targets)).setter(AutomationExecutionMetadata.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targetMaps)).setter(AutomationExecutionMetadata.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResolvedTargets").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::resolvedTargets)).setter(AutomationExecutionMetadata.setter(Builder::resolvedTargets)).constructor(ResolvedTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::maxConcurrency)).setter(AutomationExecutionMetadata.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::maxErrors)).setter(AutomationExecutionMetadata.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::target)).setter(AutomationExecutionMetadata.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> AUTOMATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationType").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationTypeAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationType").build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmConfiguration").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::alarmConfiguration)).setter(AutomationExecutionMetadata.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build()}).build();
    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggeredAlarms").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::triggeredAlarms)).setter(AutomationExecutionMetadata.setter(Builder::triggeredAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmStateInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTOMATION_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationSubtype").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationSubtypeAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationSubtype").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::scheduledTime)).setter(AutomationExecutionMetadata.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<List<Runbook>> RUNBOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Runbooks").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::runbooks)).setter(AutomationExecutionMetadata.setter(Builder::runbooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runbooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Runbook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::opsItemId)).setter(AutomationExecutionMetadata.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::associationId)).setter(AutomationExecutionMetadata.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> CHANGE_REQUEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeRequestName").getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::changeRequestName)).setter(AutomationExecutionMetadata.setter(Builder::changeRequestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeRequestName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTED_BY_FIELD, LOG_FILE_FIELD, OUTPUTS_FIELD, MODE_FIELD, PARENT_AUTOMATION_EXECUTION_ID_FIELD, CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, FAILURE_MESSAGE_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_FIELD, AUTOMATION_TYPE_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD, AUTOMATION_SUBTYPE_FIELD, SCHEDULED_TIME_FIELD, RUNBOOKS_FIELD, OPS_ITEM_ID_FIELD, ASSOCIATION_ID_FIELD, CHANGE_REQUEST_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final String automationExecutionStatus;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String executedBy;
    private final String logFile;
    private final Map<String, List<String>> outputs;
    private final String mode;
    private final String parentAutomationExecutionId;
    private final String currentStepName;
    private final String currentAction;
    private final String failureMessage;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final ResolvedTargets resolvedTargets;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String target;
    private final String automationType;
    private final AlarmConfiguration alarmConfiguration;
    private final List<AlarmStateInformation> triggeredAlarms;
    private final String automationSubtype;
    private final Instant scheduledTime;
    private final List<Runbook> runbooks;
    private final String opsItemId;
    private final String associationId;
    private final String changeRequestName;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.failureMessage = builder.failureMessage;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.automationType = builder.automationType;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
        this.automationSubtype = builder.automationSubtype;
        this.scheduledTime = builder.scheduledTime;
        this.runbooks = builder.runbooks;
        this.opsItemId = builder.opsItemId;
        this.associationId = builder.associationId;
        this.changeRequestName = builder.changeRequestName;
    }

    public final String automationExecutionId() {
        return this.automationExecutionId;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public final String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public final Instant executionStartTime() {
        return this.executionStartTime;
    }

    public final Instant executionEndTime() {
        return this.executionEndTime;
    }

    public final String executedBy() {
        return this.executedBy;
    }

    public final String logFile() {
        return this.logFile;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String parentAutomationExecutionId() {
        return this.parentAutomationExecutionId;
    }

    public final String currentStepName() {
        return this.currentStepName;
    }

    public final String currentAction() {
        return this.currentAction;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String targetParameterName() {
        return this.targetParameterName;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final ResolvedTargets resolvedTargets() {
        return this.resolvedTargets;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final String target() {
        return this.target;
    }

    public final AutomationType automationType() {
        return AutomationType.fromValue(this.automationType);
    }

    public final String automationTypeAsString() {
        return this.automationType;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final boolean hasTriggeredAlarms() {
        return this.triggeredAlarms != null && !(this.triggeredAlarms instanceof SdkAutoConstructList);
    }

    public final List<AlarmStateInformation> triggeredAlarms() {
        return this.triggeredAlarms;
    }

    public final AutomationSubtype automationSubtype() {
        return AutomationSubtype.fromValue(this.automationSubtype);
    }

    public final String automationSubtypeAsString() {
        return this.automationSubtype;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public final boolean hasRunbooks() {
        return this.runbooks != null && !(this.runbooks instanceof SdkAutoConstructList);
    }

    public final List<Runbook> runbooks() {
        return this.runbooks;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String changeRequestName() {
        return this.changeRequestName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarms() ? this.triggeredAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.automationSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunbooks() ? this.runbooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeRequestName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.executedBy(), other.executedBy()) && Objects.equals(this.logFile(), other.logFile()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.parentAutomationExecutionId(), other.parentAutomationExecutionId()) && Objects.equals(this.currentStepName(), other.currentStepName()) && Objects.equals(this.currentAction(), other.currentAction()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.resolvedTargets(), other.resolvedTargets()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.automationTypeAsString(), other.automationTypeAsString()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && this.hasTriggeredAlarms() == other.hasTriggeredAlarms() && Objects.equals(this.triggeredAlarms(), other.triggeredAlarms()) && Objects.equals(this.automationSubtypeAsString(), other.automationSubtypeAsString()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && this.hasRunbooks() == other.hasRunbooks() && Objects.equals(this.runbooks(), other.runbooks()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.changeRequestName(), other.changeRequestName());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationExecutionMetadata").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("ExecutedBy", (Object)this.executedBy()).add("LogFile", (Object)this.logFile()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Mode", (Object)this.modeAsString()).add("ParentAutomationExecutionId", (Object)this.parentAutomationExecutionId()).add("CurrentStepName", (Object)this.currentStepName()).add("CurrentAction", (Object)this.currentAction()).add("FailureMessage", (Object)this.failureMessage()).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.hasTargets() ? this.targets() : null).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("ResolvedTargets", (Object)this.resolvedTargets()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Target", (Object)this.target()).add("AutomationType", (Object)this.automationTypeAsString()).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("TriggeredAlarms", this.hasTriggeredAlarms() ? this.triggeredAlarms() : null).add("AutomationSubtype", (Object)this.automationSubtypeAsString()).add("ScheduledTime", (Object)this.scheduledTime()).add("Runbooks", this.hasRunbooks() ? this.runbooks() : null).add("OpsItemId", (Object)this.opsItemId()).add("AssociationId", (Object)this.associationId()).add("ChangeRequestName", (Object)this.changeRequestName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "ExecutedBy": {
                return Optional.ofNullable(clazz.cast(this.executedBy()));
            }
            case "LogFile": {
                return Optional.ofNullable(clazz.cast(this.logFile()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ParentAutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.parentAutomationExecutionId()));
            }
            case "CurrentStepName": {
                return Optional.ofNullable(clazz.cast(this.currentStepName()));
            }
            case "CurrentAction": {
                return Optional.ofNullable(clazz.cast(this.currentAction()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "ResolvedTargets": {
                return Optional.ofNullable(clazz.cast(this.resolvedTargets()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "AutomationType": {
                return Optional.ofNullable(clazz.cast(this.automationTypeAsString()));
            }
            case "AlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "TriggeredAlarms": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarms()));
            }
            case "AutomationSubtype": {
                return Optional.ofNullable(clazz.cast(this.automationSubtypeAsString()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "Runbooks": {
                return Optional.ofNullable(clazz.cast(this.runbooks()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ChangeRequestName": {
                return Optional.ofNullable(clazz.cast(this.changeRequestName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionMetadata, T> g) {
        return obj -> g.apply((AutomationExecutionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private String automationExecutionStatus;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String executedBy;
        private String logFile;
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String mode;
        private String parentAutomationExecutionId;
        private String currentStepName;
        private String currentAction;
        private String failureMessage;
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private ResolvedTargets resolvedTargets;
        private String maxConcurrency;
        private String maxErrors;
        private String target;
        private String automationType;
        private AlarmConfiguration alarmConfiguration;
        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();
        private String automationSubtype;
        private Instant scheduledTime;
        private List<Runbook> runbooks = DefaultSdkAutoConstructList.getInstance();
        private String opsItemId;
        private String associationId;
        private String changeRequestName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.executedBy(model.executedBy);
            this.logFile(model.logFile);
            this.outputs(model.outputs);
            this.mode(model.mode);
            this.parentAutomationExecutionId(model.parentAutomationExecutionId);
            this.currentStepName(model.currentStepName);
            this.currentAction(model.currentAction);
            this.failureMessage(model.failureMessage);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.resolvedTargets(model.resolvedTargets);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.target(model.target);
            this.automationType(model.automationType);
            this.alarmConfiguration(model.alarmConfiguration);
            this.triggeredAlarms(model.triggeredAlarms);
            this.automationSubtype(model.automationSubtype);
            this.scheduledTime(model.scheduledTime);
            this.runbooks(model.runbooks);
            this.opsItemId(model.opsItemId);
            this.associationId(model.associationId);
            this.changeRequestName(model.changeRequestName);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus == null ? null : automationExecutionStatus.toString());
            return this;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final String getLogFile() {
            return this.logFile;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            if (this.outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputs;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getParentAutomationExecutionId() {
            return this.parentAutomationExecutionId;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final String getCurrentStepName() {
            return this.currentStepName;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final String getCurrentAction() {
            return this.currentAction;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return this.resolvedTargets != null ? this.resolvedTargets.toBuilder() : null;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getAutomationType() {
            return this.automationType;
        }

        public final void setAutomationType(String automationType) {
            this.automationType = automationType;
        }

        @Override
        public final Builder automationType(String automationType) {
            this.automationType = automationType;
            return this;
        }

        @Override
        public final Builder automationType(AutomationType automationType) {
            this.automationType(automationType == null ? null : automationType.toString());
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
            this.triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... triggeredAlarms) {
            this.triggeredAlarms(Stream.of(triggeredAlarms).map(c -> (AlarmStateInformation)((AlarmStateInformation.Builder)AlarmStateInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAutomationSubtype() {
            return this.automationSubtype;
        }

        public final void setAutomationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
        }

        @Override
        public final Builder automationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
            return this;
        }

        @Override
        public final Builder automationSubtype(AutomationSubtype automationSubtype) {
            this.automationSubtype(automationSubtype == null ? null : automationSubtype.toString());
            return this;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final List<Runbook.Builder> getRunbooks() {
            List<Runbook.Builder> result = RunbooksCopier.copyToBuilder(this.runbooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRunbooks(Collection<Runbook.BuilderImpl> runbooks) {
            this.runbooks = RunbooksCopier.copyFromBuilder(runbooks);
        }

        @Override
        public final Builder runbooks(Collection<Runbook> runbooks) {
            this.runbooks = RunbooksCopier.copy(runbooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Runbook ... runbooks) {
            this.runbooks(Arrays.asList(runbooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Consumer<Runbook.Builder> ... runbooks) {
            this.runbooks(Stream.of(runbooks).map(c -> (Runbook)((Runbook.Builder)Runbook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getChangeRequestName() {
            return this.changeRequestName;
        }

        public final void setChangeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
        }

        @Override
        public final Builder changeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
            return this;
        }

        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecutionMetadata> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder executedBy(String var1);

        public Builder logFile(String var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder parentAutomationExecutionId(String var1);

        public Builder currentStepName(String var1);

        public Builder currentAction(String var1);

        public Builder failureMessage(String var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder resolvedTargets(ResolvedTargets var1);

        default public Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return this.resolvedTargets((ResolvedTargets)((ResolvedTargets.Builder)ResolvedTargets.builder().applyMutation(resolvedTargets)).build());
        }

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder target(String var1);

        public Builder automationType(String var1);

        public Builder automationType(AutomationType var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder triggeredAlarms(Collection<AlarmStateInformation> var1);

        public Builder triggeredAlarms(AlarmStateInformation ... var1);

        public Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... var1);

        public Builder automationSubtype(String var1);

        public Builder automationSubtype(AutomationSubtype var1);

        public Builder scheduledTime(Instant var1);

        public Builder runbooks(Collection<Runbook> var1);

        public Builder runbooks(Runbook ... var1);

        public Builder runbooks(Consumer<Runbook.Builder> ... var1);

        public Builder opsItemId(String var1);

        public Builder associationId(String var1);

        public Builder changeRequestName(String var1);
    }
}

