/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcePoliciesResponse extends SsmResponse implements
        ToCopyableBuilder<GetResourcePoliciesResponse.Builder, GetResourcePoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourcePoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<GetResourcePoliciesResponseEntry>> POLICIES_FIELD = SdkField
            .<List<GetResourcePoliciesResponseEntry>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(GetResourcePoliciesResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetResourcePoliciesResponseEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetResourcePoliciesResponseEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            POLICIES_FIELD));

    private final String nextToken;

    private final List<GetResourcePoliciesResponseEntry> policies;

    private GetResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policies = builder.policies;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the <code>Policy</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return An array of the <code>Policy</code> object.
     */
    public final List<GetResourcePoliciesResponseEntry> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponse)) {
            return false;
        }
        GetResourcePoliciesResponse other = (GetResourcePoliciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcePoliciesResponse").add("NextToken", nextToken())
                .add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponse, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcePoliciesResponse> {
        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of the <code>Policy</code> object.
         * </p>
         * 
         * @param policies
         *        An array of the <code>Policy</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<GetResourcePoliciesResponseEntry> policies);

        /**
         * <p>
         * An array of the <code>Policy</code> object.
         * </p>
         * 
         * @param policies
         *        An array of the <code>Policy</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(GetResourcePoliciesResponseEntry... policies);

        /**
         * <p>
         * An array of the <code>Policy</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #policies(List<GetResourcePoliciesResponseEntry>)}.
         * 
         * @param policies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<GetResourcePoliciesResponseEntry>)
         */
        Builder policies(Consumer<GetResourcePoliciesResponseEntry.Builder>... policies);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<GetResourcePoliciesResponseEntry> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            policies(model.policies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GetResourcePoliciesResponseEntry.Builder> getPolicies() {
            List<GetResourcePoliciesResponseEntry.Builder> result = GetResourcePoliciesResponseEntriesCopier
                    .copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<GetResourcePoliciesResponseEntry.BuilderImpl> policies) {
            this.policies = GetResourcePoliciesResponseEntriesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<GetResourcePoliciesResponseEntry> policies) {
            this.policies = GetResourcePoliciesResponseEntriesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(GetResourcePoliciesResponseEntry... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<GetResourcePoliciesResponseEntry.Builder>... policies) {
            policies(Stream.of(policies).map(c -> GetResourcePoliciesResponseEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcePoliciesResponse build() {
            return new GetResourcePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
