/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.AlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.AssociatedInstancesException;
import software.amazon.awssdk.services.ssm.model.AssociationAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AssociationVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotApprovedException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationStepNotFoundException;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.ComplianceTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.CustomSchemaCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.DocumentAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.DocumentLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionLimitException;
import software.amazon.awssdk.services.ssm.model.DocumentVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DoesNotExistException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentContentException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentVersionNameException;
import software.amazon.awssdk.services.ssm.model.DuplicateInstanceIdException;
import software.amazon.awssdk.services.ssm.model.FeatureNotAvailableException;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.HierarchyLevelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.HierarchyTypeMismatchException;
import software.amazon.awssdk.services.ssm.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ssm.model.IncompatiblePolicyException;
import software.amazon.awssdk.services.ssm.model.InternalServerErrorException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationIdException;
import software.amazon.awssdk.services.ssm.model.InvalidAggregatorException;
import software.amazon.awssdk.services.ssm.model.InvalidAllowedPatternException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationExecutionParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationSignalException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationStatusUpdateException;
import software.amazon.awssdk.services.ssm.model.InvalidCommandIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDeleteInventoryParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidDeletionIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentContentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentOperationException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentSchemaVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterKeyException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceInformationFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryGroupException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryRequestException;
import software.amazon.awssdk.services.ssm.model.InvalidItemContentException;
import software.amazon.awssdk.services.ssm.model.InvalidKeyIdException;
import software.amazon.awssdk.services.ssm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ssm.model.InvalidNotificationConfigException;
import software.amazon.awssdk.services.ssm.model.InvalidOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputFolderException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputLocationException;
import software.amazon.awssdk.services.ssm.model.InvalidParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidPermissionTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidPluginNameException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResultAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidRoleException;
import software.amazon.awssdk.services.ssm.model.InvalidScheduleException;
import software.amazon.awssdk.services.ssm.model.InvalidTagException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetMapsException;
import software.amazon.awssdk.services.ssm.model.InvalidTypeNameException;
import software.amazon.awssdk.services.ssm.model.InvalidUpdateException;
import software.amazon.awssdk.services.ssm.model.InvocationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.ItemContentMismatchException;
import software.amazon.awssdk.services.ssm.model.ItemSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.MaxDocumentSizeExceededException;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemInvalidParameterException;
import software.amazon.awssdk.services.ssm.model.OpsItemLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsItemNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAssociationNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataInvalidArgumentException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataKeyLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataTooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.ParameterAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ParameterLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterMaxVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;
import software.amazon.awssdk.services.ssm.model.ParameterPatternMismatchException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionLabelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.PoliciesLimitExceededException;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncConflictException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncCountExceededException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncInvalidConfigurationException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResourceInUseException;
import software.amazon.awssdk.services.ssm.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ResumeSessionRequest;
import software.amazon.awssdk.services.ssm.model.ResumeSessionResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.ServiceSettingNotFoundException;
import software.amazon.awssdk.services.ssm.model.SsmException;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartSessionRequest;
import software.amazon.awssdk.services.ssm.model.StartSessionResponse;
import software.amazon.awssdk.services.ssm.model.StatusUnchangedException;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.SubTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.TargetInUseException;
import software.amazon.awssdk.services.ssm.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ssm.model.TerminateSessionRequest;
import software.amazon.awssdk.services.ssm.model.TerminateSessionResponse;
import software.amazon.awssdk.services.ssm.model.TooManyTagsErrorException;
import software.amazon.awssdk.services.ssm.model.TooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.TotalSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.UnsupportedCalendarException;
import software.amazon.awssdk.services.ssm.model.UnsupportedFeatureRequiredException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventorySchemaVersionException;
import software.amazon.awssdk.services.ssm.model.UnsupportedOperatingSystemException;
import software.amazon.awssdk.services.ssm.model.UnsupportedParameterTypeException;
import software.amazon.awssdk.services.ssm.model.UnsupportedPlatformTypeException;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingResponse;
import software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncPublisher;
import software.amazon.awssdk.services.ssm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.AssociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterManagedInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTargetFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTaskFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationStepExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAvailablePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectiveInstanceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectivePatchesForPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceAssociationsStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceInformationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInventoryDeletionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowScheduleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsForTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeOpsItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchBaselinesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchPropertiesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeSessionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DisassociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCalendarStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCommandInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDeployablePatchSnapshotForInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventorySchemaRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsSummaryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersByPathRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.LabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentMetadataHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListInventoryEntriesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemEventsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemRelatedItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ModifyDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTargetWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTaskWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResumeSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendAutomationSignalRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAssociationsOnceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartChangeRequestExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StopAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UnlabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateManagedInstanceRoleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.waiters.SsmAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SsmAsyncClient}.
 *
 * @see SsmAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSsmAsyncClient implements SsmAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsmAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultSsmAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. <i>Tags</i> are metadata that you can assign to
     * your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines.
     * Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment.
     * Each tag consists of a key and an optional value, both of which you define. For example, you could define a set
     * of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=Owner,Value=DbAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=SysAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=Dev</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Pre-Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Test</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyTagsErrorException The <code>Targets</code> parameter includes too many tags. Remove one or
     *         more tags and try the command again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource")
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident
     * Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of Amazon Web
     * Services Systems Manager.
     * </p>
     *
     * @param associateOpsItemRelatedItemRequest
     * @return A Java Future containing the result of the AssociateOpsItemRelatedItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>OpsItemRelatedItemAlreadyExistsException The Amazon Resource Name (ARN) is already associated with
     *         the OpsItem.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.AssociateOpsItemRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociateOpsItemRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateOpsItemRelatedItemResponse> associateOpsItemRelatedItem(
            AssociateOpsItemRelatedItemRequest associateOpsItemRelatedItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOpsItemRelatedItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOpsItemRelatedItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateOpsItemRelatedItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateOpsItemRelatedItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateOpsItemRelatedItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateOpsItemRelatedItemRequest, AssociateOpsItemRelatedItemResponse>()
                            .withOperationName("AssociateOpsItemRelatedItem")
                            .withMarshaller(new AssociateOpsItemRelatedItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateOpsItemRelatedItemRequest));
            CompletableFuture<AssociateOpsItemRelatedItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return A Java Future containing the result of the CancelCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>DuplicateInstanceIdException You can't specify a managed node ID in more than one association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelCommandResponse> cancelCommand(CancelCommandRequest cancelCommandRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCommand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CancelCommandResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelCommandResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCommandRequest, CancelCommandResponse>()
                            .withOperationName("CancelCommand")
                            .withMarshaller(new CancelCommandRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelCommandRequest));
            CompletableFuture<CancelCommandResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't
     * already starting running. Tasks already in progress will continue to completion.
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     * @return A Java Future containing the result of the CancelMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMaintenanceWindowExecutionResponse> cancelMaintenanceWindowExecution(
            CancelMaintenanceWindowExecutionRequest cancelMaintenanceWindowExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelMaintenanceWindowExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMaintenanceWindowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMaintenanceWindowExecutionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CancelMaintenanceWindowExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMaintenanceWindowExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMaintenanceWindowExecutionRequest, CancelMaintenanceWindowExecutionResponse>()
                            .withOperationName("CancelMaintenanceWindowExecution")
                            .withMarshaller(new CancelMaintenanceWindowExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelMaintenanceWindowExecutionRequest));
            CompletableFuture<CancelMaintenanceWindowExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or
     * virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager
     * makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when
     * installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing
     * on-premises machines using Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up Amazon Web Services Systems Manager for hybrid environments</a> in the <i>Amazon Web Services Systems Manager
     * User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are
     * configured for Systems Manager are all called <i>managed nodes</i>.
     * </p>
     * </note>
     *
     * @param createActivationRequest
     * @return A Java Future containing the result of the CreateActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Amazon Web
     *         Services Systems Manager document (SSM document). You can only supply values to parameters defined in the
     *         SSM document.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateActivationResponse> createActivation(CreateActivationRequest createActivationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateActivation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateActivationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateActivationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateActivationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateActivationRequest, CreateActivationResponse>()
                            .withOperationName("CreateActivation")
                            .withMarshaller(new CreateActivationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createActivationRequest));
            CompletableFuture<CreateActivationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your managed nodes. For example, an
     * association can specify that anti-virus software must be installed and running on your managed nodes, or that
     * certain ports must be closed. For static targets, the association specifies a schedule for when the configuration
     * is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services
     * autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration
     * when new managed nodes are added to the group. The association also specifies actions to take when applying the
     * configuration. For example, an association for anti-virus software might run once a day. If the software isn't
     * installed, then State Manager installs it. If the software is installed, but the service isn't running, then the
     * association might instruct State Manager to start the service.
     * </p>
     *
     * @param createAssociationRequest
     * @return A Java Future containing the result of the CreateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationAlreadyExistsException The specified association already exists.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>UnsupportedPlatformTypeException The document doesn't support the platform type of the given managed
     *         node ID(s). For example, you sent an document for a Windows managed node to a Linux node.</li>
     *         <li>InvalidOutputLocationException The output location isn't valid or doesn't exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Amazon Web
     *         Services Systems Manager document (SSM document). You can only supply values to parameters defined in the
     *         SSM document.</li>
     *         <li>InvalidTargetException The target isn't valid or doesn't exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>InvalidTargetMapsException TargetMap parameter isn't valid.</li>
     *         <li>InvalidTagException The specified tag key or value isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssociationResponse> createAssociation(CreateAssociationRequest createAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssociationRequest, CreateAssociationResponse>()
                            .withOperationName("CreateAssociation")
                            .withMarshaller(new CreateAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAssociationRequest));
            CompletableFuture<CreateAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed
     * nodes or targets.
     * </p>
     * <p>
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems
     * Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as
     * specified.
     * </p>
     * <p>
     * If you associate a document with a managed node that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return A Java Future containing the result of the CreateAssociationBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Amazon Web
     *         Services Systems Manager document (SSM document). You can only supply values to parameters defined in the
     *         SSM document.</li>
     *         <li>DuplicateInstanceIdException You can't specify a managed node ID in more than one association.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>UnsupportedPlatformTypeException The document doesn't support the platform type of the given managed
     *         node ID(s). For example, you sent an document for a Windows managed node to a Linux node.</li>
     *         <li>InvalidOutputLocationException The output location isn't valid or doesn't exist.</li>
     *         <li>InvalidTargetException The target isn't valid or doesn't exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>InvalidTargetMapsException TargetMap parameter isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssociationBatchResponse> createAssociationBatch(
            CreateAssociationBatchRequest createAssociationBatchRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociationBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssociationBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssociationBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssociationBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssociationBatchRequest, CreateAssociationBatchResponse>()
                            .withOperationName("CreateAssociationBatch")
                            .withMarshaller(new CreateAssociationBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAssociationBatchRequest));
            CompletableFuture<CreateAssociationBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems
     * Manager performs on your managed nodes. For more information about SSM documents, including information about
     * supported schemas, features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services
     * Systems Manager Documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createDocumentRequest
     * @return A Java Future containing the result of the CreateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DocumentAlreadyExistsException The specified document already exists.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentContentException The content for the document isn't valid.</li>
     *         <li>DocumentLimitExceededException You can have at most 500 active SSM documents.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDocumentResponse> createDocument(CreateDocumentRequest createDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentRequest, CreateDocumentResponse>()
                            .withOperationName("CreateDocument")
                            .withMarshaller(new CreateDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDocumentRequest));
            CompletableFuture<CreateDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param createMaintenanceWindowRequest
     * @return A Java Future containing the result of the CreateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMaintenanceWindowResponse> createMaintenanceWindow(
            CreateMaintenanceWindowRequest createMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMaintenanceWindowRequest, CreateMaintenanceWindowResponse>()
                            .withOperationName("CreateMaintenanceWindow")
                            .withMarshaller(new CreateMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createMaintenanceWindowRequest));
            CompletableFuture<CreateMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems
     * Manager OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createOpsItemRequest
     * @return A Java Future containing the result of the CreateOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemAlreadyExistsException The OpsItem already exists.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOpsItemResponse> createOpsItem(CreateOpsItemRequest createOpsItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateOpsItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOpsItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOpsItemRequest, CreateOpsItemResponse>()
                            .withOperationName("CreateOpsItem")
                            .withMarshaller(new CreateOpsItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createOpsItemRequest));
            CompletableFuture<CreateOpsItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API
     * operation to specify information about the new application, including the application type.
     * </p>
     *
     * @param createOpsMetadataRequest
     * @return A Java Future containing the result of the CreateOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataAlreadyExistsException An OpsMetadata object already exists for the selected resource.</li>
     *         <li>OpsMetadataTooManyUpdatesException The system is processing too many concurrent updates. Wait a few
     *         moments and try again.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>OpsMetadataLimitExceededException Your account reached the maximum number of OpsMetadata objects
     *         allowed by Application Manager. The maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata
     *         object and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOpsMetadataResponse> createOpsMetadata(CreateOpsMetadataRequest createOpsMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOpsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOpsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOpsMetadataRequest, CreateOpsMetadataResponse>()
                            .withOperationName("CreateOpsMetadata")
                            .withMarshaller(new CreateOpsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createOpsMetadataRequest));
            CompletableFuture<CreateOpsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a>PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param createPatchBaselineRequest
     * @return A Java Future containing the result of the CreatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePatchBaselineResponse> createPatchBaseline(
            CreatePatchBaselineRequest createPatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePatchBaselineRequest, CreatePatchBaselineResponse>()
                            .withOperationName("CreatePatchBaseline")
                            .withMarshaller(new CreatePatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPatchBaselineRequest));
            CompletableFuture<CreatePatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems
     * Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * resource data sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon
     * S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon
     * Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note>
     *
     * @param createResourceDataSyncRequest
     * @return A Java Future containing the result of the CreateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncCountExceededException You have exceeded the allowed maximum sync configurations.</li>
     *         <li>ResourceDataSyncAlreadyExistsException A sync configuration with the same name already exists.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceDataSyncResponse> createResourceDataSync(
            CreateResourceDataSyncRequest createResourceDataSyncRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceDataSync");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceDataSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceDataSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDataSyncRequest, CreateResourceDataSyncResponse>()
                            .withOperationName("CreateResourceDataSync")
                            .withMarshaller(new CreateResourceDataSyncRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourceDataSyncRequest));
            CompletableFuture<CreateResourceDataSyncResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You
     * must manually de-register managed nodes.
     * </p>
     *
     * @param deleteActivationRequest
     * @return A Java Future containing the result of the DeleteActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidActivationIdException The activation ID isn't valid. Verify the you entered the correct
     *         ActivationId or ActivationCode and try again.</li>
     *         <li>InvalidActivationException The activation isn't valid. The activation might have been deleted, or the
     *         ActivationId and the ActivationCode don't match.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteActivationResponse> deleteActivation(DeleteActivationRequest deleteActivationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteActivation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteActivationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteActivationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteActivationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteActivationRequest, DeleteActivationResponse>()
                            .withOperationName("DeleteActivation")
                            .withMarshaller(new DeleteActivationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteActivationRequest));
            CompletableFuture<DeleteActivationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified
     * managed node. If you created the association by using the <code>Targets</code> parameter, then you must delete
     * the association by using the association ID.
     * </p>
     * <p>
     * When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change
     * the configuration state of a managed node after you disassociate a document, you must create a new document with
     * the desired configuration and associate it with the node.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                            .withOperationName("DeleteAssociation")
                            .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAssociationRequest));
            CompletableFuture<DeleteAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the
     * document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all managed
     * nodes that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>AssociatedInstancesException You must disassociate a document from all managed nodes before you can
     *         delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentRequest, DeleteDocumentResponse>()
                            .withOperationName("DeleteDocument")
                            .withMarshaller(new DeleteDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDocumentRequest));
            CompletableFuture<DeleteDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     *
     * @param deleteInventoryRequest
     * @return A Java Future containing the result of the DeleteInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidOptionException The delete inventory option specified isn't valid. Verify the option and try
     *         again.</li>
     *         <li>InvalidDeleteInventoryParametersException One or more of the parameters specified for the delete
     *         operation isn't valid. Verify all parameters and try again.</li>
     *         <li>InvalidInventoryRequestException The request isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInventoryResponse> deleteInventory(DeleteInventoryRequest deleteInventoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInventory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInventoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInventoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInventoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInventoryRequest, DeleteInventoryResponse>()
                            .withOperationName("DeleteInventory")
                            .withMarshaller(new DeleteInventoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInventoryRequest));
            CompletableFuture<DeleteInventoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeleteMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(
            DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMaintenanceWindowRequest, DeleteMaintenanceWindowResponse>()
                            .withOperationName("DeleteMaintenanceWindow")
                            .withMarshaller(new DeleteMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMaintenanceWindowRequest));
            CompletableFuture<DeleteMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     *
     * @param deleteOpsMetadataRequest
     * @return A Java Future containing the result of the DeleteOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object doesn't exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOpsMetadataResponse> deleteOpsMetadata(DeleteOpsMetadataRequest deleteOpsMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOpsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOpsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOpsMetadataRequest, DeleteOpsMetadataResponse>()
                            .withOperationName("DeleteOpsMetadata")
                            .withMarshaller(new DeleteOpsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteOpsMetadataRequest));
            CompletableFuture<DeleteOpsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a
     * parameter with the same name.
     * </p>
     *
     * @param deleteParameterRequest
     * @return A Java Future containing the result of the DeleteParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteParameterResponse> deleteParameter(DeleteParameterRequest deleteParameterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteParameterRequest, DeleteParameterResponse>()
                            .withOperationName("DeleteParameter")
                            .withMarshaller(new DeleteParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteParameterRequest));
            CompletableFuture<DeleteParameterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with
     * the same name.
     * </p>
     *
     * @param deleteParametersRequest
     * @return A Java Future containing the result of the DeleteParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteParametersResponse> deleteParameters(DeleteParametersRequest deleteParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteParametersRequest, DeleteParametersResponse>()
                            .withOperationName("DeleteParameters")
                            .withMarshaller(new DeleteParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteParametersRequest));
            CompletableFuture<DeleteParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return A Java Future containing the result of the DeletePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Error returned if an attempt is made to delete a patch baseline that is
     *         registered for a patch group.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePatchBaselineResponse> deletePatchBaseline(
            DeletePatchBaselineRequest deletePatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePatchBaselineRequest, DeletePatchBaselineResponse>()
                            .withOperationName("DeletePatchBaseline")
                            .withMarshaller(new DeletePatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePatchBaselineRequest));
            CompletableFuture<DeletePatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes
     * are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     * @return A Java Future containing the result of the DeleteResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name wasn't found.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceDataSyncResponse> deleteResourceDataSync(
            DeleteResourceDataSyncRequest deleteResourceDataSyncRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceDataSync");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceDataSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceDataSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceDataSyncRequest, DeleteResourceDataSyncResponse>()
                            .withOperationName("DeleteResourceDataSync")
                            .withMarshaller(new DeleteResourceDataSyncRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourceDataSyncRequest));
            CompletableFuture<DeleteResourceDataSyncResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the node again at
     * any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return A Java Future containing the result of the DeregisterManagedInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterManagedInstanceResponse> deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterManagedInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterManagedInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterManagedInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterManagedInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterManagedInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterManagedInstanceRequest, DeregisterManagedInstanceResponse>()
                            .withOperationName("DeregisterManagedInstance")
                            .withMarshaller(new DeregisterManagedInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterManagedInstanceRequest));
            CompletableFuture<DeregisterManagedInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the DeregisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterPatchBaselineForPatchGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeregisterPatchBaselineForPatchGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterPatchBaselineForPatchGroupRequest, DeregisterPatchBaselineForPatchGroupResponse>()
                            .withOperationName("DeregisterPatchBaselineForPatchGroup")
                            .withMarshaller(new DeregisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterPatchBaselineForPatchGroupRequest));
            CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTargetFromMaintenanceWindow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TargetInUseException You specified the <code>Safe</code> option for the
     *         DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterTargetFromMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTargetFromMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterTargetFromMaintenanceWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeregisterTargetFromMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTargetFromMaintenanceWindowRequest, DeregisterTargetFromMaintenanceWindowResponse>()
                            .withOperationName("DeregisterTargetFromMaintenanceWindow")
                            .withMarshaller(new DeregisterTargetFromMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterTargetFromMaintenanceWindowRequest));
            CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTaskFromMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterTaskFromMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTaskFromMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterTaskFromMaintenanceWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeregisterTaskFromMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTaskFromMaintenanceWindowRequest, DeregisterTaskFromMaintenanceWindowResponse>()
                            .withOperationName("DeregisterTaskFromMaintenanceWindow")
                            .withMarshaller(new DeregisterTaskFromMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterTaskFromMaintenanceWindowRequest));
            CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the
     * number of nodes registered by using this activation.
     * </p>
     *
     * @param describeActivationsRequest
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeActivationsResponse> describeActivations(
            DescribeActivationsRequest describeActivationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActivationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeActivations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeActivationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeActivationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeActivationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeActivationsRequest, DescribeActivationsResponse>()
                            .withOperationName("DescribeActivations")
                            .withMarshaller(new DescribeActivationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeActivationsRequest));
            CompletableFuture<DescribeActivationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the
     * number of nodes registered by using this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @param describeActivationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeActivationsPublisher describeActivationsPaginator(DescribeActivationsRequest describeActivationsRequest) {
        return new DescribeActivationsPublisher(this, applyPaginatorUserAgent(describeActivationsRequest));
    }

    /**
     * <p>
     * Describes the association for the specified target or managed node. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID.
     * </p>
     *
     * @param describeAssociationRequest
     * @return A Java Future containing the result of the DescribeAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidAssociationVersionException The version you specified isn't valid. Use ListAssociationVersions
     *         to view all versions of an association according to the association ID. Or, use the
     *         <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssociationResponse> describeAssociation(
            DescribeAssociationRequest describeAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssociationRequest, DescribeAssociationResponse>()
                            .withOperationName("DescribeAssociation")
                            .withMarshaller(new DescribeAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAssociationRequest));
            CompletableFuture<DescribeAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Views information about a specific execution of a specific association.
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A Java Future containing the result of the DescribeAssociationExecutionTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID doesn't exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssociationExecutionTargetsResponse> describeAssociationExecutionTargets(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAssociationExecutionTargetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociationExecutionTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssociationExecutionTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAssociationExecutionTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAssociationExecutionTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssociationExecutionTargetsRequest, DescribeAssociationExecutionTargetsResponse>()
                            .withOperationName("DescribeAssociationExecutionTargets")
                            .withMarshaller(new DescribeAssociationExecutionTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAssociationExecutionTargetsRequest));
            CompletableFuture<DescribeAssociationExecutionTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Views information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID doesn't exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAssociationExecutionTargetsPublisher describeAssociationExecutionTargetsPaginator(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest) {
        return new DescribeAssociationExecutionTargetsPublisher(this,
                applyPaginatorUserAgent(describeAssociationExecutionTargetsRequest));
    }

    /**
     * <p>
     * Views all executions for a specific association ID.
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A Java Future containing the result of the DescribeAssociationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssociationExecutionsResponse> describeAssociationExecutions(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAssociationExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociationExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssociationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssociationExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAssociationExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssociationExecutionsRequest, DescribeAssociationExecutionsResponse>()
                            .withOperationName("DescribeAssociationExecutions")
                            .withMarshaller(new DescribeAssociationExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAssociationExecutionsRequest));
            CompletableFuture<DescribeAssociationExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Views all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAssociationExecutionsPublisher describeAssociationExecutionsPaginator(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) {
        return new DescribeAssociationExecutionsPublisher(this, applyPaginatorUserAgent(describeAssociationExecutionsRequest));
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutomationExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutomationExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAutomationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAutomationExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAutomationExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAutomationExecutionsRequest, DescribeAutomationExecutionsResponse>()
                            .withOperationName("DescribeAutomationExecutions")
                            .withMarshaller(new DescribeAutomationExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAutomationExecutionsRequest));
            CompletableFuture<DescribeAutomationExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAutomationExecutionsPublisher describeAutomationExecutionsPaginator(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) {
        return new DescribeAutomationExecutionsPublisher(this, applyPaginatorUserAgent(describeAutomationExecutionsRequest));
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A Java Future containing the result of the DescribeAutomationStepExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutomationStepExecutionsResponse> describeAutomationStepExecutions(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAutomationStepExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutomationStepExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAutomationStepExecutionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAutomationStepExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAutomationStepExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAutomationStepExecutionsRequest, DescribeAutomationStepExecutionsResponse>()
                            .withOperationName("DescribeAutomationStepExecutions")
                            .withMarshaller(new DescribeAutomationStepExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAutomationStepExecutionsRequest));
            CompletableFuture<DescribeAutomationStepExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAutomationStepExecutionsPublisher describeAutomationStepExecutionsPaginator(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest) {
        return new DescribeAutomationStepExecutionsPublisher(this,
                applyPaginatorUserAgent(describeAutomationStepExecutionsRequest));
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAvailablePatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAvailablePatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAvailablePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAvailablePatchesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAvailablePatchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAvailablePatchesRequest, DescribeAvailablePatchesResponse>()
                            .withOperationName("DescribeAvailablePatches")
                            .withMarshaller(new DescribeAvailablePatchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAvailablePatchesRequest));
            CompletableFuture<DescribeAvailablePatchesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeAvailablePatchesPublisher describeAvailablePatchesPaginator(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        return new DescribeAvailablePatchesPublisher(this, applyPaginatorUserAgent(describeAvailablePatchesRequest));
    }

    /**
     * <p>
     * Describes the specified Amazon Web Services Systems Manager document (SSM document).
     * </p>
     *
     * @param describeDocumentRequest
     * @return A Java Future containing the result of the DescribeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentResponse> describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentRequest, DescribeDocumentResponse>()
                            .withOperationName("DescribeDocument")
                            .withMarshaller(new DescribeDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDocumentRequest));
            CompletableFuture<DescribeDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the
     * document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's
     * Amazon Web Services account ID) or publicly (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return A Java Future containing the result of the DescribeDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidPermissionTypeException The permission type isn't supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentPermissionResponse> describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDocumentPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDocumentPermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentPermissionRequest, DescribeDocumentPermissionResponse>()
                            .withOperationName("DescribeDocumentPermission")
                            .withMarshaller(new DescribeDocumentPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDocumentPermissionRequest));
            CompletableFuture<DescribeDocumentPermissionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * All associations for the managed node(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A Java Future containing the result of the DescribeEffectiveInstanceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEffectiveInstanceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEffectiveInstanceAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEffectiveInstanceAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeEffectiveInstanceAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEffectiveInstanceAssociationsRequest, DescribeEffectiveInstanceAssociationsResponse>()
                            .withOperationName("DescribeEffectiveInstanceAssociations")
                            .withMarshaller(new DescribeEffectiveInstanceAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEffectiveInstanceAssociationsRequest));
            CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * All associations for the managed node(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeEffectiveInstanceAssociationsPublisher describeEffectiveInstanceAssociationsPaginator(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest) {
        return new DescribeEffectiveInstanceAssociationsPublisher(this,
                applyPaginatorUserAgent(describeEffectiveInstanceAssociationsRequest));
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline.
     * Applies to patch baselines for Windows only.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A Java Future containing the result of the DescribeEffectivePatchesForPatchBaseline operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified isn't supported, or the
     *         operation isn't supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEffectivePatchesForPatchBaselineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEffectivePatchesForPatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEffectivePatchesForPatchBaselineResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeEffectivePatchesForPatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEffectivePatchesForPatchBaselineRequest, DescribeEffectivePatchesForPatchBaselineResponse>()
                            .withOperationName("DescribeEffectivePatchesForPatchBaseline")
                            .withMarshaller(new DescribeEffectivePatchesForPatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEffectivePatchesForPatchBaselineRequest));
            CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline.
     * Applies to patch baselines for Windows only.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified isn't supported, or the
     *         operation isn't supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeEffectivePatchesForPatchBaselinePublisher describeEffectivePatchesForPatchBaselinePaginator(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest) {
        return new DescribeEffectivePatchesForPatchBaselinePublisher(this,
                applyPaginatorUserAgent(describeEffectivePatchesForPatchBaselineRequest));
    }

    /**
     * <p>
     * The status of the associations for the managed node(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A Java Future containing the result of the DescribeInstanceAssociationsStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceAssociationsStatusResponse> describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstanceAssociationsStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceAssociationsStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstanceAssociationsStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInstanceAssociationsStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstanceAssociationsStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceAssociationsStatusRequest, DescribeInstanceAssociationsStatusResponse>()
                            .withOperationName("DescribeInstanceAssociationsStatus")
                            .withMarshaller(new DescribeInstanceAssociationsStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInstanceAssociationsStatusRequest));
            CompletableFuture<DescribeInstanceAssociationsStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The status of the associations for the managed node(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstanceAssociationsStatusPublisher describeInstanceAssociationsStatusPaginator(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest) {
        return new DescribeInstanceAssociationsStatusPublisher(this,
                applyPaginatorUserAgent(describeInstanceAssociationsStatusRequest));
    }

    /**
     * <p>
     * Describes one or more of your managed nodes, including information about the operating system platform, the
     * version of SSM Agent installed on the managed node, node status, and so on.
     * </p>
     * <p>
     * If you specify one or more managed node IDs, it returns information for those managed nodes. If you don't specify
     * node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node
     * that you don't own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned
     * to on-premises managed nodes. This call doesn't return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @param describeInstanceInformationRequest
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstanceInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstanceInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInstanceInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstanceInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceInformationRequest, DescribeInstanceInformationResponse>()
                            .withOperationName("DescribeInstanceInformation")
                            .withMarshaller(new DescribeInstanceInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInstanceInformationRequest));
            CompletableFuture<DescribeInstanceInformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your managed nodes, including information about the operating system platform, the
     * version of SSM Agent installed on the managed node, node status, and so on.
     * </p>
     * <p>
     * If you specify one or more managed node IDs, it returns information for those managed nodes. If you don't specify
     * node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node
     * that you don't own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned
     * to on-premises managed nodes. This call doesn't return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstanceInformationPublisher describeInstanceInformationPaginator(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        return new DescribeInstanceInformationPublisher(this, applyPaginatorUserAgent(describeInstanceInformationRequest));
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more managed nodes.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancePatchStatesResponse> describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstancePatchStatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatchStates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstancePatchStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInstancePatchStatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstancePatchStatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchStatesRequest, DescribeInstancePatchStatesResponse>()
                            .withOperationName("DescribeInstancePatchStates")
                            .withMarshaller(new DescribeInstancePatchStatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInstancePatchStatesRequest));
            CompletableFuture<DescribeInstancePatchStatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the managed nodes in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStatesForPatchGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstancePatchStatesForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatchStatesForPatchGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstancePatchStatesForPatchGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInstancePatchStatesForPatchGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchStatesForPatchGroupRequest, DescribeInstancePatchStatesForPatchGroupResponse>()
                            .withOperationName("DescribeInstancePatchStatesForPatchGroup")
                            .withMarshaller(new DescribeInstancePatchStatesForPatchGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInstancePatchStatesForPatchGroupRequest));
            CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the managed nodes in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstancePatchStatesForPatchGroupPublisher describeInstancePatchStatesForPatchGroupPaginator(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        return new DescribeInstancePatchStatesForPatchGroupPublisher(this,
                applyPaginatorUserAgent(describeInstancePatchStatesForPatchGroupRequest));
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more managed nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstancePatchStatesPublisher describeInstancePatchStatesPaginator(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) {
        return new DescribeInstancePatchStatesPublisher(this, applyPaginatorUserAgent(describeInstancePatchStatesRequest));
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified managed node and their state relative to the patch
     * baseline being used for the node.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A Java Future containing the result of the DescribeInstancePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancePatchesResponse> describeInstancePatches(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstancePatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstancePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInstancePatchesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstancePatchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchesRequest, DescribeInstancePatchesResponse>()
                            .withOperationName("DescribeInstancePatches")
                            .withMarshaller(new DescribeInstancePatchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInstancePatchesRequest));
            CompletableFuture<DescribeInstancePatchesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified managed node and their state relative to the patch
     * baseline being used for the node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeInstancePatchesPublisher describeInstancePatchesPaginator(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        return new DescribeInstancePatchesPublisher(this, applyPaginatorUserAgent(describeInstancePatchesRequest));
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A Java Future containing the result of the DescribeInventoryDeletions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation doesn't exist or isn't valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInventoryDeletionsResponse> describeInventoryDeletions(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInventoryDeletionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInventoryDeletions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInventoryDeletionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInventoryDeletionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInventoryDeletionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInventoryDeletionsRequest, DescribeInventoryDeletionsResponse>()
                            .withOperationName("DescribeInventoryDeletions")
                            .withMarshaller(new DescribeInventoryDeletionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInventoryDeletionsRequest));
            CompletableFuture<DescribeInventoryDeletionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation doesn't exist or isn't valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInventoryDeletionsPublisher describeInventoryDeletionsPaginator(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) {
        return new DescribeInventoryDeletionsPublisher(this, applyPaginatorUserAgent(describeInventoryDeletionsRequest));
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTaskInvocations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionTaskInvocationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutionTaskInvocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowExecutionTaskInvocationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTaskInvocationsRequest, DescribeMaintenanceWindowExecutionTaskInvocationsResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutionTaskInvocations")
                            .withMarshaller(
                                    new DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMaintenanceWindowExecutionTaskInvocationsRequest));
            CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowExecutionTaskInvocationsPublisher describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        return new DescribeMaintenanceWindowExecutionTaskInvocationsPublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionTaskInvocationsRequest));
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutionTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowExecutionTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowExecutionTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTasksRequest, DescribeMaintenanceWindowExecutionTasksResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutionTasks")
                            .withMarshaller(new DescribeMaintenanceWindowExecutionTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMaintenanceWindowExecutionTasksRequest));
            CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowExecutionTasksPublisher describeMaintenanceWindowExecutionTasksPaginator(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest) {
        return new DescribeMaintenanceWindowExecutionTasksPublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionTasksRequest));
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowExecutionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionsRequest, DescribeMaintenanceWindowExecutionsResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutions")
                            .withMarshaller(new DescribeMaintenanceWindowExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowExecutionsRequest));
            CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowExecutionsPublisher describeMaintenanceWindowExecutionsPaginator(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest) {
        return new DescribeMaintenanceWindowExecutionsPublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionsRequest));
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowScheduleResponse> describeMaintenanceWindowSchedule(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowScheduleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowScheduleRequest, DescribeMaintenanceWindowScheduleResponse>()
                            .withOperationName("DescribeMaintenanceWindowSchedule")
                            .withMarshaller(new DescribeMaintenanceWindowScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowScheduleRequest));
            CompletableFuture<DescribeMaintenanceWindowScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowSchedulePublisher describeMaintenanceWindowSchedulePaginator(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest) {
        return new DescribeMaintenanceWindowSchedulePublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowScheduleRequest));
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowTargetsResponse> describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowTargetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowTargetsRequest, DescribeMaintenanceWindowTargetsResponse>()
                            .withOperationName("DescribeMaintenanceWindowTargets")
                            .withMarshaller(new DescribeMaintenanceWindowTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowTargetsRequest));
            CompletableFuture<DescribeMaintenanceWindowTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowTargetsPublisher describeMaintenanceWindowTargetsPaginator(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        return new DescribeMaintenanceWindowTargetsPublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowTargetsRequest));
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowTasksResponse> describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMaintenanceWindowTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowTasksRequest, DescribeMaintenanceWindowTasksResponse>()
                            .withOperationName("DescribeMaintenanceWindowTasks")
                            .withMarshaller(new DescribeMaintenanceWindowTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowTasksRequest));
            CompletableFuture<DescribeMaintenanceWindowTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowTasksPublisher describeMaintenanceWindowTasksPaginator(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) {
        return new DescribeMaintenanceWindowTasksPublisher(this, applyPaginatorUserAgent(describeMaintenanceWindowTasksRequest));
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an Amazon Web Services account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMaintenanceWindowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMaintenanceWindowsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowsRequest, DescribeMaintenanceWindowsResponse>()
                            .withOperationName("DescribeMaintenanceWindows")
                            .withMarshaller(new DescribeMaintenanceWindowsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowsRequest));
            CompletableFuture<DescribeMaintenanceWindowsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowsForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> describeMaintenanceWindowsForTarget(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowsForTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowsForTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceWindowsForTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMaintenanceWindowsForTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowsForTargetRequest, DescribeMaintenanceWindowsForTargetResponse>()
                            .withOperationName("DescribeMaintenanceWindowsForTarget")
                            .withMarshaller(new DescribeMaintenanceWindowsForTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceWindowsForTargetRequest));
            CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowsForTargetPublisher describeMaintenanceWindowsForTargetPaginator(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest) {
        return new DescribeMaintenanceWindowsForTargetPublisher(this,
                applyPaginatorUserAgent(describeMaintenanceWindowsForTargetRequest));
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeMaintenanceWindowsPublisher describeMaintenanceWindowsPaginator(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) {
        return new DescribeMaintenanceWindowsPublisher(this, applyPaginatorUserAgent(describeMaintenanceWindowsRequest));
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A Java Future containing the result of the DescribeOpsItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOpsItemsResponse> describeOpsItems(DescribeOpsItemsRequest describeOpsItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOpsItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOpsItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOpsItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOpsItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOpsItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOpsItemsRequest, DescribeOpsItemsResponse>()
                            .withOperationName("DescribeOpsItems")
                            .withMarshaller(new DescribeOpsItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOpsItemsRequest));
            CompletableFuture<DescribeOpsItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeOpsItemsPublisher describeOpsItemsPaginator(DescribeOpsItemsRequest describeOpsItemsRequest) {
        return new DescribeOpsItemsPublisher(this, applyPaginatorUserAgent(describeOpsItemsRequest));
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important>
     *
     * @param describeParametersRequest
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option isn't valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeParametersRequest, DescribeParametersResponse>()
                            .withOperationName("DescribeParameters")
                            .withMarshaller(new DescribeParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeParametersRequest));
            CompletableFuture<DescribeParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @param describeParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option isn't valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeParametersPublisher describeParametersPaginator(DescribeParametersRequest describeParametersRequest) {
        return new DescribeParametersPublisher(this, applyPaginatorUserAgent(describeParametersRequest));
    }

    /**
     * <p>
     * Lists the patch baselines in your Amazon Web Services account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchBaselinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchBaselines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePatchBaselinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePatchBaselinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePatchBaselinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePatchBaselinesRequest, DescribePatchBaselinesResponse>()
                            .withOperationName("DescribePatchBaselines")
                            .withMarshaller(new DescribePatchBaselinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePatchBaselinesRequest));
            CompletableFuture<DescribePatchBaselinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the patch baselines in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribePatchBaselinesPublisher describePatchBaselinesPaginator(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        return new DescribePatchBaselinesPublisher(this, applyPaginatorUserAgent(describePatchBaselinesRequest));
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state information for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return A Java Future containing the result of the DescribePatchGroupState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePatchGroupStateResponse> describePatchGroupState(
            DescribePatchGroupStateRequest describePatchGroupStateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchGroupStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchGroupState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePatchGroupStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePatchGroupStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePatchGroupStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePatchGroupStateRequest, DescribePatchGroupStateResponse>()
                            .withOperationName("DescribePatchGroupState")
                            .withMarshaller(new DescribePatchGroupStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePatchGroupStateRequest));
            CompletableFuture<DescribePatchGroupStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePatchGroupsResponse> describePatchGroups(
            DescribePatchGroupsRequest describePatchGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePatchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePatchGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePatchGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePatchGroupsRequest, DescribePatchGroupsResponse>()
                            .withOperationName("DescribePatchGroups")
                            .withMarshaller(new DescribePatchGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePatchGroupsRequest));
            CompletableFuture<DescribePatchGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribePatchGroupsPublisher describePatchGroupsPaginator(DescribePatchGroupsRequest describePatchGroupsRequest) {
        return new DescribePatchGroupsPublisher(this, applyPaginatorUserAgent(describePatchGroupsRequest));
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>,
     * and <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code>
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> |
     * <code>MSRC_SEVERITY</code>
     * </p>
     * </dd>
     * </dl>
     *
     * @param describePatchPropertiesRequest
     * @return A Java Future containing the result of the DescribePatchProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePatchPropertiesResponse> describePatchProperties(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePatchPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePatchPropertiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePatchPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePatchPropertiesRequest, DescribePatchPropertiesResponse>()
                            .withOperationName("DescribePatchProperties")
                            .withMarshaller(new DescribePatchPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePatchPropertiesRequest));
            CompletableFuture<DescribePatchPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>,
     * and <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code>
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> |
     * <code>MSRC_SEVERITY</code>
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchPropertiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribePatchPropertiesPublisher describePatchPropertiesPaginator(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) {
        return new DescribePatchPropertiesPublisher(this, applyPaginatorUserAgent(describePatchPropertiesRequest));
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     *
     * @param describeSessionsRequest
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSessionsResponse> describeSessions(DescribeSessionsRequest describeSessionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSessionsRequest, DescribeSessionsResponse>()
                            .withOperationName("DescribeSessions")
                            .withMarshaller(new DescribeSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSessionsRequest));
            CompletableFuture<DescribeSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     *
     * @param describeSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeSessionsPublisher describeSessionsPaginator(DescribeSessionsRequest describeSessionsRequest) {
        return new DescribeSessionsPublisher(this, applyPaginatorUserAgent(describeSessionsRequest));
    }

    /**
     * <p>
     * Deletes the association between an OpsItem and a related item. For example, this API operation can delete an
     * Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems
     * Manager.
     * </p>
     *
     * @param disassociateOpsItemRelatedItemRequest
     * @return A Java Future containing the result of the DisassociateOpsItemRelatedItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemRelatedItemAssociationNotFoundException The association wasn't found using the parameters you
     *         specified in the call. Verify the information and try again.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DisassociateOpsItemRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DisassociateOpsItemRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateOpsItemRelatedItemResponse> disassociateOpsItemRelatedItem(
            DisassociateOpsItemRelatedItemRequest disassociateOpsItemRelatedItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateOpsItemRelatedItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOpsItemRelatedItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateOpsItemRelatedItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateOpsItemRelatedItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateOpsItemRelatedItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateOpsItemRelatedItemRequest, DisassociateOpsItemRelatedItemResponse>()
                            .withOperationName("DisassociateOpsItemRelatedItem")
                            .withMarshaller(new DisassociateOpsItemRelatedItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateOpsItemRelatedItemRequest));
            CompletableFuture<DisassociateOpsItemRelatedItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return A Java Future containing the result of the GetAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAutomationExecutionResponse> getAutomationExecution(
            GetAutomationExecutionRequest getAutomationExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAutomationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAutomationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAutomationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAutomationExecutionRequest, GetAutomationExecutionResponse>()
                            .withOperationName("GetAutomationExecution")
                            .withMarshaller(new GetAutomationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAutomationExecutionRequest));
            CompletableFuture<GetAutomationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time.
     * If you specify a time, <code>GetCalendarState</code> returns the state of the calendar at that specific time, and
     * returns the next time that the change calendar state will transition. If you don't specify a time,
     * <code>GetCalendarState</code> uses the current time. Change Calendar entries have two possible states:
     * <code>OPEN</code> or <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon
     * Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param getCalendarStateRequest
     * @return A Java Future containing the result of the GetCalendarState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentTypeException The SSM document type isn't valid. Valid document types are described in
     *         the <code>DocumentType</code> property.</li>
     *         <li>UnsupportedCalendarException The calendar entry contained in the specified SSM document isn't
     *         supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCalendarStateResponse> getCalendarState(GetCalendarStateRequest getCalendarStateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalendarStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalendarState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCalendarStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCalendarStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCalendarStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCalendarStateRequest, GetCalendarStateResponse>()
                            .withOperationName("GetCalendarState")
                            .withMarshaller(new GetCalendarStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCalendarStateRequest));
            CompletableFuture<GetCalendarStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <p>
     * <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command
     * execution status on a specific managed node, use <a>ListCommandInvocations</a>. To get the command execution
     * status across managed nodes, use <a>ListCommands</a>.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return A Java Future containing the result of the GetCommandInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidPluginNameException The plugin name isn't valid.</li>
     *         <li>InvocationDoesNotExistException The command ID and managed node ID you specified didn't match any
     *         invocations. Verify the command ID and the managed node ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCommandInvocationResponse> getCommandInvocation(
            GetCommandInvocationRequest getCommandInvocationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCommandInvocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCommandInvocation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCommandInvocationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCommandInvocationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCommandInvocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCommandInvocationRequest, GetCommandInvocationResponse>()
                            .withOperationName("GetCommandInvocation")
                            .withMarshaller(new GetCommandInvocationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCommandInvocationRequest));
            CompletableFuture<GetCommandInvocationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready
     * to receive Session Manager connections.
     * </p>
     *
     * @param getConnectionStatusRequest
     * @return A Java Future containing the result of the GetConnectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectionStatusResponse> getConnectionStatus(
            GetConnectionStatusRequest getConnectionStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConnectionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConnectionStatusRequest, GetConnectionStatusResponse>()
                            .withOperationName("GetConnectionStatus")
                            .withMarshaller(new GetConnectionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConnectionStatusRequest));
            CompletableFuture<GetConnectionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default
     * patch baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you don't specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline(
            GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDefaultPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultPatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDefaultPatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDefaultPatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDefaultPatchBaselineRequest, GetDefaultPatchBaselineResponse>()
                            .withOperationName("GetDefaultPatchBaseline")
                            .withMarshaller(new GetDefaultPatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDefaultPatchBaselineRequest));
            CompletableFuture<GetDefaultPatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the
     * <code>AWS-RunPatchBaseline</code> Systems Manager document (SSM document).
     * </p>
     * <note>
     * <p>
     * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your
     * local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the
     * Amazon Web Services Systems Manager console. Use Run Command, a capability of Amazon Web Services Systems
     * Manager, with an SSM document that enables you to target a managed node with a script or command. For example,
     * run the command using the <code>AWS-RunShellScript</code> document or the <code>AWS-RunPowerShellScript</code>
     * document.
     * </p>
     * </note>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return A Java Future containing the result of the GetDeployablePatchSnapshotForInstance operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified isn't supported, or the
     *         operation isn't supported for the operating system.</li>
     *         <li>UnsupportedFeatureRequiredException Patching for applications released by Microsoft is only available
     *         on EC2 instances and advanced instances. To patch applications released by Microsoft on on-premises
     *         servers and VMs, you must enable advanced instances. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Enabling the advanced-instances tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDeployablePatchSnapshotForInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployablePatchSnapshotForInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeployablePatchSnapshotForInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetDeployablePatchSnapshotForInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeployablePatchSnapshotForInstanceRequest, GetDeployablePatchSnapshotForInstanceResponse>()
                            .withOperationName("GetDeployablePatchSnapshotForInstance")
                            .withMarshaller(new GetDeployablePatchSnapshotForInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeployablePatchSnapshotForInstanceRequest));
            CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
     * </p>
     *
     * @param getDocumentRequest
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentRequest, GetDocumentResponse>()
                            .withOperationName("GetDocument").withMarshaller(new GetDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDocumentRequest));
            CompletableFuture<GetDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Query inventory information. This includes managed node status, such as <code>Stopped</code> or
     * <code>Terminated</code>.
     * </p>
     *
     * @param getInventoryRequest
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator isn't valid for inventory groups. Verify that the
     *         aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInventoryResponse> getInventory(GetInventoryRequest getInventoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInventory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInventoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInventoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInventoryRequest, GetInventoryResponse>()
                            .withOperationName("GetInventory").withMarshaller(new GetInventoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInventoryRequest));
            CompletableFuture<GetInventoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Query inventory information. This includes managed node status, such as <code>Stopped</code> or
     * <code>Terminated</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @param getInventoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator isn't valid for inventory groups. Verify that the
     *         aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    public GetInventoryPublisher getInventoryPaginator(GetInventoryRequest getInventoryRequest) {
        return new GetInventoryPublisher(this, applyPaginatorUserAgent(getInventoryRequest));
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInventorySchemaResponse> getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInventorySchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInventorySchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInventorySchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInventorySchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInventorySchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInventorySchemaRequest, GetInventorySchemaResponse>()
                            .withOperationName("GetInventorySchema")
                            .withMarshaller(new GetInventorySchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInventorySchemaRequest));
            CompletableFuture<GetInventorySchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    public GetInventorySchemaPublisher getInventorySchemaPaginator(GetInventorySchemaRequest getInventorySchemaRequest) {
        return new GetInventorySchemaPublisher(this, applyPaginatorUserAgent(getInventorySchemaRequest));
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return A Java Future containing the result of the GetMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMaintenanceWindowResponse> getMaintenanceWindow(
            GetMaintenanceWindowRequest getMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse>()
                            .withOperationName("GetMaintenanceWindow")
                            .withMarshaller(new GetMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMaintenanceWindowRequest));
            CompletableFuture<GetMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMaintenanceWindowExecutionResponse> getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMaintenanceWindowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMaintenanceWindowExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMaintenanceWindowExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionRequest, GetMaintenanceWindowExecutionResponse>()
                            .withOperationName("GetMaintenanceWindowExecution")
                            .withMarshaller(new GetMaintenanceWindowExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMaintenanceWindowExecutionRequest));
            CompletableFuture<GetMaintenanceWindowExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecutionTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMaintenanceWindowExecutionTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetMaintenanceWindowExecutionTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionTaskRequest, GetMaintenanceWindowExecutionTaskResponse>()
                            .withOperationName("GetMaintenanceWindowExecutionTask")
                            .withMarshaller(new GetMaintenanceWindowExecutionTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMaintenanceWindowExecutionTaskRequest));
            CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTaskInvocation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionTaskInvocationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecutionTaskInvocation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMaintenanceWindowExecutionTaskInvocationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetMaintenanceWindowExecutionTaskInvocationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionTaskInvocationRequest, GetMaintenanceWindowExecutionTaskInvocationResponse>()
                            .withOperationName("GetMaintenanceWindowExecutionTaskInvocation")
                            .withMarshaller(new GetMaintenanceWindowExecutionTaskInvocationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getMaintenanceWindowExecutionTaskInvocationRequest));
            CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a maintenance window task.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     * <p>
     * To retrieve a list of tasks in a maintenance window, instead use the <a>DescribeMaintenanceWindowTasks</a>
     * command.
     * </p>
     *
     * @param getMaintenanceWindowTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMaintenanceWindowTaskResponse> getMaintenanceWindowTask(
            GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMaintenanceWindowTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMaintenanceWindowTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMaintenanceWindowTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMaintenanceWindowTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowTaskRequest, GetMaintenanceWindowTaskResponse>()
                            .withOperationName("GetMaintenanceWindowTask")
                            .withMarshaller(new GetMaintenanceWindowTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMaintenanceWindowTaskRequest));
            CompletableFuture<GetMaintenanceWindowTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param getOpsItemRequest
     * @return A Java Future containing the result of the GetOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpsItemResponse> getOpsItem(GetOpsItemRequest getOpsItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOpsItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOpsItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpsItemRequest, GetOpsItemResponse>().withOperationName("GetOpsItem")
                            .withMarshaller(new GetOpsItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOpsItemRequest));
            CompletableFuture<GetOpsItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     *
     * @param getOpsMetadataRequest
     * @return A Java Future containing the result of the GetOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object doesn't exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpsMetadataResponse> getOpsMetadata(GetOpsMetadataRequest getOpsMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOpsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOpsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpsMetadataRequest, GetOpsMetadataResponse>()
                            .withOperationName("GetOpsMetadata")
                            .withMarshaller(new GetOpsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOpsMetadataRequest));
            CompletableFuture<GetOpsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include
     * information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as
     * information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services
     * Systems Manager Explorer.
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A Java Future containing the result of the GetOpsSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name wasn't found.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator isn't valid for inventory groups. Verify that the
     *         aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpsSummaryResponse> getOpsSummary(GetOpsSummaryRequest getOpsSummaryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOpsSummaryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOpsSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOpsSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpsSummaryRequest, GetOpsSummaryResponse>()
                            .withOperationName("GetOpsSummary")
                            .withMarshaller(new GetOpsSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOpsSummaryRequest));
            CompletableFuture<GetOpsSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include
     * information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as
     * information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services
     * Systems Manager Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name wasn't found.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator isn't valid for inventory groups. Verify that the
     *         aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    public GetOpsSummaryPublisher getOpsSummaryPaginator(GetOpsSummaryRequest getOpsSummaryRequest) {
        return new GetOpsSummaryPublisher(this, applyPaginatorUserAgent(getOpsSummaryRequest));
    }

    /**
     * <p>
     * Get information about a single parameter by specifying the parameter name.
     * </p>
     * <note>
     * <p>
     * To get information about more than one parameter at a time, use the <a>GetParameters</a> operation.
     * </p>
     * </note>
     *
     * @param getParameterRequest
     * @return A Java Future containing the result of the GetParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version wasn't found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetParameterResponse> getParameter(GetParameterRequest getParameterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetParameterRequest, GetParameterResponse>()
                            .withOperationName("GetParameter").withMarshaller(new GetParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getParameterRequest));
            CompletableFuture<GetParameterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important>
     *
     * @param getParameterHistoryRequest
     * @return A Java Future containing the result of the GetParameterHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetParameterHistoryResponse> getParameterHistory(
            GetParameterHistoryRequest getParameterHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParameterHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameterHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetParameterHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetParameterHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetParameterHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetParameterHistoryRequest, GetParameterHistoryResponse>()
                            .withOperationName("GetParameterHistory")
                            .withMarshaller(new GetParameterHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getParameterHistoryRequest));
            CompletableFuture<GetParameterHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    public GetParameterHistoryPublisher getParameterHistoryPaginator(GetParameterHistoryRequest getParameterHistoryRequest) {
        return new GetParameterHistoryPublisher(this, applyPaginatorUserAgent(getParameterHistoryRequest));
    }

    /**
     * <p>
     * Get information about one or more parameters by specifying multiple parameter names.
     * </p>
     * <note>
     * <p>
     * To get information about a single parameter, you can use the <a>GetParameter</a> operation instead.
     * </p>
     * </note>
     *
     * @param getParametersRequest
     * @return A Java Future containing the result of the GetParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetParametersResponse> getParameters(GetParametersRequest getParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetParametersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetParametersRequest, GetParametersResponse>()
                            .withOperationName("GetParameters")
                            .withMarshaller(new GetParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getParametersRequest));
            CompletableFuture<GetParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A Java Future containing the result of the GetParametersByPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option isn't valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetParametersByPathResponse> getParametersByPath(
            GetParametersByPathRequest getParametersByPathRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParametersByPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParametersByPath");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetParametersByPathResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetParametersByPathResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetParametersByPathResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetParametersByPathRequest, GetParametersByPathResponse>()
                            .withOperationName("GetParametersByPath")
                            .withMarshaller(new GetParametersByPathRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getParametersByPathRequest));
            CompletableFuture<GetParametersByPathResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option isn't valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value isn't valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    public GetParametersByPathPublisher getParametersByPathPaginator(GetParametersByPathRequest getParametersByPathRequest) {
        return new GetParametersByPathPublisher(this, applyPaginatorUserAgent(getParametersByPathRequest));
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return A Java Future containing the result of the GetPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPatchBaselineResponse> getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPatchBaselineRequest, GetPatchBaselineResponse>()
                            .withOperationName("GetPatchBaseline")
                            .withMarshaller(new GetPatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPatchBaselineRequest));
            CompletableFuture<GetPatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the GetPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPatchBaselineForPatchGroupResponse> getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPatchBaselineForPatchGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPatchBaselineForPatchGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPatchBaselineForPatchGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPatchBaselineForPatchGroupRequest, GetPatchBaselineForPatchGroupResponse>()
                            .withOperationName("GetPatchBaselineForPatchGroup")
                            .withMarshaller(new GetPatchBaselineForPatchGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPatchBaselineForPatchGroupRequest));
            CompletableFuture<GetPatchBaselineForPatchGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of <code>false</code>. This means the user can't use this feature unless they
     * change the setting to <code>true</code> and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API operation to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the Amazon Web Services service team.
     * </p>
     * <p>
     * Query the current service setting for the Amazon Web Services account.
     * </p>
     *
     * @param getServiceSettingRequest
     *        The request body of the GetServiceSetting API operation.
     * @return A Java Future containing the result of the GetServiceSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ServiceSettingNotFoundException The specified service setting wasn't found. Either the service name
     *         or the setting hasn't been provisioned by the Amazon Web Services service team.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceSettingResponse> getServiceSetting(GetServiceSettingRequest getServiceSettingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceSetting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceSettingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceSettingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceSettingRequest, GetServiceSettingResponse>()
                            .withOperationName("GetServiceSetting")
                            .withMarshaller(new GetServiceSettingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getServiceSettingRequest));
            CompletableFuture<GetServiceSettingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version
     * number by one. A label can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you no longer want to use a parameter label, then you can either delete it or move it to a different version
     * of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "<code>aws</code>" or "<code>ssm</code>" (not case sensitive). If a label fails
     * to meet these requirements, then the label isn't associated with a parameter and the system displays it in the
     * list of InvalidLabels.
     * </p>
     * </li>
     * </ul>
     *
     * @param labelParameterVersionRequest
     * @return A Java Future containing the result of the LabelParameterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version wasn't found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>ParameterVersionLabelLimitExceededException A parameter version can have a maximum of ten labels.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<LabelParameterVersionResponse> labelParameterVersion(
            LabelParameterVersionRequest labelParameterVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, labelParameterVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "LabelParameterVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<LabelParameterVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, LabelParameterVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<LabelParameterVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<LabelParameterVersionRequest, LabelParameterVersionResponse>()
                            .withOperationName("LabelParameterVersion")
                            .withMarshaller(new LabelParameterVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(labelParameterVersionRequest));
            CompletableFuture<LabelParameterVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A Java Future containing the result of the ListAssociationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociationVersionsResponse> listAssociationVersions(
            ListAssociationVersionsRequest listAssociationVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociationVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssociationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssociationVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssociationVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssociationVersionsRequest, ListAssociationVersionsResponse>()
                            .withOperationName("ListAssociationVersions")
                            .withMarshaller(new ListAssociationVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAssociationVersionsRequest));
            CompletableFuture<ListAssociationVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListAssociationVersionsPublisher listAssociationVersionsPaginator(
            ListAssociationVersionsRequest listAssociationVersionsRequest) {
        return new ListAssociationVersionsPublisher(this, applyPaginatorUserAgent(listAssociationVersionsRequest));
    }

    /**
     * <p>
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region.
     * You can limit the results to a specific State Manager association document or managed node by specifying a
     * filter. State Manager is a capability of Amazon Web Services Systems Manager.
     * </p>
     *
     * @param listAssociationsRequest
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociationsResponse> listAssociations(ListAssociationsRequest listAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                            .withOperationName("ListAssociations")
                            .withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAssociationsRequest));
            CompletableFuture<ListAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region.
     * You can limit the results to a specific State Manager association document or managed node by specifying a
     * filter. State Manager is a capability of Amazon Web Services Systems Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAssociationsPublisher listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest) {
        return new ListAssociationsPublisher(this, applyPaginatorUserAgent(listAssociationsRequest));
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed
     * nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code>
     * against three managed nodes, then a command invocation is created for each requested managed node ID.
     * <code>ListCommandInvocations</code> provide status about command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations(
            ListCommandInvocationsRequest listCommandInvocationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommandInvocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCommandInvocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCommandInvocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCommandInvocationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCommandInvocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCommandInvocationsRequest, ListCommandInvocationsResponse>()
                            .withOperationName("ListCommandInvocations")
                            .withMarshaller(new ListCommandInvocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCommandInvocationsRequest));
            CompletableFuture<ListCommandInvocationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed
     * nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code>
     * against three managed nodes, then a command invocation is created for each requested managed node ID.
     * <code>ListCommandInvocations</code> provide status about command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    public ListCommandInvocationsPublisher listCommandInvocationsPaginator(
            ListCommandInvocationsRequest listCommandInvocationsRequest) {
        return new ListCommandInvocationsPublisher(this, applyPaginatorUserAgent(listCommandInvocationsRequest));
    }

    /**
     * <p>
     * Lists the commands requested by users of the Amazon Web Services account.
     * </p>
     *
     * @param listCommandsRequest
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCommandsResponse> listCommands(ListCommandsRequest listCommandsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommandsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCommands");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCommandsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCommandsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCommandsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCommandsRequest, ListCommandsResponse>()
                            .withOperationName("ListCommands").withMarshaller(new ListCommandsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCommandsRequest));
            CompletableFuture<ListCommandsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the commands requested by users of the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @param listCommandsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException The specified command ID isn't valid. Verify the ID and try again.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    public ListCommandsPublisher listCommandsPaginator(ListCommandsRequest listCommandsRequest) {
        return new ListCommandsPublisher(this, applyPaginatorUserAgent(listCommandsRequest));
    }

    /**
     * <p>
     * For a specified resource ID, this API operation returns a list of compliance statuses for different resource
     * types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in
     * the filter.
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A Java Future containing the result of the ListComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListComplianceItemsResponse> listComplianceItems(
            ListComplianceItemsRequest listComplianceItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComplianceItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComplianceItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComplianceItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComplianceItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComplianceItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComplianceItemsRequest, ListComplianceItemsResponse>()
                            .withOperationName("ListComplianceItems")
                            .withMarshaller(new ListComplianceItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listComplianceItemsRequest));
            CompletableFuture<ListComplianceItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a specified resource ID, this API operation returns a list of compliance statuses for different resource
     * types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in
     * the filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    public ListComplianceItemsPublisher listComplianceItemsPaginator(ListComplianceItemsRequest listComplianceItemsRequest) {
        return new ListComplianceItemsPublisher(this, applyPaginatorUserAgent(listComplianceItemsRequest));
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries(
            ListComplianceSummariesRequest listComplianceSummariesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComplianceSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComplianceSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListComplianceSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListComplianceSummariesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListComplianceSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListComplianceSummariesRequest, ListComplianceSummariesResponse>()
                            .withOperationName("ListComplianceSummaries")
                            .withMarshaller(new ListComplianceSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listComplianceSummariesRequest));
            CompletableFuture<ListComplianceSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    public ListComplianceSummariesPublisher listComplianceSummariesPaginator(
            ListComplianceSummariesRequest listComplianceSummariesRequest) {
        return new ListComplianceSummariesPublisher(this, applyPaginatorUserAgent(listComplianceSummariesRequest));
    }

    /**
     * <p>
     * Information about approval reviews for a version of a change template in Change Manager.
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     * @return A Java Future containing the result of the ListDocumentMetadataHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentMetadataHistoryResponse> listDocumentMetadataHistory(
            ListDocumentMetadataHistoryRequest listDocumentMetadataHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentMetadataHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentMetadataHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentMetadataHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentMetadataHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentMetadataHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentMetadataHistoryRequest, ListDocumentMetadataHistoryResponse>()
                            .withOperationName("ListDocumentMetadataHistory")
                            .withMarshaller(new ListDocumentMetadataHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDocumentMetadataHistoryRequest));
            CompletableFuture<ListDocumentMetadataHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A Java Future containing the result of the ListDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentVersionsResponse> listDocumentVersions(
            ListDocumentVersionsRequest listDocumentVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentVersionsRequest, ListDocumentVersionsResponse>()
                            .withOperationName("ListDocumentVersions")
                            .withMarshaller(new ListDocumentVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDocumentVersionsRequest));
            CompletableFuture<ListDocumentVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDocumentVersionsPublisher listDocumentVersionsPaginator(ListDocumentVersionsRequest listDocumentVersionsRequest) {
        return new ListDocumentVersionsPublisher(this, applyPaginatorUserAgent(listDocumentVersionsRequest));
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services
     * Region. You can limit the results of this request by using a filter.
     * </p>
     *
     * @param listDocumentsRequest
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentsResponse> listDocuments(ListDocumentsRequest listDocumentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocuments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDocumentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentsRequest, ListDocumentsResponse>()
                            .withOperationName("ListDocuments")
                            .withMarshaller(new ListDocumentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDocumentsRequest));
            CompletableFuture<ListDocumentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services
     * Region. You can limit the results of this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InvalidFilterKeyException The specified key isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDocumentsPublisher listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest) {
        return new ListDocumentsPublisher(this, applyPaginatorUserAgent(listDocumentsRequest));
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return A Java Future containing the result of the ListInventoryEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInventoryEntriesResponse> listInventoryEntries(
            ListInventoryEntriesRequest listInventoryEntriesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInventoryEntriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInventoryEntries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInventoryEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInventoryEntriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInventoryEntriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInventoryEntriesRequest, ListInventoryEntriesResponse>()
                            .withOperationName("ListInventoryEntries")
                            .withMarshaller(new ListInventoryEntriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listInventoryEntriesRequest));
            CompletableFuture<ListInventoryEntriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account.
     * You can limit the results to events associated with specific OpsItems by specifying a filter.
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A Java Future containing the result of the ListOpsItemEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpsItemEventsResponse> listOpsItemEvents(ListOpsItemEventsRequest listOpsItemEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsItemEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsItemEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOpsItemEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOpsItemEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOpsItemEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpsItemEventsRequest, ListOpsItemEventsResponse>()
                            .withOperationName("ListOpsItemEvents")
                            .withMarshaller(new ListOpsItemEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOpsItemEventsRequest));
            CompletableFuture<ListOpsItemEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account.
     * You can limit the results to events associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    public ListOpsItemEventsPublisher listOpsItemEventsPaginator(ListOpsItemEventsRequest listOpsItemEventsRequest) {
        return new ListOpsItemEventsPublisher(this, applyPaginatorUserAgent(listOpsItemEventsRequest));
    }

    /**
     * <p>
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability
     * of Amazon Web Services Systems Manager.
     * </p>
     *
     * @param listOpsItemRelatedItemsRequest
     * @return A Java Future containing the result of the ListOpsItemRelatedItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpsItemRelatedItemsResponse> listOpsItemRelatedItems(
            ListOpsItemRelatedItemsRequest listOpsItemRelatedItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsItemRelatedItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsItemRelatedItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOpsItemRelatedItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOpsItemRelatedItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOpsItemRelatedItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpsItemRelatedItemsRequest, ListOpsItemRelatedItemsResponse>()
                            .withOperationName("ListOpsItemRelatedItems")
                            .withMarshaller(new ListOpsItemRelatedItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOpsItemRelatedItemsRequest));
            CompletableFuture<ListOpsItemRelatedItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability
     * of Amazon Web Services Systems Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemRelatedItems(software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsPublisher publisher = client.listOpsItemRelatedItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsPublisher publisher = client.listOpsItemRelatedItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemRelatedItems(software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOpsItemRelatedItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems" target="_top">AWS
     *      API Documentation</a>
     */
    public ListOpsItemRelatedItemsPublisher listOpsItemRelatedItemsPaginator(
            ListOpsItemRelatedItemsRequest listOpsItemRelatedItemsRequest) {
        return new ListOpsItemRelatedItemsPublisher(this, applyPaginatorUserAgent(listOpsItemRelatedItemsRequest));
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata
     * objects or blobs.
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A Java Future containing the result of the ListOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpsMetadataResponse> listOpsMetadata(ListOpsMetadataRequest listOpsMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOpsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOpsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpsMetadataRequest, ListOpsMetadataResponse>()
                            .withOperationName("ListOpsMetadata")
                            .withMarshaller(new ListOpsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOpsMetadataRequest));
            CompletableFuture<ListOpsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata
     * objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher publisher = client.listOpsMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher publisher = client.listOpsMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)} operation.</b>
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    public ListOpsMetadataPublisher listOpsMetadataPaginator(ListOpsMetadataRequest listOpsMetadataRequest) {
        return new ListOpsMetadataPublisher(this, applyPaginatorUserAgent(listOpsMetadataRequest));
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return A Java Future containing the result of the ListResourceComplianceSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceComplianceSummariesResponse> listResourceComplianceSummaries(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceComplianceSummariesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceComplianceSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceComplianceSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceComplianceSummariesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceComplianceSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceComplianceSummariesRequest, ListResourceComplianceSummariesResponse>()
                            .withOperationName("ListResourceComplianceSummaries")
                            .withMarshaller(new ListResourceComplianceSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceComplianceSummariesRequest));
            CompletableFuture<ListResourceComplianceSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesPublisher publisher = client.listResourceComplianceSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesPublisher publisher = client.listResourceComplianceSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name isn't valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourceComplianceSummariesPublisher listResourceComplianceSummariesPaginator(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) {
        return new ListResourceComplianceSummariesPublisher(this, applyPaginatorUserAgent(listResourceComplianceSummariesRequest));
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return A Java Future containing the result of the ListResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDataSyncResponse> listResourceDataSync(
            ListResourceDataSyncRequest listResourceDataSyncRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDataSync");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDataSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceDataSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDataSyncRequest, ListResourceDataSyncResponse>()
                            .withOperationName("ListResourceDataSync")
                            .withMarshaller(new ListResourceDataSyncRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceDataSyncRequest));
            CompletableFuture<ListResourceDataSyncResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncPublisher publisher = client.listResourceDataSyncPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncPublisher publisher = client.listResourceDataSyncPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    public ListResourceDataSyncPublisher listResourceDataSyncPaginator(ListResourceDataSyncRequest listResourceDataSyncRequest) {
        return new ListResourceDataSyncPublisher(this, applyPaginatorUserAgent(listResourceDataSyncRequest));
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified resource.
     * </p>
     * <p>
     * For information about the ID format for each supported resource type, see <a>AddTagsToResource</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a
     * document privately, you must specify the Amazon Web Services user account IDs for those people who can use the
     * document. If you share a document publicly, you must specify <i>All</i> as the account ID.
     * </p>
     *
     * @param modifyDocumentPermissionRequest
     * @return A Java Future containing the result of the ModifyDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidPermissionTypeException The permission type isn't supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>DocumentPermissionLimitException The document can't be shared with more Amazon Web Services user
     *         accounts. You can specify a maximum of 20 accounts per API operation to share a private document.</p>
     *         <p>
     *         By default, you can share a private document with a maximum of 1,000 accounts and publicly share up to
     *         five documents.
     *         </p>
     *         <p>
     *         If you need to increase the quota for privately or publicly shared Systems Manager documents, contact
     *         Amazon Web Services Support.</li>
     *         <li>DocumentLimitExceededException You can have at most 500 active SSM documents.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ModifyDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyDocumentPermissionResponse> modifyDocumentPermission(
            ModifyDocumentPermissionRequest modifyDocumentPermissionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDocumentPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDocumentPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ModifyDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ModifyDocumentPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ModifyDocumentPermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyDocumentPermissionRequest, ModifyDocumentPermissionResponse>()
                            .withOperationName("ModifyDocumentPermission")
                            .withMarshaller(new ModifyDocumentPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyDocumentPermissionRequest));
            CompletableFuture<ModifyDocumentPermissionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a compliance type and other compliance details on a designated resource. This operation lets you
     * register custom compliance details with a resource. This call overwrites existing compliance information on the
     * resource, so you must provide a full list of compliance items each time that you send the request.
     * </p>
     * <p>
     * ComplianceType can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecutionType: Specify patch, association, or Custom:<code>string</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.
     * </p>
     * </li>
     * <li>
     * <p>
     * Id: The patch, association, or custom compliance ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Title: A title.
     * </p>
     * </li>
     * <li>
     * <p>
     * Status: The status of the compliance item. For example, <code>approved</code> for patches, or <code>Failed</code>
     * for associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * Severity: A patch severity. For example, <code>Critical</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DocumentName: An SSM document name. For example, <code>AWS-RunPatchBaseline</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DocumentVersion: An SSM document version number. For example, 4.
     * </p>
     * </li>
     * <li>
     * <p>
     * Classification: A patch classification. For example, <code>security updates</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchBaselineId: A patch baseline ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchSeverity: A patch severity. For example, <code>Critical</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchGroup: The name of a patch group.
     * </p>
     * </li>
     * <li>
     * <p>
     * InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify
     * the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'
     * </p>
     * </li>
     * </ul>
     *
     * @param putComplianceItemsRequest
     * @return A Java Future containing the result of the PutComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidItemContentException One or more content items isn't valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ComplianceTypeCountLimitExceededException You specified too many custom compliance types. You can
     *         specify a maximum of 10 different types.</li>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.PutComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutComplianceItemsResponse> putComplianceItems(PutComplianceItemsRequest putComplianceItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComplianceItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComplianceItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutComplianceItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutComplianceItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutComplianceItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutComplianceItemsRequest, PutComplianceItemsResponse>()
                            .withOperationName("PutComplianceItems")
                            .withMarshaller(new PutComplianceItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putComplianceItemsRequest));
            CompletableFuture<PutComplianceItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it
     * doesn't already exist, or updates an inventory item, if it does exist.
     * </p>
     *
     * @param putInventoryRequest
     * @return A Java Future containing the result of the PutInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidTypeNameException The parameter type name isn't valid.</li>
     *         <li>InvalidItemContentException One or more content items isn't valid.</li>
     *         <li>TotalSizeLimitExceededException The size of inventory data has exceeded the total size limit for the
     *         resource.</li>
     *         <li>ItemSizeLimitExceededException The inventory item size has exceeded the size limit.</li>
     *         <li>ItemContentMismatchException The inventory item has invalid content.</li>
     *         <li>CustomSchemaCountLimitExceededException You have exceeded the limit for custom schemas. Delete one or
     *         more custom schemas and try again.</li>
     *         <li>UnsupportedInventorySchemaVersionException Inventory item type schema version has to match supported
     *         versions in the service. Check output of GetInventorySchema to see the available schema version for each
     *         type.</li>
     *         <li>UnsupportedInventoryItemContextException The <code>Context</code> attribute that you specified for
     *         the <code>InventoryItem</code> isn't allowed for this inventory type. You can only use the
     *         <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</li>
     *         <li>InvalidInventoryItemContextException You specified invalid keys or values in the <code>Context</code>
     *         attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</li>
     *         <li>SubTypeCountLimitExceededException The sub-type count exceeded the limit for the inventory type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.PutInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutInventoryResponse> putInventory(PutInventoryRequest putInventoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInventory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutInventoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInventoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInventoryRequest, PutInventoryResponse>()
                            .withOperationName("PutInventory").withMarshaller(new PutInventoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putInventoryRequest));
            CompletableFuture<PutInventoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add a parameter to the system.
     * </p>
     *
     * @param putParameterRequest
     * @return A Java Future containing the result of the PutParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID isn't valid.</li>
     *         <li>ParameterLimitExceededException You have exceeded the number of parameters for this Amazon Web
     *         Services account. Delete one or more parameters and try again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterAlreadyExistsException The parameter already exists. You can't create duplicate parameters.</li>
     *         <li>HierarchyLevelLimitExceededException A hierarchy can have a maximum of 15 levels. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html"
     *         >Requirements and constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.</li>
     *         <li>HierarchyTypeMismatchException Parameter Store doesn't support changing a parameter type in a
     *         hierarchy. For example, you can't change a parameter from a <code>String</code> type to a
     *         <code>SecureString</code> type. You must create a new, unique parameter.</li>
     *         <li>InvalidAllowedPatternException The request doesn't meet the regular expression requirement.</li>
     *         <li>ParameterMaxVersionLimitExceededException Parameter Store retains the 100 most recently created
     *         versions of a parameter. After this number of versions has been created, Parameter Store deletes the
     *         oldest version when a new one is created. However, if the oldest version has a <i>label</i> attached to
     *         it, Parameter Store won't delete the version and instead presents this error message:</p>
     *         <p>
     *         <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter operation: You attempted to create a new version of <i>parameter-name</i> by calling the PutParameter API with the overwrite flag. Version <i>version-number</i>, the oldest version, can't be deleted because it has a label associated with it. Move the label to another version of the parameter, and try again.</code>
     *         </p>
     *         <p>
     *         This safeguard is to prevent parameter versions with mission critical labels assigned to them from being
     *         deleted. To continue creating new parameters, first move the label from the oldest version of the
     *         parameter to a newer one for use in your operations. For information about moving parameter labels, see
     *         <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move"
     *         >Move a parameter label (console)</a> or <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move"
     *         >Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</li>
     *         <li>ParameterPatternMismatchException The parameter name isn't valid.</li>
     *         <li>UnsupportedParameterTypeException The parameter type isn't supported.</li>
     *         <li>PoliciesLimitExceededException You specified more than the maximum number of allowed policies for the
     *         parameter. The maximum is 10.</li>
     *         <li>InvalidPolicyTypeException The policy type isn't supported. Parameter Store supports the following
     *         policy types: Expiration, ExpirationNotification, and NoChangeNotification.</li>
     *         <li>InvalidPolicyAttributeException A policy attribute or its value is invalid.</li>
     *         <li>IncompatiblePolicyException There is a conflict in the policies specified for this parameter. You
     *         can't, for example, specify two Expiration policies for a parameter. Review your policies, and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.PutParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutParameterResponse> putParameter(PutParameterRequest putParameterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutParameter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutParameterRequest, PutParameterResponse>()
                            .withOperationName("PutParameter").withMarshaller(new PutParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putParameterRequest));
            CompletableFuture<PutParameterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines the default patch baseline for the relevant operating system.
     * </p>
     * <p>
     * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon
     * Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
     * <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed</code> instead of
     * <code>pb-0574b43a65ea646ed</code>.
     * </p>
     *
     * @param registerDefaultPatchBaselineRequest
     * @return A Java Future containing the result of the RegisterDefaultPatchBaseline operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.RegisterDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterDefaultPatchBaselineResponse> registerDefaultPatchBaseline(
            RegisterDefaultPatchBaselineRequest registerDefaultPatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerDefaultPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterDefaultPatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterDefaultPatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterDefaultPatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterDefaultPatchBaselineRequest, RegisterDefaultPatchBaselineResponse>()
                            .withOperationName("RegisterDefaultPatchBaseline")
                            .withMarshaller(new RegisterDefaultPatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerDefaultPatchBaselineRequest));
            CompletableFuture<RegisterDefaultPatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a patch baseline for a patch group.
     * </p>
     *
     * @param registerPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the RegisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Error returned if an attempt is made to register a patch group with a patch
     *         baseline that is already registered with a different patch baseline.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.RegisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterPatchBaselineForPatchGroupResponse> registerPatchBaselineForPatchGroup(
            RegisterPatchBaselineForPatchGroupRequest registerPatchBaselineForPatchGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterPatchBaselineForPatchGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RegisterPatchBaselineForPatchGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterPatchBaselineForPatchGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterPatchBaselineForPatchGroupRequest, RegisterPatchBaselineForPatchGroupResponse>()
                            .withOperationName("RegisterPatchBaselineForPatchGroup")
                            .withMarshaller(new RegisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerPatchBaselineForPatchGroupRequest));
            CompletableFuture<RegisterPatchBaselineForPatchGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a target with a maintenance window.
     * </p>
     *
     * @param registerTargetWithMaintenanceWindowRequest
     * @return A Java Future containing the result of the RegisterTargetWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.RegisterTargetWithMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterTargetWithMaintenanceWindowResponse> registerTargetWithMaintenanceWindow(
            RegisterTargetWithMaintenanceWindowRequest registerTargetWithMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerTargetWithMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTargetWithMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterTargetWithMaintenanceWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RegisterTargetWithMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterTargetWithMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterTargetWithMaintenanceWindowRequest, RegisterTargetWithMaintenanceWindowResponse>()
                            .withOperationName("RegisterTargetWithMaintenanceWindow")
                            .withMarshaller(new RegisterTargetWithMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerTargetWithMaintenanceWindowRequest));
            CompletableFuture<RegisterTargetWithMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new task to a maintenance window.
     * </p>
     *
     * @param registerTaskWithMaintenanceWindowRequest
     * @return A Java Future containing the result of the RegisterTaskWithMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>FeatureNotAvailableException You attempted to register a <code>LAMBDA</code> or
     *         <code>STEP_FUNCTIONS</code> task in a region where the corresponding service isn't available.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.RegisterTaskWithMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterTaskWithMaintenanceWindowResponse> registerTaskWithMaintenanceWindow(
            RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerTaskWithMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTaskWithMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterTaskWithMaintenanceWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RegisterTaskWithMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterTaskWithMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterTaskWithMaintenanceWindowRequest, RegisterTaskWithMaintenanceWindowResponse>()
                            .withOperationName("RegisterTaskWithMaintenanceWindow")
                            .withMarshaller(new RegisterTaskWithMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerTaskWithMaintenanceWindowRequest));
            CompletableFuture<RegisterTaskWithMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tag keys from the specified resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type isn't valid. For example, if you are attempting to tag
     *         an EC2 instance, the instance must be a registered managed node.</li>
     *         <li>InvalidResourceIdException The resource ID isn't valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource")
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromResourceRequest));
            CompletableFuture<RemoveTagsFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of "false". This means the user can't use this feature unless they change the
     * setting to "true" and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>GetServiceSetting</a> API operation to view the current value. Use the <a>UpdateServiceSetting</a> API
     * operation to change the default setting.
     * </p>
     * <p>
     * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services service
     * team.
     * </p>
     *
     * @param resetServiceSettingRequest
     *        The request body of the ResetServiceSetting API operation.
     * @return A Java Future containing the result of the ResetServiceSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ServiceSettingNotFoundException The specified service setting wasn't found. Either the service name
     *         or the setting hasn't been provisioned by the Amazon Web Services service team.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ResetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetServiceSettingResponse> resetServiceSetting(
            ResetServiceSettingRequest resetServiceSettingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetServiceSetting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetServiceSettingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetServiceSettingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetServiceSettingRequest, ResetServiceSettingResponse>()
                            .withOperationName("ResetServiceSetting")
                            .withMarshaller(new ResetServiceSettingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetServiceSettingRequest));
            CompletableFuture<ResetServiceSettingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for
     * disconnected sessions, but not terminated sessions.
     * </p>
     * <note>
     * <p>
     * This command is primarily for use by client machines to automatically reconnect during intermittent network
     * issues. It isn't intended for any other use.
     * </p>
     * </note>
     *
     * @param resumeSessionRequest
     * @return A Java Future containing the result of the ResumeSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ResumeSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResumeSessionResponse> resumeSession(ResumeSessionRequest resumeSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResumeSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResumeSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResumeSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResumeSessionRequest, ResumeSessionResponse>()
                            .withOperationName("ResumeSession")
                            .withMarshaller(new ResumeSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resumeSessionRequest));
            CompletableFuture<ResumeSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a signal to an Automation execution to change the current behavior or status of the execution.
     * </p>
     *
     * @param sendAutomationSignalRequest
     * @return A Java Future containing the result of the SendAutomationSignal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>AutomationStepNotFoundException The specified step name and execution ID don't exist. Verify the
     *         information and try again.</li>
     *         <li>InvalidAutomationSignalException The signal isn't valid for the current Automation execution.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.SendAutomationSignal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendAutomationSignalResponse> sendAutomationSignal(
            SendAutomationSignalRequest sendAutomationSignalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendAutomationSignalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendAutomationSignal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendAutomationSignalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendAutomationSignalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendAutomationSignalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendAutomationSignalRequest, SendAutomationSignalResponse>()
                            .withOperationName("SendAutomationSignal")
                            .withMarshaller(new SendAutomationSignalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendAutomationSignalRequest));
            CompletableFuture<SendAutomationSignalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs commands on one or more managed nodes.
     * </p>
     *
     * @param sendCommandRequest
     * @return A Java Future containing the result of the SendCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateInstanceIdException You can't specify a managed node ID in more than one association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidOutputFolderException The S3 bucket doesn't exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Amazon Web
     *         Services Systems Manager document (SSM document). You can only supply values to parameters defined in the
     *         SSM document.</li>
     *         <li>UnsupportedPlatformTypeException The document doesn't support the platform type of the given managed
     *         node ID(s). For example, you sent an document for a Windows managed node to a Linux node.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InvalidRoleException The role name can't contain invalid characters. Also verify that you specified
     *         an IAM role for notifications that includes the required trust policy. For information about configuring
     *         the IAM role for Run Command notifications, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring
     *         Amazon SNS Notifications for Run Command</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.</li>
     *         <li>InvalidNotificationConfigException One or more configuration items isn't valid. Verify that a valid
     *         Amazon Resource Name (ARN) was provided for an Amazon Simple Notification Service topic.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.SendCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendCommandResponse> sendCommand(SendCommandRequest sendCommandRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendCommand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendCommandResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendCommandResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendCommandRequest, SendCommandResponse>()
                            .withOperationName("SendCommand").withMarshaller(new SendCommandRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendCommandRequest));
            CompletableFuture<SendCommandResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs an association immediately and only one time. This operation can be helpful when troubleshooting
     * associations.
     * </p>
     *
     * @param startAssociationsOnceRequest
     * @return A Java Future containing the result of the StartAssociationsOnce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidAssociationException The association isn't valid or doesn't exist.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.StartAssociationsOnce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartAssociationsOnceResponse> startAssociationsOnce(
            StartAssociationsOnceRequest startAssociationsOnceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAssociationsOnceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAssociationsOnce");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAssociationsOnceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAssociationsOnceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAssociationsOnceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAssociationsOnceRequest, StartAssociationsOnceResponse>()
                            .withOperationName("StartAssociationsOnce")
                            .withMarshaller(new StartAssociationsOnceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startAssociationsOnceRequest));
            CompletableFuture<StartAssociationsOnceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates execution of an Automation runbook.
     * </p>
     *
     * @param startAutomationExecutionRequest
     * @return A Java Future containing the result of the StartAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationDefinitionNotFoundException An Automation runbook with the specified name couldn't be
     *         found.</li>
     *         <li>InvalidAutomationExecutionParametersException The supplied parameters for invoking the specified
     *         Automation runbook are incorrect. For example, they may not match the set of parameters permitted for the
     *         specified Automation document.</li>
     *         <li>AutomationExecutionLimitExceededException The number of simultaneously running Automation executions
     *         exceeded the allowable limit.</li>
     *         <li>AutomationDefinitionVersionNotFoundException An Automation runbook with the specified name and
     *         version couldn't be found.</li>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>InvalidTargetException The target isn't valid or doesn't exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.StartAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAutomationExecutionResponse> startAutomationExecution(
            StartAutomationExecutionRequest startAutomationExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAutomationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAutomationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAutomationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAutomationExecutionRequest, StartAutomationExecutionResponse>()
                            .withOperationName("StartAutomationExecution")
                            .withMarshaller(new StartAutomationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startAutomationExecutionRequest));
            CompletableFuture<StartAutomationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a change request for Change Manager. The Automation runbooks specified in the change request run only
     * after all required approvals for the change request have been received.
     * </p>
     *
     * @param startChangeRequestExecutionRequest
     * @return A Java Future containing the result of the StartChangeRequestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationDefinitionNotFoundException An Automation runbook with the specified name couldn't be
     *         found.</li>
     *         <li>InvalidAutomationExecutionParametersException The supplied parameters for invoking the specified
     *         Automation runbook are incorrect. For example, they may not match the set of parameters permitted for the
     *         specified Automation document.</li>
     *         <li>AutomationExecutionLimitExceededException The number of simultaneously running Automation executions
     *         exceeded the allowable limit.</li>
     *         <li>AutomationDefinitionVersionNotFoundException An Automation runbook with the specified name and
     *         version couldn't be found.</li>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AutomationDefinitionNotApprovedException Indicates that the Change Manager change template used in
     *         the change request was rejected or is still in a pending state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.StartChangeRequestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartChangeRequestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartChangeRequestExecutionResponse> startChangeRequestExecution(
            StartChangeRequestExecutionRequest startChangeRequestExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startChangeRequestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartChangeRequestExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartChangeRequestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartChangeRequestExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartChangeRequestExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartChangeRequestExecutionRequest, StartChangeRequestExecutionResponse>()
                            .withOperationName("StartChangeRequestExecution")
                            .withMarshaller(new StartChangeRequestExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startChangeRequestExecutionRequest));
            CompletableFuture<StartChangeRequestExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and
     * token that can be used to open a WebSocket connection for sending input and receiving outputs.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services CLI usage: <code>start-session</code> is an interactive command that requires the Session
     * Manager plugin to be installed on the client machine making the call. For information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html"
     * >Install the Session Manager plugin for the Amazon Web Services CLI</a> in the <i>Amazon Web Services Systems
     * Manager User Guide</i>.
     * </p>
     * <p>
     * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services
     * Tools for PowerShell on Windows local machines.
     * </p>
     * </note>
     *
     * @param startSessionRequest
     * @return A Java Future containing the result of the StartSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>TargetNotConnectedException The specified target managed node for the session isn't fully configured
     *         for use with Session Manager. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html"
     *         >Getting started with Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     *         This error is also returned if you attempt to start a session on a managed node that is located in a
     *         different account or Region</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartSessionResponse> startSession(StartSessionRequest startSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSessionRequest, StartSessionResponse>()
                            .withOperationName("StartSession").withMarshaller(new StartSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startSessionRequest));
            CompletableFuture<StartSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stop an Automation that is currently running.
     * </p>
     *
     * @param stopAutomationExecutionRequest
     * @return A Java Future containing the result of the StopAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidAutomationStatusUpdateException The specified update status operation isn't valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.StopAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopAutomationExecutionResponse> stopAutomationExecution(
            StopAutomationExecutionRequest stopAutomationExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopAutomationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopAutomationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopAutomationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopAutomationExecutionRequest, StopAutomationExecutionResponse>()
                            .withOperationName("StopAutomationExecution")
                            .withMarshaller(new StopAutomationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopAutomationExecutionRequest));
            CompletableFuture<StopAutomationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the
     * managed node. A terminated session can't be resumed.
     * </p>
     *
     * @param terminateSessionRequest
     * @return A Java Future containing the result of the TerminateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TerminateSessionResponse> terminateSession(TerminateSessionRequest terminateSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TerminateSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TerminateSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TerminateSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TerminateSessionRequest, TerminateSessionResponse>()
                            .withOperationName("TerminateSession")
                            .withMarshaller(new TerminateSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(terminateSessionRequest));
            CompletableFuture<TerminateSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove a label or labels from a parameter.
     * </p>
     *
     * @param unlabelParameterVersionRequest
     * @return A Java Future containing the result of the UnlabelParameterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterNotFoundException The parameter couldn't be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version wasn't found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UnlabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlabelParameterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UnlabelParameterVersionResponse> unlabelParameterVersion(
            UnlabelParameterVersionRequest unlabelParameterVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unlabelParameterVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnlabelParameterVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnlabelParameterVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UnlabelParameterVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnlabelParameterVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnlabelParameterVersionRequest, UnlabelParameterVersionResponse>()
                            .withOperationName("UnlabelParameterVersion")
                            .withMarshaller(new UnlabelParameterVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(unlabelParameterVersionRequest));
            CompletableFuture<UnlabelParameterVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an association. You can update the association name and version, the document version, schedule,
     * parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call <code>UpdateAssociation</code>,
     * the system removes all optional parameters from the request and overwrites the association with null values for
     * those parameters. This is by design. You must specify all optional parameters in the call, even if you are not
     * changing the parameters. This includes the <code>Name</code> parameter. Before calling this API action, we
     * recommend that you call the <a>DescribeAssociation</a> API operation and make a note of all optional parameters
     * required for your <code>UpdateAssociation</code> call.
     * </p>
     * <p>
     * In order to call this API operation, your Identity and Access Management (IAM) user account, group, or role must
     * be configured with permission to call the <a>DescribeAssociation</a> API operation. If you don't have permission
     * to call <code>DescribeAssociation</code>, then you receive the following error:
     * <code>An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: &lt;user_arn&gt; isn't authorized to perform: ssm:DescribeAssociation on resource: &lt;resource_arn&gt;</code>
     * </p>
     * <important>
     * <p>
     * When you update an association, the association immediately runs against the specified targets. You can add the
     * <code>ApplyOnlyAtCronInterval</code> parameter to run the association during the next schedule run.
     * </p>
     * </important>
     *
     * @param updateAssociationRequest
     * @return A Java Future containing the result of the UpdateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Amazon Web
     *         Services Systems Manager document (SSM document). You can only supply values to parameters defined in the
     *         SSM document.</li>
     *         <li>InvalidOutputLocationException The output location isn't valid or doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>InvalidUpdateException The update isn't valid.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidTargetException The target isn't valid or doesn't exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidAssociationVersionException The version you specified isn't valid. Use ListAssociationVersions
     *         to view all versions of an association according to the association ID. Or, use the
     *         <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>AssociationVersionLimitExceededException You have reached the maximum number versions allowed for an
     *         association. Each association has a limit of 1,000 versions.</li>
     *         <li>InvalidTargetMapsException TargetMap parameter isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssociationResponse> updateAssociation(UpdateAssociationRequest updateAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssociationRequest, UpdateAssociationResponse>()
                            .withOperationName("UpdateAssociation")
                            .withMarshaller(new UpdateAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAssociationRequest));
            CompletableFuture<UpdateAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the
     * specified managed node.
     * </p>
     * <p>
     * <code>UpdateAssociationStatus</code> is primarily used by the Amazon Web Services Systems Manager Agent (SSM
     * Agent) to report status updates about your associations and is only used for associations created with the
     * <code>InstanceId</code> legacy parameter.
     * </p>
     *
     * @param updateAssociationStatusRequest
     * @return A Java Future containing the result of the UpdateAssociationStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>AssociationDoesNotExistException The specified association doesn't exist.</li>
     *         <li>StatusUnchangedException The updated status is the same as the current status.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateAssociationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssociationStatusResponse> updateAssociationStatus(
            UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssociationStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssociationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssociationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssociationStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssociationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssociationStatusRequest, UpdateAssociationStatusResponse>()
                            .withOperationName("UpdateAssociationStatus")
                            .withMarshaller(new UpdateAssociationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAssociationStatusRequest));
            CompletableFuture<UpdateAssociationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates one or more values for an SSM document.
     * </p>
     *
     * @param updateDocumentRequest
     * @return A Java Future containing the result of the UpdateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>DocumentVersionLimitExceededException The document has too many versions. Delete one or more document
     *         versions and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DuplicateDocumentContentException The content of the association document matches another document.
     *         Change the content of the document and try again.</li>
     *         <li>DuplicateDocumentVersionNameException The version name has already been used in this document.
     *         Specify a different version name, and then try again.</li>
     *         <li>InvalidDocumentContentException The content for the document isn't valid.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema isn't supported.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDocumentResponse> updateDocument(UpdateDocumentRequest updateDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentRequest, UpdateDocumentResponse>()
                            .withOperationName("UpdateDocument")
                            .withMarshaller(new UpdateDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDocumentRequest));
            CompletableFuture<UpdateDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set the default version of a document.
     * </p>
     * <note>
     * <p>
     * If you change a document version for a State Manager association, Systems Manager immediately runs the
     * association unless you previously specifed the <code>apply-only-at-cron-interval</code> parameter.
     * </p>
     * </note>
     *
     * @param updateDocumentDefaultVersionRequest
     * @return A Java Future containing the result of the UpdateDocumentDefaultVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateDocumentDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDocumentDefaultVersionResponse> updateDocumentDefaultVersion(
            UpdateDocumentDefaultVersionRequest updateDocumentDefaultVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentDefaultVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentDefaultVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentDefaultVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentDefaultVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentDefaultVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentDefaultVersionRequest, UpdateDocumentDefaultVersionResponse>()
                            .withOperationName("UpdateDocumentDefaultVersion")
                            .withMarshaller(new UpdateDocumentDefaultVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDocumentDefaultVersionRequest));
            CompletableFuture<UpdateDocumentDefaultVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information related to approval reviews for a specific version of a change template in Change Manager.
     * </p>
     *
     * @param updateDocumentMetadataRequest
     * @return A Java Future containing the result of the UpdateDocumentMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified SSM document doesn't exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>InvalidDocumentVersionException The document version isn't valid or doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateDocumentMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDocumentMetadataResponse> updateDocumentMetadata(
            UpdateDocumentMetadataRequest updateDocumentMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentMetadataRequest, UpdateDocumentMetadataResponse>()
                            .withOperationName("UpdateDocumentMetadata")
                            .withMarshaller(new UpdateDocumentMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDocumentMetadataRequest));
            CompletableFuture<UpdateDocumentMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing maintenance window. Only specified parameters are modified.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param updateMaintenanceWindowRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMaintenanceWindowResponse> updateMaintenanceWindow(
            UpdateMaintenanceWindowRequest updateMaintenanceWindowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowRequest, UpdateMaintenanceWindowResponse>()
                            .withOperationName("UpdateMaintenanceWindow")
                            .withMarshaller(new UpdateMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMaintenanceWindowRequest));
            CompletableFuture<UpdateMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the target of an existing maintenance window. You can change the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * </li>
     * <li>
     * <p>
     * IDs for an ID target
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags for a Tag target
     * </p>
     * </li>
     * <li>
     * <p>
     * From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource
     * group. For more information, see <a>Target</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If a parameter is null, then the corresponding field isn't modified.
     * </p>
     * </note>
     *
     * @param updateMaintenanceWindowTargetRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateMaintenanceWindowTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMaintenanceWindowTargetResponse> updateMaintenanceWindowTarget(
            UpdateMaintenanceWindowTargetRequest updateMaintenanceWindowTargetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMaintenanceWindowTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindowTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMaintenanceWindowTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMaintenanceWindowTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMaintenanceWindowTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowTargetRequest, UpdateMaintenanceWindowTargetResponse>()
                            .withOperationName("UpdateMaintenanceWindowTarget")
                            .withMarshaller(new UpdateMaintenanceWindowTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMaintenanceWindowTargetRequest));
            CompletableFuture<UpdateMaintenanceWindowTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TaskARN</code>. For example, you can change a <code>RUN_COMMAND</code> task from
     * <code>AWS-RunPowerShellScript</code> to <code>AWS-RunShellScript</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServiceRoleArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TaskInvocationParameters</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Priority</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxConcurrency</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxErrors</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
     * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more
     * information about running tasks that don't specify targets, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the value for a parameter in <code>UpdateMaintenanceWindowTask</code> is null, then the corresponding field
     * isn't modified. If you set <code>Replace</code> to true, then all fields required by the
     * <a>RegisterTaskWithMaintenanceWindow</a> operation are required for this request. Optional fields that aren't
     * specified are set to null.
     * </p>
     * <important>
     * <p>
     * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>,
     * you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values
     * you don't specify again are removed. For example, suppose that when you registered a Run Command task, you
     * specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>,
     * and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different
     * <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code>
     * are removed.
     * </p>
     * </important>
     *
     * @param updateMaintenanceWindowTaskRequest
     * @return A Java Future containing the result of the UpdateMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMaintenanceWindowTaskResponse> updateMaintenanceWindowTask(
            UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMaintenanceWindowTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindowTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMaintenanceWindowTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMaintenanceWindowTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMaintenanceWindowTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowTaskRequest, UpdateMaintenanceWindowTaskResponse>()
                            .withOperationName("UpdateMaintenanceWindowTask")
                            .withMarshaller(new UpdateMaintenanceWindowTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMaintenanceWindowTaskRequest));
            CompletableFuture<UpdateMaintenanceWindowTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or
     * virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more
     * information, see <a>CreateActivation</a>.
     * </p>
     *
     * @param updateManagedInstanceRoleRequest
     * @return A Java Future containing the result of the UpdateManagedInstanceRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateManagedInstanceRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateManagedInstanceRoleResponse> updateManagedInstanceRole(
            UpdateManagedInstanceRoleRequest updateManagedInstanceRoleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateManagedInstanceRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateManagedInstanceRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateManagedInstanceRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateManagedInstanceRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateManagedInstanceRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateManagedInstanceRoleRequest, UpdateManagedInstanceRoleResponse>()
                            .withOperationName("UpdateManagedInstanceRole")
                            .withMarshaller(new UpdateManagedInstanceRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateManagedInstanceRoleRequest));
            CompletableFuture<UpdateManagedInstanceRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param updateOpsItemRequest
     * @return A Java Future containing the result of the UpdateOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemAlreadyExistsException The OpsItem already exists.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOpsItemResponse> updateOpsItem(UpdateOpsItemRequest updateOpsItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpsItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateOpsItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOpsItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOpsItemRequest, UpdateOpsItemResponse>()
                            .withOperationName("UpdateOpsItem")
                            .withMarshaller(new UpdateOpsItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateOpsItemRequest));
            CompletableFuture<UpdateOpsItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
     * </p>
     *
     * @param updateOpsMetadataRequest
     * @return A Java Future containing the result of the UpdateOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object doesn't exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>OpsMetadataKeyLimitExceededException The OpsMetadata object exceeds the maximum number of OpsMetadata
     *         keys that you can assign to an application in Application Manager.</li>
     *         <li>OpsMetadataTooManyUpdatesException The system is processing too many concurrent updates. Wait a few
     *         moments and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOpsMetadataResponse> updateOpsMetadata(UpdateOpsMetadataRequest updateOpsMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpsMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOpsMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOpsMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOpsMetadataRequest, UpdateOpsMetadataResponse>()
                            .withOperationName("UpdateOpsMetadata")
                            .withMarshaller(new UpdateOpsMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateOpsMetadataRequest));
            CompletableFuture<UpdateOpsMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     * </p>
     * <note>
     * <p>
     * For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a>PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param updatePatchBaselineRequest
     * @return A Java Future containing the result of the UpdatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePatchBaselineResponse> updatePatchBaseline(
            UpdatePatchBaselineRequest updatePatchBaselineRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePatchBaseline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePatchBaselineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePatchBaselineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePatchBaselineRequest, UpdatePatchBaselineResponse>()
                            .withOperationName("UpdatePatchBaseline")
                            .withMarshaller(new UpdatePatchBaselineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePatchBaselineRequest));
            CompletableFuture<UpdatePatchBaselineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a resource data sync. After you create a resource data sync for a Region, you can't change the account
     * options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the
     * <code>Include only the current account</code> option, you can't edit that sync later and choose the
     * <code>Include all accounts from my Organizations configuration</code> option. Instead, you must delete the first
     * resource data sync, and create a new one.
     * </p>
     * <note>
     * <p>
     * This API operation only supports a resource data sync that was created with a SyncFromSource
     * <code>SyncType</code>.
     * </p>
     * </note>
     *
     * @param updateResourceDataSyncRequest
     * @return A Java Future containing the result of the UpdateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceDataSyncNotFoundException The specified sync name wasn't found.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>ResourceDataSyncConflictException Another <code>UpdateResourceDataSync</code> request is being
     *         processed. Wait a few minutes and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceDataSyncResponse> updateResourceDataSync(
            UpdateResourceDataSyncRequest updateResourceDataSyncRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceDataSync");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceDataSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceDataSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceDataSyncRequest, UpdateResourceDataSyncResponse>()
                            .withOperationName("UpdateResourceDataSync")
                            .withMarshaller(new UpdateResourceDataSyncRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceDataSyncRequest));
            CompletableFuture<UpdateResourceDataSyncResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of "false". This means the user can't use this feature unless they change the
     * setting to "true" and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>GetServiceSetting</a> API operation to view the current value. Or, use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the Amazon Web Services service team.
     * </p>
     * <p>
     * Update the service setting for the account.
     * </p>
     *
     * @param updateServiceSettingRequest
     *        The request body of the UpdateServiceSetting API operation.
     * @return A Java Future containing the result of the UpdateServiceSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ServiceSettingNotFoundException The specified service setting wasn't found. Either the service name
     *         or the setting hasn't been provisioned by the Amazon Web Services service team.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.UpdateServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateServiceSettingResponse> updateServiceSetting(
            UpdateServiceSettingRequest updateServiceSettingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceSetting");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateServiceSettingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateServiceSettingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateServiceSettingRequest, UpdateServiceSettingResponse>()
                            .withOperationName("UpdateServiceSetting")
                            .withMarshaller(new UpdateServiceSettingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateServiceSettingRequest));
            CompletableFuture<UpdateServiceSettingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SsmException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetNotConnected")
                                .exceptionBuilderSupplier(TargetNotConnectedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException")
                                .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameters")
                                .exceptionBuilderSupplier(InvalidParametersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded")
                                .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException")
                                .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKeyId")
                                .exceptionBuilderSupplier(InvalidKeyIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilter")
                                .exceptionBuilderSupplier(InvalidFilterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist")
                                .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException")
                                .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSchedule")
                                .exceptionBuilderSupplier(InvalidScheduleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                                .exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPluginName")
                                .exceptionBuilderSupplier(InvalidPluginNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException")
                                .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FeatureNotAvailableException")
                                .exceptionBuilderSupplier(FeatureNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextToken")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                                .exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActivationId")
                                .exceptionBuilderSupplier(InvalidActivationIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvocationDoesNotExist")
                                .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException")
                                .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                                .exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                                .exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceId")
                                .exceptionBuilderSupplier(InvalidResourceIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterVersionNotFound")
                                .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceSettingNotFound")
                                .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocument")
                                .exceptionBuilderSupplier(InvalidDocumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentVersion")
                                .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOptionException")
                                .exceptionBuilderSupplier(InvalidOptionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentOperation")
                                .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                                .exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceType")
                                .exceptionBuilderSupplier(InvalidResourceTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                                .exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                                .exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceId")
                                .exceptionBuilderSupplier(InvalidInstanceIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ItemContentMismatchException")
                                .exceptionBuilderSupplier(ItemContentMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException")
                                .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateInstanceId")
                                .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTag")
                                .exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentContent")
                                .exceptionBuilderSupplier(InvalidDocumentContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                                .exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedCalendarException")
                                .exceptionBuilderSupplier(UnsupportedCalendarException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationLimitExceeded")
                                .exceptionBuilderSupplier(AssociationLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                                .exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException")
                                .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException")
                                .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded")
                                .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTarget")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                                .exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException")
                                .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterValue")
                                .exceptionBuilderSupplier(InvalidFilterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded")
                                .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidItemContentException")
                                .exceptionBuilderSupplier(InvalidItemContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsError")
                                .exceptionBuilderSupplier(TooManyTagsErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedParameterType")
                                .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAggregatorException")
                                .exceptionBuilderSupplier(InvalidAggregatorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                                .exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException")
                                .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatiblePolicyException")
                                .exceptionBuilderSupplier(IncompatiblePolicyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUpdate")
                                .exceptionBuilderSupplier(InvalidUpdateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationAlreadyExists")
                                .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateDocumentContent")
                                .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion")
                                .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                                .exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAssociation")
                                .exceptionBuilderSupplier(InvalidAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException")
                                .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetMaps")
                                .exceptionBuilderSupplier(InvalidTargetMapsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentType")
                                .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException")
                                .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResultAttributeException")
                                .exceptionBuilderSupplier(InvalidResultAttributeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                                .exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                                .exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException")
                                .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemNotFoundException")
                                .exceptionBuilderSupplier(OpsItemNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPermissionType")
                                .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem")
                                .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOutputFolder")
                                .exceptionBuilderSupplier(InvalidOutputFolderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                                .exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName")
                                .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNotificationConfig")
                                .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommandId")
                                .exceptionBuilderSupplier(InvalidCommandIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterNotFound")
                                .exceptionBuilderSupplier(ParameterNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                                .exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentPermissionLimit")
                                .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentLimitExceeded")
                                .exceptionBuilderSupplier(DocumentLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                                .exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException")
                                .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException")
                                .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActivation")
                                .exceptionBuilderSupplier(InvalidActivationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyUpdates")
                                .exceptionBuilderSupplier(TooManyUpdatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException")
                                .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentAlreadyExists")
                                .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                                .exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                                .exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAssociationVersion")
                                .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StatusUnchanged")
                                .exceptionBuilderSupplier(StatusUnchangedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetInUseException")
                                .exceptionBuilderSupplier(TargetInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationDoesNotExist")
                                .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedPlatformType")
                                .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded")
                                .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRole")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeletionIdException")
                                .exceptionBuilderSupplier(InvalidDeletionIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedInstances")
                                .exceptionBuilderSupplier(AssociatedInstancesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOutputLocation")
                                .exceptionBuilderSupplier(InvalidOutputLocationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException")
                                .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterLimitExceeded")
                                .exceptionBuilderSupplier(ParameterLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTypeNameException")
                                .exceptionBuilderSupplier(InvalidTypeNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                                .exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DoesNotExistException")
                                .exceptionBuilderSupplier(DoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterOption")
                                .exceptionBuilderSupplier(InvalidFilterOptionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                                .exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException")
                                .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterAlreadyExists")
                                .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterKey")
                                .exceptionBuilderSupplier(InvalidFilterKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerError")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends SsmRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public SsmAsyncWaiter waiter() {
        return SsmAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }
}
