/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.StepExecution;

public class DescribeAutomationStepExecutionsIterable
implements SdkIterable<DescribeAutomationStepExecutionsResponse> {
    private final SsmClient client;
    private final DescribeAutomationStepExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAutomationStepExecutionsIterable(SsmClient client, DescribeAutomationStepExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutomationStepExecutionsResponseFetcher();
    }

    public Iterator<DescribeAutomationStepExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StepExecution> stepExecutions() {
        Function<DescribeAutomationStepExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stepExecutions() != null) {
                return response.stepExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAutomationStepExecutionsResponseFetcher
    implements SyncPageFetcher<DescribeAutomationStepExecutionsResponse> {
        private DescribeAutomationStepExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutomationStepExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAutomationStepExecutionsResponse nextPage(DescribeAutomationStepExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutomationStepExecutionsIterable.this.client.describeAutomationStepExecutions(DescribeAutomationStepExecutionsIterable.this.firstRequest);
            }
            return DescribeAutomationStepExecutionsIterable.this.client.describeAutomationStepExecutions((DescribeAutomationStepExecutionsRequest)((Object)DescribeAutomationStepExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

