/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncSourceRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataSyncSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDataSyncSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(ResourceDataSyncSource.getter(ResourceDataSyncSource::sourceType)).setter(ResourceDataSyncSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<ResourceDataSyncAwsOrganizationsSource> AWS_ORGANIZATIONS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsOrganizationsSource").getter(ResourceDataSyncSource.getter(ResourceDataSyncSource::awsOrganizationsSource)).setter(ResourceDataSyncSource.setter(Builder::awsOrganizationsSource)).constructor(ResourceDataSyncAwsOrganizationsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsOrganizationsSource").build()}).build();
    private static final SdkField<List<String>> SOURCE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceRegions").getter(ResourceDataSyncSource.getter(ResourceDataSyncSource::sourceRegions)).setter(ResourceDataSyncSource.setter(Builder::sourceRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_FUTURE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeFutureRegions").getter(ResourceDataSyncSource.getter(ResourceDataSyncSource::includeFutureRegions)).setter(ResourceDataSyncSource.setter(Builder::includeFutureRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFutureRegions").build()}).build();
    private static final SdkField<Boolean> ENABLE_ALL_OPS_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAllOpsDataSources").getter(ResourceDataSyncSource.getter(ResourceDataSyncSource::enableAllOpsDataSources)).setter(ResourceDataSyncSource.setter(Builder::enableAllOpsDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAllOpsDataSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, AWS_ORGANIZATIONS_SOURCE_FIELD, SOURCE_REGIONS_FIELD, INCLUDE_FUTURE_REGIONS_FIELD, ENABLE_ALL_OPS_DATA_SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final ResourceDataSyncAwsOrganizationsSource awsOrganizationsSource;
    private final List<String> sourceRegions;
    private final Boolean includeFutureRegions;
    private final Boolean enableAllOpsDataSources;

    private ResourceDataSyncSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.awsOrganizationsSource = builder.awsOrganizationsSource;
        this.sourceRegions = builder.sourceRegions;
        this.includeFutureRegions = builder.includeFutureRegions;
        this.enableAllOpsDataSources = builder.enableAllOpsDataSources;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final ResourceDataSyncAwsOrganizationsSource awsOrganizationsSource() {
        return this.awsOrganizationsSource;
    }

    public final boolean hasSourceRegions() {
        return this.sourceRegions != null && !(this.sourceRegions instanceof SdkAutoConstructList);
    }

    public final List<String> sourceRegions() {
        return this.sourceRegions;
    }

    public final Boolean includeFutureRegions() {
        return this.includeFutureRegions;
    }

    public final Boolean enableAllOpsDataSources() {
        return this.enableAllOpsDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsOrganizationsSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceRegions() ? this.sourceRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFutureRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAllOpsDataSources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncSource)) {
            return false;
        }
        ResourceDataSyncSource other = (ResourceDataSyncSource)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.awsOrganizationsSource(), other.awsOrganizationsSource()) && this.hasSourceRegions() == other.hasSourceRegions() && Objects.equals(this.sourceRegions(), other.sourceRegions()) && Objects.equals(this.includeFutureRegions(), other.includeFutureRegions()) && Objects.equals(this.enableAllOpsDataSources(), other.enableAllOpsDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDataSyncSource").add("SourceType", (Object)this.sourceType()).add("AwsOrganizationsSource", (Object)this.awsOrganizationsSource()).add("SourceRegions", this.hasSourceRegions() ? this.sourceRegions() : null).add("IncludeFutureRegions", (Object)this.includeFutureRegions()).add("EnableAllOpsDataSources", (Object)this.enableAllOpsDataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "AwsOrganizationsSource": {
                return Optional.ofNullable(clazz.cast(this.awsOrganizationsSource()));
            }
            case "SourceRegions": {
                return Optional.ofNullable(clazz.cast(this.sourceRegions()));
            }
            case "IncludeFutureRegions": {
                return Optional.ofNullable(clazz.cast(this.includeFutureRegions()));
            }
            case "EnableAllOpsDataSources": {
                return Optional.ofNullable(clazz.cast(this.enableAllOpsDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncSource, T> g) {
        return obj -> g.apply((ResourceDataSyncSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private ResourceDataSyncAwsOrganizationsSource awsOrganizationsSource;
        private List<String> sourceRegions = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeFutureRegions;
        private Boolean enableAllOpsDataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncSource model) {
            this.sourceType(model.sourceType);
            this.awsOrganizationsSource(model.awsOrganizationsSource);
            this.sourceRegions(model.sourceRegions);
            this.includeFutureRegions(model.includeFutureRegions);
            this.enableAllOpsDataSources(model.enableAllOpsDataSources);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final ResourceDataSyncAwsOrganizationsSource.Builder getAwsOrganizationsSource() {
            return this.awsOrganizationsSource != null ? this.awsOrganizationsSource.toBuilder() : null;
        }

        @Override
        public final Builder awsOrganizationsSource(ResourceDataSyncAwsOrganizationsSource awsOrganizationsSource) {
            this.awsOrganizationsSource = awsOrganizationsSource;
            return this;
        }

        public final void setAwsOrganizationsSource(ResourceDataSyncAwsOrganizationsSource.BuilderImpl awsOrganizationsSource) {
            this.awsOrganizationsSource = awsOrganizationsSource != null ? awsOrganizationsSource.build() : null;
        }

        public final Collection<String> getSourceRegions() {
            if (this.sourceRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceRegions;
        }

        @Override
        public final Builder sourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = ResourceDataSyncSourceRegionListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(String ... sourceRegions) {
            this.sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        public final void setSourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = ResourceDataSyncSourceRegionListCopier.copy(sourceRegions);
        }

        public final Boolean getIncludeFutureRegions() {
            return this.includeFutureRegions;
        }

        @Override
        public final Builder includeFutureRegions(Boolean includeFutureRegions) {
            this.includeFutureRegions = includeFutureRegions;
            return this;
        }

        public final void setIncludeFutureRegions(Boolean includeFutureRegions) {
            this.includeFutureRegions = includeFutureRegions;
        }

        public final Boolean getEnableAllOpsDataSources() {
            return this.enableAllOpsDataSources;
        }

        @Override
        public final Builder enableAllOpsDataSources(Boolean enableAllOpsDataSources) {
            this.enableAllOpsDataSources = enableAllOpsDataSources;
            return this;
        }

        public final void setEnableAllOpsDataSources(Boolean enableAllOpsDataSources) {
            this.enableAllOpsDataSources = enableAllOpsDataSources;
        }

        public ResourceDataSyncSource build() {
            return new ResourceDataSyncSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDataSyncSource> {
        public Builder sourceType(String var1);

        public Builder awsOrganizationsSource(ResourceDataSyncAwsOrganizationsSource var1);

        default public Builder awsOrganizationsSource(Consumer<ResourceDataSyncAwsOrganizationsSource.Builder> awsOrganizationsSource) {
            return this.awsOrganizationsSource((ResourceDataSyncAwsOrganizationsSource)((ResourceDataSyncAwsOrganizationsSource.Builder)ResourceDataSyncAwsOrganizationsSource.builder().applyMutation(awsOrganizationsSource)).build());
        }

        public Builder sourceRegions(Collection<String> var1);

        public Builder sourceRegions(String ... var1);

        public Builder includeFutureRegions(Boolean var1);

        public Builder enableAllOpsDataSources(Boolean var1);
    }
}

