/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of Regions and accounts targeted by the current Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetLocation implements SdkPojo, Serializable, ToCopyableBuilder<TargetLocation.Builder, TargetLocation> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(TargetLocation::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(TargetLocation::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_CONCURRENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationMaxConcurrency")
            .getter(getter(TargetLocation::targetLocationMaxConcurrency))
            .setter(setter(Builder::targetLocationMaxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxConcurrency")
                    .build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationMaxErrors").getter(getter(TargetLocation::targetLocationMaxErrors))
            .setter(setter(Builder::targetLocationMaxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxErrors").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleName").getter(getter(TargetLocation::executionRoleName))
            .setter(setter(Builder::executionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, REGIONS_FIELD,
            TARGET_LOCATION_MAX_CONCURRENCY_FIELD, TARGET_LOCATION_MAX_ERRORS_FIELD, EXECUTION_ROLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final List<String> regions;

    private final String targetLocationMaxConcurrency;

    private final String targetLocationMaxErrors;

    private final String executionRoleName;

    private TargetLocation(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.targetLocationMaxConcurrency = builder.targetLocationMaxConcurrency;
        this.targetLocationMaxErrors = builder.targetLocationMaxErrors;
        this.executionRoleName = builder.executionRoleName;
    }

    /**
     * Returns true if the Accounts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accounts targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The accounts targeted by the current Automation execution.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * Returns true if the Regions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Regions targeted by the current Automation execution.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The maximum number of Regions and accounts allowed to run the Automation concurrently.
     * </p>
     * 
     * @return The maximum number of Regions and accounts allowed to run the Automation concurrently.
     */
    public final String targetLocationMaxConcurrency() {
        return targetLocationMaxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed before the system stops queueing additional Automation executions for the
     * currently running Automation.
     * </p>
     * 
     * @return The maximum number of errors allowed before the system stops queueing additional Automation executions
     *         for the currently running Automation.
     */
    public final String targetLocationMaxErrors() {
        return targetLocationMaxErrors;
    }

    /**
     * <p>
     * The Automation execution role used by the currently running Automation. If not specified, the default value is
     * <code>AWS-SystemsManager-AutomationExecutionRole</code>.
     * </p>
     * 
     * @return The Automation execution role used by the currently running Automation. If not specified, the default
     *         value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
     */
    public final String executionRoleName() {
        return executionRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetLocation)) {
            return false;
        }
        TargetLocation other = (TargetLocation) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(targetLocationMaxConcurrency(), other.targetLocationMaxConcurrency())
                && Objects.equals(targetLocationMaxErrors(), other.targetLocationMaxErrors())
                && Objects.equals(executionRoleName(), other.executionRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetLocation").add("Accounts", hasAccounts() ? accounts() : null)
                .add("Regions", hasRegions() ? regions() : null)
                .add("TargetLocationMaxConcurrency", targetLocationMaxConcurrency())
                .add("TargetLocationMaxErrors", targetLocationMaxErrors()).add("ExecutionRoleName", executionRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "TargetLocationMaxConcurrency":
            return Optional.ofNullable(clazz.cast(targetLocationMaxConcurrency()));
        case "TargetLocationMaxErrors":
            return Optional.ofNullable(clazz.cast(targetLocationMaxErrors()));
        case "ExecutionRoleName":
            return Optional.ofNullable(clazz.cast(executionRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetLocation, T> g) {
        return obj -> g.apply((TargetLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetLocation> {
        /**
         * <p>
         * The accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * The Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The maximum number of Regions and accounts allowed to run the Automation concurrently.
         * </p>
         * 
         * @param targetLocationMaxConcurrency
         *        The maximum number of Regions and accounts allowed to run the Automation concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed before the system stops queueing additional Automation executions for
         * the currently running Automation.
         * </p>
         * 
         * @param targetLocationMaxErrors
         *        The maximum number of errors allowed before the system stops queueing additional Automation executions
         *        for the currently running Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxErrors(String targetLocationMaxErrors);

        /**
         * <p>
         * The Automation execution role used by the currently running Automation. If not specified, the default value
         * is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
         * </p>
         * 
         * @param executionRoleName
         *        The Automation execution role used by the currently running Automation. If not specified, the default
         *        value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleName(String executionRoleName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String targetLocationMaxConcurrency;

        private String targetLocationMaxErrors;

        private String executionRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetLocation model) {
            accounts(model.accounts);
            regions(model.regions);
            targetLocationMaxConcurrency(model.targetLocationMaxConcurrency);
            targetLocationMaxErrors(model.targetLocationMaxErrors);
            executionRoleName(model.executionRoleName);
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        public final String getTargetLocationMaxConcurrency() {
            return targetLocationMaxConcurrency;
        }

        @Override
        public final Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
            return this;
        }

        public final void setTargetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
        }

        public final String getTargetLocationMaxErrors() {
            return targetLocationMaxErrors;
        }

        @Override
        public final Builder targetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
            return this;
        }

        public final void setTargetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
        }

        public final String getExecutionRoleName() {
            return executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public TargetLocation build() {
            return new TargetLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
