/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A count of OpsItems.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemSummary implements SdkPojo, Serializable, ToCopyableBuilder<OpsItemSummary.Builder, OpsItemSummary> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(OpsItemSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(OpsItemSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(OpsItemSummary::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(OpsItemSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(OpsItemSummary::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(OpsItemSummary::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OpsItemSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(OpsItemSummary::opsItemId)).setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(OpsItemSummary::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField
            .<Map<String, OpsItemDataValue>> builder(MarshallingType.MAP)
            .memberName("OperationalData")
            .getter(getter(OpsItemSummary::operationalData))
            .setter(setter(Builder::operationalData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<OpsItemDataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsItemDataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(OpsItemSummary::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(OpsItemSummary::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> OPS_ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemType").getter(getter(OpsItemSummary::opsItemType)).setter(setter(Builder::opsItemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemType").build()).build();

    private static final SdkField<Instant> ACTUAL_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActualStartTime").getter(getter(OpsItemSummary::actualStartTime))
            .setter(setter(Builder::actualStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualStartTime").build()).build();

    private static final SdkField<Instant> ACTUAL_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActualEndTime").getter(getter(OpsItemSummary::actualEndTime)).setter(setter(Builder::actualEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEndTime").build()).build();

    private static final SdkField<Instant> PLANNED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PlannedStartTime").getter(getter(OpsItemSummary::plannedStartTime))
            .setter(setter(Builder::plannedStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedStartTime").build()).build();

    private static final SdkField<Instant> PLANNED_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PlannedEndTime").getter(getter(OpsItemSummary::plannedEndTime)).setter(setter(Builder::plannedEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            CREATED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, PRIORITY_FIELD, SOURCE_FIELD, STATUS_FIELD,
            OPS_ITEM_ID_FIELD, TITLE_FIELD, OPERATIONAL_DATA_FIELD, CATEGORY_FIELD, SEVERITY_FIELD, OPS_ITEM_TYPE_FIELD,
            ACTUAL_START_TIME_FIELD, ACTUAL_END_TIME_FIELD, PLANNED_START_TIME_FIELD, PLANNED_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createdBy;

    private final Instant createdTime;

    private final String lastModifiedBy;

    private final Instant lastModifiedTime;

    private final Integer priority;

    private final String source;

    private final String status;

    private final String opsItemId;

    private final String title;

    private final Map<String, OpsItemDataValue> operationalData;

    private final String category;

    private final String severity;

    private final String opsItemType;

    private final Instant actualStartTime;

    private final Instant actualEndTime;

    private final Instant plannedStartTime;

    private final Instant plannedEndTime;

    private OpsItemSummary(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.priority = builder.priority;
        this.source = builder.source;
        this.status = builder.status;
        this.opsItemId = builder.opsItemId;
        this.title = builder.title;
        this.operationalData = builder.operationalData;
        this.category = builder.category;
        this.severity = builder.severity;
        this.opsItemType = builder.opsItemType;
        this.actualStartTime = builder.actualStartTime;
        this.actualEndTime = builder.actualEndTime;
        this.plannedStartTime = builder.plannedStartTime;
        this.plannedEndTime = builder.plannedEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the OpsItem was created.
     * </p>
     * 
     * @return The date and time the OpsItem was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time the OpsItem was last updated.
     * </p>
     * 
     * @return The date and time the OpsItem was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The importance of this OpsItem in relation to other OpsItems in the system.
     * </p>
     * 
     * @return The importance of this OpsItem in relation to other OpsItems in the system.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The impacted Amazon Web Services resource.
     * </p>
     * 
     * @return The impacted Amazon Web Services resource.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OpsItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
     * @see OpsItemStatus
     */
    public final OpsItemStatus status() {
        return OpsItemStatus.fromValue(status);
    }

    /**
     * <p>
     * The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OpsItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
     * @see OpsItemStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the OpsItem.
     * </p>
     * 
     * @return The ID of the OpsItem.
     */
    public final String opsItemId() {
        return opsItemId;
    }

    /**
     * <p>
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     * </p>
     * 
     * @return A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    public final String title() {
        return title;
    }

    /**
     * Returns true if the OperationalData property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOperationalData() {
        return operationalData != null && !(operationalData instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Operational data is custom data that provides useful reference details about the OpsItem.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperationalData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Operational data is custom data that provides useful reference details about the OpsItem.
     */
    public final Map<String, OpsItemDataValue> operationalData() {
        return operationalData;
    }

    /**
     * <p>
     * A list of OpsItems by category.
     * </p>
     * 
     * @return A list of OpsItems by category.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * A list of OpsItems by severity.
     * </p>
     * 
     * @return A list of OpsItems by severity.
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and
     * <code>/aws/issue</code>.
     * </p>
     * 
     * @return The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and
     *         <code>/aws/issue</code>.
     */
    public final String opsItemType() {
        return opsItemType;
    }

    /**
     * <p>
     * The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>
     * .
     * </p>
     * 
     * @return The time a runbook workflow started. Currently reported only for the OpsItem type
     *         <code>/aws/changerequest</code>.
     */
    public final Instant actualStartTime() {
        return actualStartTime;
    }

    /**
     * <p>
     * The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.
     * </p>
     * 
     * @return The time a runbook workflow ended. Currently reported only for the OpsItem type
     *         <code>/aws/changerequest</code>.
     */
    public final Instant actualEndTime() {
        return actualEndTime;
    }

    /**
     * <p>
     * The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem
     * type <code>/aws/changerequest</code>.
     * </p>
     * 
     * @return The time specified in a change request for a runbook workflow to start. Currently supported only for the
     *         OpsItem type <code>/aws/changerequest</code>.
     */
    public final Instant plannedStartTime() {
        return plannedStartTime;
    }

    /**
     * <p>
     * The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem
     * type <code>/aws/changerequest</code>.
     * </p>
     * 
     * @return The time specified in a change request for a runbook workflow to end. Currently supported only for the
     *         OpsItem type <code>/aws/changerequest</code>.
     */
    public final Instant plannedEndTime() {
        return plannedEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationalData() ? operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemType());
        hashCode = 31 * hashCode + Objects.hashCode(actualStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(actualEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(plannedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(plannedEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemSummary)) {
            return false;
        }
        OpsItemSummary other = (OpsItemSummary) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(priority(), other.priority())
                && Objects.equals(source(), other.source()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(opsItemId(), other.opsItemId()) && Objects.equals(title(), other.title())
                && hasOperationalData() == other.hasOperationalData()
                && Objects.equals(operationalData(), other.operationalData()) && Objects.equals(category(), other.category())
                && Objects.equals(severity(), other.severity()) && Objects.equals(opsItemType(), other.opsItemType())
                && Objects.equals(actualStartTime(), other.actualStartTime())
                && Objects.equals(actualEndTime(), other.actualEndTime())
                && Objects.equals(plannedStartTime(), other.plannedStartTime())
                && Objects.equals(plannedEndTime(), other.plannedEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpsItemSummary").add("CreatedBy", createdBy()).add("CreatedTime", createdTime())
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedTime", lastModifiedTime()).add("Priority", priority())
                .add("Source", source()).add("Status", statusAsString()).add("OpsItemId", opsItemId()).add("Title", title())
                .add("OperationalData", hasOperationalData() ? operationalData() : null).add("Category", category())
                .add("Severity", severity()).add("OpsItemType", opsItemType()).add("ActualStartTime", actualStartTime())
                .add("ActualEndTime", actualEndTime()).add("PlannedStartTime", plannedStartTime())
                .add("PlannedEndTime", plannedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "OperationalData":
            return Optional.ofNullable(clazz.cast(operationalData()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "OpsItemType":
            return Optional.ofNullable(clazz.cast(opsItemType()));
        case "ActualStartTime":
            return Optional.ofNullable(clazz.cast(actualStartTime()));
        case "ActualEndTime":
            return Optional.ofNullable(clazz.cast(actualEndTime()));
        case "PlannedStartTime":
            return Optional.ofNullable(clazz.cast(plannedStartTime()));
        case "PlannedEndTime":
            return Optional.ofNullable(clazz.cast(plannedEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemSummary, T> g) {
        return obj -> g.apply((OpsItemSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the OpsItem was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the OpsItem was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time the OpsItem was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the OpsItem was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The importance of this OpsItem in relation to other OpsItems in the system.
         * </p>
         * 
         * @param priority
         *        The importance of this OpsItem in relation to other OpsItems in the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The impacted Amazon Web Services resource.
         * </p>
         * 
         * @param source
         *        The impacted Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
         * </p>
         * 
         * @param status
         *        The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
         *        <code>Resolved</code>.
         * @see OpsItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpsItemStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.
         * </p>
         * 
         * @param status
         *        The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
         *        <code>Resolved</code>.
         * @see OpsItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpsItemStatus
         */
        Builder status(OpsItemStatus status);

        /**
         * <p>
         * The ID of the OpsItem.
         * </p>
         * 
         * @param opsItemId
         *        The ID of the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         * </p>
         * 
         * @param title
         *        A short heading that describes the nature of the OpsItem and the impacted resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Operational data is custom data that provides useful reference details about the OpsItem.
         * </p>
         * 
         * @param operationalData
         *        Operational data is custom data that provides useful reference details about the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationalData(Map<String, OpsItemDataValue> operationalData);

        /**
         * <p>
         * A list of OpsItems by category.
         * </p>
         * 
         * @param category
         *        A list of OpsItems by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * A list of OpsItems by severity.
         * </p>
         * 
         * @param severity
         *        A list of OpsItems by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and
         * <code>/aws/issue</code>.
         * </p>
         * 
         * @param opsItemType
         *        The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and
         *        <code>/aws/issue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemType(String opsItemType);

        /**
         * <p>
         * The time a runbook workflow started. Currently reported only for the OpsItem type
         * <code>/aws/changerequest</code>.
         * </p>
         * 
         * @param actualStartTime
         *        The time a runbook workflow started. Currently reported only for the OpsItem type
         *        <code>/aws/changerequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualStartTime(Instant actualStartTime);

        /**
         * <p>
         * The time a runbook workflow ended. Currently reported only for the OpsItem type
         * <code>/aws/changerequest</code>.
         * </p>
         * 
         * @param actualEndTime
         *        The time a runbook workflow ended. Currently reported only for the OpsItem type
         *        <code>/aws/changerequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualEndTime(Instant actualEndTime);

        /**
         * <p>
         * The time specified in a change request for a runbook workflow to start. Currently supported only for the
         * OpsItem type <code>/aws/changerequest</code>.
         * </p>
         * 
         * @param plannedStartTime
         *        The time specified in a change request for a runbook workflow to start. Currently supported only for
         *        the OpsItem type <code>/aws/changerequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plannedStartTime(Instant plannedStartTime);

        /**
         * <p>
         * The time specified in a change request for a runbook workflow to end. Currently supported only for the
         * OpsItem type <code>/aws/changerequest</code>.
         * </p>
         * 
         * @param plannedEndTime
         *        The time specified in a change request for a runbook workflow to end. Currently supported only for the
         *        OpsItem type <code>/aws/changerequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plannedEndTime(Instant plannedEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String createdBy;

        private Instant createdTime;

        private String lastModifiedBy;

        private Instant lastModifiedTime;

        private Integer priority;

        private String source;

        private String status;

        private String opsItemId;

        private String title;

        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();

        private String category;

        private String severity;

        private String opsItemType;

        private Instant actualStartTime;

        private Instant actualEndTime;

        private Instant plannedStartTime;

        private Instant plannedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemSummary model) {
            createdBy(model.createdBy);
            createdTime(model.createdTime);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedTime(model.lastModifiedTime);
            priority(model.priority);
            source(model.source);
            status(model.status);
            opsItemId(model.opsItemId);
            title(model.title);
            operationalData(model.operationalData);
            category(model.category);
            severity(model.severity);
            opsItemType(model.opsItemType);
            actualStartTime(model.actualStartTime);
            actualEndTime(model.actualEndTime);
            plannedStartTime(model.plannedStartTime);
            plannedEndTime(model.plannedEndTime);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OpsItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            Map<String, OpsItemDataValue.Builder> result = OpsItemOperationalDataCopier.copyToBuilder(this.operationalData);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getOpsItemType() {
            return opsItemType;
        }

        @Override
        public final Builder opsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
            return this;
        }

        public final void setOpsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
        }

        public final Instant getActualStartTime() {
            return actualStartTime;
        }

        @Override
        public final Builder actualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
            return this;
        }

        public final void setActualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
        }

        public final Instant getActualEndTime() {
            return actualEndTime;
        }

        @Override
        public final Builder actualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
            return this;
        }

        public final void setActualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
        }

        public final Instant getPlannedStartTime() {
            return plannedStartTime;
        }

        @Override
        public final Builder plannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
            return this;
        }

        public final void setPlannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
        }

        public final Instant getPlannedEndTime() {
            return plannedEndTime;
        }

        @Override
        public final Builder plannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
            return this;
        }

        public final void setPlannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
        }

        @Override
        public OpsItemSummary build() {
            return new OpsItemSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
