/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancePatchesRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeInstancePatchesRequest.Builder, DescribeInstancePatchesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DescribeInstancePatchesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<List<PatchOrchestratorFilter>> FILTERS_FIELD = SdkField
            .<List<PatchOrchestratorFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeInstancePatchesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchOrchestratorFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchOrchestratorFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstancePatchesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeInstancePatchesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String instanceId;

    private final List<PatchOrchestratorFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the instance whose patch state information should be retrieved.
     * </p>
     * 
     * @return The ID of the instance whose patch state information should be retrieved.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each element in the array is a structure containing a key-value pair.
     * </p>
     * <p>
     * Supported keys for <code>DescribeInstancePatches</code>include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Classification</code> </b>
     * </p>
     * <p>
     * Sample values: <code>Security</code> | <code>SecurityUpdates</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>KBId</code> </b>
     * </p>
     * <p>
     * Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Severity</code> </b>
     * </p>
     * <p>
     * Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>State</code> </b>
     * </p>
     * <p>
     * Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Each element in the array is a structure containing a key-value pair.</p>
     *         <p>
     *         Supported keys for <code>DescribeInstancePatches</code>include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>Classification</code> </b>
     *         </p>
     *         <p>
     *         Sample values: <code>Security</code> | <code>SecurityUpdates</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>KBId</code> </b>
     *         </p>
     *         <p>
     *         Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Severity</code> </b>
     *         </p>
     *         <p>
     *         Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>State</code> </b>
     *         </p>
     *         <p>
     *         Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code>
     *         </p>
     *         </li>
     */
    public final List<PatchOrchestratorFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesRequest)) {
            return false;
        }
        DescribeInstancePatchesRequest other = (DescribeInstancePatchesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancePatchesRequest").add("InstanceId", instanceId())
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePatchesRequest, T> g) {
        return obj -> g.apply((DescribeInstancePatchesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancePatchesRequest> {
        /**
         * <p>
         * The ID of the instance whose patch state information should be retrieved.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance whose patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Each element in the array is a structure containing a key-value pair.
         * </p>
         * <p>
         * Supported keys for <code>DescribeInstancePatches</code>include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>Classification</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Security</code> | <code>SecurityUpdates</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>KBId</code> </b>
         * </p>
         * <p>
         * Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Severity</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>State</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Each element in the array is a structure containing a key-value pair.</p>
         *        <p>
         *        Supported keys for <code>DescribeInstancePatches</code>include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>Classification</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Security</code> | <code>SecurityUpdates</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>KBId</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Severity</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>State</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Installed</code> | <code>InstalledOther</code> |
         *        <code>InstalledPendingReboot</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PatchOrchestratorFilter> filters);

        /**
         * <p>
         * Each element in the array is a structure containing a key-value pair.
         * </p>
         * <p>
         * Supported keys for <code>DescribeInstancePatches</code>include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>Classification</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Security</code> | <code>SecurityUpdates</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>KBId</code> </b>
         * </p>
         * <p>
         * Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Severity</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>State</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Each element in the array is a structure containing a key-value pair.</p>
         *        <p>
         *        Supported keys for <code>DescribeInstancePatches</code>include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>Classification</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Security</code> | <code>SecurityUpdates</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>KBId</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Severity</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>State</code> </b>
         *        </p>
         *        <p>
         *        Sample values: <code>Installed</code> | <code>InstalledOther</code> |
         *        <code>InstalledPendingReboot</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PatchOrchestratorFilter... filters);

        /**
         * <p>
         * Each element in the array is a structure containing a key-value pair.
         * </p>
         * <p>
         * Supported keys for <code>DescribeInstancePatches</code>include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>Classification</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Security</code> | <code>SecurityUpdates</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>KBId</code> </b>
         * </p>
         * <p>
         * Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Severity</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>State</code> </b>
         * </p>
         * <p>
         * Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<PatchOrchestratorFilter>.Builder} avoiding
         * the need to create one manually via {@link List<PatchOrchestratorFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOrchestratorFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<PatchOrchestratorFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<PatchOrchestratorFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<PatchOrchestratorFilter>)
         */
        Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<PatchOrchestratorFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesRequest model) {
            super(model);
            instanceId(model.instanceId);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final List<PatchOrchestratorFilter.Builder> getFilters() {
            List<PatchOrchestratorFilter.Builder> result = PatchOrchestratorFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<PatchOrchestratorFilter> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PatchOrchestratorFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> PatchOrchestratorFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PatchOrchestratorFilter.BuilderImpl> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePatchesRequest build() {
            return new DescribeInstancePatchesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
