/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for a specific list of instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceInformation.Builder, InstanceInformation> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceInformation::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> PING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PingStatus").getter(getter(InstanceInformation::pingStatusAsString)).setter(setter(Builder::pingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingStatus").build()).build();

    private static final SdkField<Instant> LAST_PING_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastPingDateTime").getter(getter(InstanceInformation::lastPingDateTime))
            .setter(setter(Builder::lastPingDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPingDateTime").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(InstanceInformation::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLatestVersion").getter(getter(InstanceInformation::isLatestVersion))
            .setter(setter(Builder::isLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()).build();

    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformType").getter(getter(InstanceInformation::platformTypeAsString))
            .setter(setter(Builder::platformType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()).build();

    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(InstanceInformation::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(InstanceInformation::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationId").getter(getter(InstanceInformation::activationId)).setter(setter(Builder::activationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRole").getter(getter(InstanceInformation::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Instant> REGISTRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegistrationDate").getter(getter(InstanceInformation::registrationDate))
            .setter(setter(Builder::registrationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationDate").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(InstanceInformation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InstanceInformation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPAddress").getter(getter(InstanceInformation::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerName").getter(getter(InstanceInformation::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus").getter(getter(InstanceInformation::associationStatus))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final SdkField<Instant> LAST_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAssociationExecutionDate")
            .getter(getter(InstanceInformation::lastAssociationExecutionDate))
            .setter(setter(Builder::lastAssociationExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAssociationExecutionDate")
                    .build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulAssociationExecutionDate")
            .getter(getter(InstanceInformation::lastSuccessfulAssociationExecutionDate))
            .setter(setter(Builder::lastSuccessfulAssociationExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LastSuccessfulAssociationExecutionDate").build()).build();

    private static final SdkField<InstanceAggregatedAssociationOverview> ASSOCIATION_OVERVIEW_FIELD = SdkField
            .<InstanceAggregatedAssociationOverview> builder(MarshallingType.SDK_POJO).memberName("AssociationOverview")
            .getter(getter(InstanceInformation::associationOverview)).setter(setter(Builder::associationOverview))
            .constructor(InstanceAggregatedAssociationOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationOverview").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            PING_STATUS_FIELD, LAST_PING_DATE_TIME_FIELD, AGENT_VERSION_FIELD, IS_LATEST_VERSION_FIELD, PLATFORM_TYPE_FIELD,
            PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, ACTIVATION_ID_FIELD, IAM_ROLE_FIELD, REGISTRATION_DATE_FIELD,
            RESOURCE_TYPE_FIELD, NAME_FIELD, IP_ADDRESS_FIELD, COMPUTER_NAME_FIELD, ASSOCIATION_STATUS_FIELD,
            LAST_ASSOCIATION_EXECUTION_DATE_FIELD, LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD, ASSOCIATION_OVERVIEW_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String pingStatus;

    private final Instant lastPingDateTime;

    private final String agentVersion;

    private final Boolean isLatestVersion;

    private final String platformType;

    private final String platformName;

    private final String platformVersion;

    private final String activationId;

    private final String iamRole;

    private final Instant registrationDate;

    private final String resourceType;

    private final String name;

    private final String ipAddress;

    private final String computerName;

    private final String associationStatus;

    private final Instant lastAssociationExecutionDate;

    private final Instant lastSuccessfulAssociationExecutionDate;

    private final InstanceAggregatedAssociationOverview associationOverview;

    private InstanceInformation(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.name = builder.name;
        this.ipAddress = builder.ipAddress;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Connection status of SSM Agent.
     * </p>
     * <note>
     * <p>
     * The status <code>Inactive</code> has been deprecated and is no longer in use.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusAsString}.
     * </p>
     * 
     * @return Connection status of SSM Agent. </p> <note>
     *         <p>
     *         The status <code>Inactive</code> has been deprecated and is no longer in use.
     *         </p>
     * @see PingStatus
     */
    public final PingStatus pingStatus() {
        return PingStatus.fromValue(pingStatus);
    }

    /**
     * <p>
     * Connection status of SSM Agent.
     * </p>
     * <note>
     * <p>
     * The status <code>Inactive</code> has been deprecated and is no longer in use.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusAsString}.
     * </p>
     * 
     * @return Connection status of SSM Agent. </p> <note>
     *         <p>
     *         The status <code>Inactive</code> has been deprecated and is no longer in use.
     *         </p>
     * @see PingStatus
     */
    public final String pingStatusAsString() {
        return pingStatus;
    }

    /**
     * <p>
     * The date and time when the agent last pinged the Systems Manager service.
     * </p>
     * 
     * @return The date and time when the agent last pinged the Systems Manager service.
     */
    public final Instant lastPingDateTime() {
        return lastPingDateTime;
    }

    /**
     * <p>
     * The version of SSM Agent running on your Linux instance.
     * </p>
     * 
     * @return The version of SSM Agent running on your Linux instance.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * Indicates whether the latest version of SSM Agent is running on your Linux Managed Instance. This field doesn't
     * indicate whether or not the latest version is installed on Windows managed instances, because some older versions
     * of Windows Server use the EC2Config service to process Systems Manager requests.
     * </p>
     * 
     * @return Indicates whether the latest version of SSM Agent is running on your Linux Managed Instance. This field
     *         doesn't indicate whether or not the latest version is installed on Windows managed instances, because
     *         some older versions of Windows Server use the EC2Config service to process Systems Manager requests.
     */
    public final Boolean isLatestVersion() {
        return isLatestVersion;
    }

    /**
     * <p>
     * The operating system platform type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type.
     * @see PlatformType
     */
    public final PlatformType platformType() {
        return PlatformType.fromValue(platformType);
    }

    /**
     * <p>
     * The operating system platform type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type.
     * @see PlatformType
     */
    public final String platformTypeAsString() {
        return platformType;
    }

    /**
     * <p>
     * The name of the operating system platform running on your instance.
     * </p>
     * 
     * @return The name of the operating system platform running on your instance.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the OS platform running on your instance.
     * </p>
     * 
     * @return The version of the OS platform running on your instance.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was
     * registered.
     * </p>
     * 
     * @return The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM)
     *         was registered.
     */
    public final String activationId() {
        return activationId;
    }

    /**
     * <p>
     * The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed instance. This
     * call doesn't return the IAM role for Amazon Elastic Compute Cloud (Amazon EC2) instances. To retrieve the IAM
     * role for an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> operation. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in
     * the <i>Amazon EC2 API Reference</i> or <a
     * href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the <i>Amazon
     * Web Services CLI Command Reference</i>.
     * </p>
     * 
     * @return The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed
     *         instance. This call doesn't return the IAM role for Amazon Elastic Compute Cloud (Amazon EC2) instances.
     *         To retrieve the IAM role for an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code>
     *         operation. For information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
     *         >DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a
     *         href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the
     *         <i>Amazon Web Services CLI Command Reference</i>.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The date the server or VM was registered with Amazon Web Services as a managed instance.
     * </p>
     * 
     * @return The date the server or VM was registered with Amazon Web Services as a managed instance.
     */
    public final Instant registrationDate() {
        return registrationDate;
    }

    /**
     * <p>
     * The type of instance. Instances are either EC2 instances or managed instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of instance. Instances are either EC2 instances or managed instances.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of instance. Instances are either EC2 instances or managed instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of instance. Instances are either EC2 instances or managed instances.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The name assigned to an on-premises server or virtual machine (VM) when it is activated as a Systems Manager
     * managed instance. The name is specified as the <code>DefaultInstanceName</code> property using the
     * <a>CreateActivation</a> command. It is applied to the managed instance by specifying the Activation Code and
     * Activation ID when you install SSM Agent on the instance, as explained in <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install SSM
     * Agent for a hybrid environment (Linux)</a> and <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install SSM
     * Agent for a hybrid environment (Windows)</a>. To retrieve the Name tag of an EC2 instance, use the Amazon EC2
     * <code>DescribeInstances</code> operation. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in
     * the <i>Amazon EC2 API Reference</i> or <a
     * href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the <i>Amazon
     * Web Services CLI Command Reference</i>.
     * </p>
     * 
     * @return The name assigned to an on-premises server or virtual machine (VM) when it is activated as a Systems
     *         Manager managed instance. The name is specified as the <code>DefaultInstanceName</code> property using
     *         the <a>CreateActivation</a> command. It is applied to the managed instance by specifying the Activation
     *         Code and Activation ID when you install SSM Agent on the instance, as explained in <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html"
     *         >Install SSM Agent for a hybrid environment (Linux)</a> and <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html"
     *         >Install SSM Agent for a hybrid environment (Windows)</a>. To retrieve the Name tag of an EC2 instance,
     *         use the Amazon EC2 <code>DescribeInstances</code> operation. For information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
     *         >DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a
     *         href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the
     *         <i>Amazon Web Services CLI Command Reference</i>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The IP address of the managed instance.
     * </p>
     * 
     * @return The IP address of the managed instance.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The fully qualified host name of the managed instance.
     * </p>
     * 
     * @return The fully qualified host name of the managed instance.
     */
    public final String computerName() {
        return computerName;
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * 
     * @return The status of the association.
     */
    public final String associationStatus() {
        return associationStatus;
    }

    /**
     * <p>
     * The date the association was last run.
     * </p>
     * 
     * @return The date the association was last run.
     */
    public final Instant lastAssociationExecutionDate() {
        return lastAssociationExecutionDate;
    }

    /**
     * <p>
     * The last date the association was successfully run.
     * </p>
     * 
     * @return The last date the association was successfully run.
     */
    public final Instant lastSuccessfulAssociationExecutionDate() {
        return lastSuccessfulAssociationExecutionDate;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public final InstanceAggregatedAssociationOverview associationOverview() {
        return associationOverview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(pingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastPingDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(associationOverview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformation)) {
            return false;
        }
        InstanceInformation other = (InstanceInformation) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(pingStatusAsString(), other.pingStatusAsString())
                && Objects.equals(lastPingDateTime(), other.lastPingDateTime())
                && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(isLatestVersion(), other.isLatestVersion())
                && Objects.equals(platformTypeAsString(), other.platformTypeAsString())
                && Objects.equals(platformName(), other.platformName())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(activationId(), other.activationId()) && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(registrationDate(), other.registrationDate())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(computerName(), other.computerName())
                && Objects.equals(associationStatus(), other.associationStatus())
                && Objects.equals(lastAssociationExecutionDate(), other.lastAssociationExecutionDate())
                && Objects.equals(lastSuccessfulAssociationExecutionDate(), other.lastSuccessfulAssociationExecutionDate())
                && Objects.equals(associationOverview(), other.associationOverview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceInformation").add("InstanceId", instanceId()).add("PingStatus", pingStatusAsString())
                .add("LastPingDateTime", lastPingDateTime()).add("AgentVersion", agentVersion())
                .add("IsLatestVersion", isLatestVersion()).add("PlatformType", platformTypeAsString())
                .add("PlatformName", platformName()).add("PlatformVersion", platformVersion())
                .add("ActivationId", activationId()).add("IamRole", iamRole()).add("RegistrationDate", registrationDate())
                .add("ResourceType", resourceTypeAsString()).add("Name", name()).add("IPAddress", ipAddress())
                .add("ComputerName", computerName()).add("AssociationStatus", associationStatus())
                .add("LastAssociationExecutionDate", lastAssociationExecutionDate())
                .add("LastSuccessfulAssociationExecutionDate", lastSuccessfulAssociationExecutionDate())
                .add("AssociationOverview", associationOverview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PingStatus":
            return Optional.ofNullable(clazz.cast(pingStatusAsString()));
        case "LastPingDateTime":
            return Optional.ofNullable(clazz.cast(lastPingDateTime()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "IsLatestVersion":
            return Optional.ofNullable(clazz.cast(isLatestVersion()));
        case "PlatformType":
            return Optional.ofNullable(clazz.cast(platformTypeAsString()));
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "ActivationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationDate":
            return Optional.ofNullable(clazz.cast(registrationDate()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IPAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatus()));
        case "LastAssociationExecutionDate":
            return Optional.ofNullable(clazz.cast(lastAssociationExecutionDate()));
        case "LastSuccessfulAssociationExecutionDate":
            return Optional.ofNullable(clazz.cast(lastSuccessfulAssociationExecutionDate()));
        case "AssociationOverview":
            return Optional.ofNullable(clazz.cast(associationOverview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInformation, T> g) {
        return obj -> g.apply((InstanceInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceInformation> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Connection status of SSM Agent.
         * </p>
         * <note>
         * <p>
         * The status <code>Inactive</code> has been deprecated and is no longer in use.
         * </p>
         * </note>
         * 
         * @param pingStatus
         *        Connection status of SSM Agent. </p> <note>
         *        <p>
         *        The status <code>Inactive</code> has been deprecated and is no longer in use.
         *        </p>
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(String pingStatus);

        /**
         * <p>
         * Connection status of SSM Agent.
         * </p>
         * <note>
         * <p>
         * The status <code>Inactive</code> has been deprecated and is no longer in use.
         * </p>
         * </note>
         * 
         * @param pingStatus
         *        Connection status of SSM Agent. </p> <note>
         *        <p>
         *        The status <code>Inactive</code> has been deprecated and is no longer in use.
         *        </p>
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(PingStatus pingStatus);

        /**
         * <p>
         * The date and time when the agent last pinged the Systems Manager service.
         * </p>
         * 
         * @param lastPingDateTime
         *        The date and time when the agent last pinged the Systems Manager service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPingDateTime(Instant lastPingDateTime);

        /**
         * <p>
         * The version of SSM Agent running on your Linux instance.
         * </p>
         * 
         * @param agentVersion
         *        The version of SSM Agent running on your Linux instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * Indicates whether the latest version of SSM Agent is running on your Linux Managed Instance. This field
         * doesn't indicate whether or not the latest version is installed on Windows managed instances, because some
         * older versions of Windows Server use the EC2Config service to process Systems Manager requests.
         * </p>
         * 
         * @param isLatestVersion
         *        Indicates whether the latest version of SSM Agent is running on your Linux Managed Instance. This
         *        field doesn't indicate whether or not the latest version is installed on Windows managed instances,
         *        because some older versions of Windows Server use the EC2Config service to process Systems Manager
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestVersion(Boolean isLatestVersion);

        /**
         * <p>
         * The operating system platform type.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(String platformType);

        /**
         * <p>
         * The operating system platform type.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(PlatformType platformType);

        /**
         * <p>
         * The name of the operating system platform running on your instance.
         * </p>
         * 
         * @param platformName
         *        The name of the operating system platform running on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the OS platform running on your instance.
         * </p>
         * 
         * @param platformVersion
         *        The version of the OS platform running on your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was
         * registered.
         * </p>
         * 
         * @param activationId
         *        The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine
         *        (VM) was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed instance.
         * This call doesn't return the IAM role for Amazon Elastic Compute Cloud (Amazon EC2) instances. To retrieve
         * the IAM role for an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> operation. For
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances
         * </a> in the <i>Amazon EC2 API Reference</i> or <a
         * href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the
         * <i>Amazon Web Services CLI Command Reference</i>.
         * </p>
         * 
         * @param iamRole
         *        The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed
         *        instance. This call doesn't return the IAM role for Amazon Elastic Compute Cloud (Amazon EC2)
         *        instances. To retrieve the IAM role for an EC2 instance, use the Amazon EC2
         *        <code>DescribeInstances</code> operation. For information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         *        >DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a
         *        href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in
         *        the <i>Amazon Web Services CLI Command Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The date the server or VM was registered with Amazon Web Services as a managed instance.
         * </p>
         * 
         * @param registrationDate
         *        The date the server or VM was registered with Amazon Web Services as a managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationDate(Instant registrationDate);

        /**
         * <p>
         * The type of instance. Instances are either EC2 instances or managed instances.
         * </p>
         * 
         * @param resourceType
         *        The type of instance. Instances are either EC2 instances or managed instances.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of instance. Instances are either EC2 instances or managed instances.
         * </p>
         * 
         * @param resourceType
         *        The type of instance. Instances are either EC2 instances or managed instances.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name assigned to an on-premises server or virtual machine (VM) when it is activated as a Systems Manager
         * managed instance. The name is specified as the <code>DefaultInstanceName</code> property using the
         * <a>CreateActivation</a> command. It is applied to the managed instance by specifying the Activation Code and
         * Activation ID when you install SSM Agent on the instance, as explained in <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install
         * SSM Agent for a hybrid environment (Linux)</a> and <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install
         * SSM Agent for a hybrid environment (Windows)</a>. To retrieve the Name tag of an EC2 instance, use the Amazon
         * EC2 <code>DescribeInstances</code> operation. For information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         * >DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a
         * href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the
         * <i>Amazon Web Services CLI Command Reference</i>.
         * </p>
         * 
         * @param name
         *        The name assigned to an on-premises server or virtual machine (VM) when it is activated as a Systems
         *        Manager managed instance. The name is specified as the <code>DefaultInstanceName</code> property using
         *        the <a>CreateActivation</a> command. It is applied to the managed instance by specifying the
         *        Activation Code and Activation ID when you install SSM Agent on the instance, as explained in <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html"
         *        >Install SSM Agent for a hybrid environment (Linux)</a> and <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html"
         *        >Install SSM Agent for a hybrid environment (Windows)</a>. To retrieve the Name tag of an EC2
         *        instance, use the Amazon EC2 <code>DescribeInstances</code> operation. For information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         *        >DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a
         *        href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in
         *        the <i>Amazon Web Services CLI Command Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IP address of the managed instance.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The fully qualified host name of the managed instance.
         * </p>
         * 
         * @param computerName
         *        The fully qualified host name of the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param associationStatus
         *        The status of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The date the association was last run.
         * </p>
         * 
         * @param lastAssociationExecutionDate
         *        The date the association was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate);

        /**
         * <p>
         * The last date the association was successfully run.
         * </p>
         * 
         * @param lastSuccessfulAssociationExecutionDate
         *        The last date the association was successfully run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate);

        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param associationOverview
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview);

        /**
         * <p>
         * Information about the association.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceAggregatedAssociationOverview.Builder}
         * avoiding the need to create one manually via {@link InstanceAggregatedAssociationOverview#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAggregatedAssociationOverview.Builder#build()} is called
         * immediately and its result is passed to {@link #associationOverview(InstanceAggregatedAssociationOverview)}.
         * 
         * @param associationOverview
         *        a consumer that will call methods on {@link InstanceAggregatedAssociationOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationOverview(InstanceAggregatedAssociationOverview)
         */
        default Builder associationOverview(Consumer<InstanceAggregatedAssociationOverview.Builder> associationOverview) {
            return associationOverview(InstanceAggregatedAssociationOverview.builder().applyMutation(associationOverview).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String pingStatus;

        private Instant lastPingDateTime;

        private String agentVersion;

        private Boolean isLatestVersion;

        private String platformType;

        private String platformName;

        private String platformVersion;

        private String activationId;

        private String iamRole;

        private Instant registrationDate;

        private String resourceType;

        private String name;

        private String ipAddress;

        private String computerName;

        private String associationStatus;

        private Instant lastAssociationExecutionDate;

        private Instant lastSuccessfulAssociationExecutionDate;

        private InstanceAggregatedAssociationOverview associationOverview;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformation model) {
            instanceId(model.instanceId);
            pingStatus(model.pingStatus);
            lastPingDateTime(model.lastPingDateTime);
            agentVersion(model.agentVersion);
            isLatestVersion(model.isLatestVersion);
            platformType(model.platformType);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            activationId(model.activationId);
            iamRole(model.iamRole);
            registrationDate(model.registrationDate);
            resourceType(model.resourceType);
            name(model.name);
            ipAddress(model.ipAddress);
            computerName(model.computerName);
            associationStatus(model.associationStatus);
            lastAssociationExecutionDate(model.lastAssociationExecutionDate);
            lastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            associationOverview(model.associationOverview);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPingStatus() {
            return pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus == null ? null : pingStatus.toString());
            return this;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        public final Instant getLastPingDateTime() {
            return lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final Boolean getIsLatestVersion() {
            return isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        public final String getPlatformType() {
            return platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType == null ? null : platformType.toString());
            return this;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public final String getPlatformName() {
            return platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getActivationId() {
            return activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Instant getRegistrationDate() {
            return registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getComputerName() {
            return computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final Instant getLastAssociationExecutionDate() {
            return lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        public final InstanceAggregatedAssociationOverview.Builder getAssociationOverview() {
            return associationOverview != null ? associationOverview.toBuilder() : null;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview.BuilderImpl associationOverview) {
            this.associationOverview = associationOverview != null ? associationOverview.build() : null;
        }

        @Override
        public InstanceInformation build() {
            return new InstanceInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
