/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpsMetadataResponse extends SsmResponse implements
        ToCopyableBuilder<GetOpsMetadataResponse.Builder, GetOpsMetadataResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(GetOpsMetadataResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<Map<String, MetadataValue>> METADATA_FIELD = SdkField
            .<Map<String, MetadataValue>> builder(MarshallingType.MAP)
            .memberName("Metadata")
            .getter(getter(GetOpsMetadataResponse::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetadataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetOpsMetadataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            METADATA_FIELD, NEXT_TOKEN_FIELD));

    private final String resourceId;

    private final Map<String, MetadataValue> metadata;

    private final String nextToken;

    private GetOpsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.metadata = builder.metadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The resource ID of the Application Manager application.
     * </p>
     * 
     * @return The resource ID of the Application Manager application.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * Returns true if the Metadata property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * OpsMetadata for an Application Manager application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return OpsMetadata for an Application Manager application.
     */
    public final Map<String, MetadataValue> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsMetadataResponse)) {
            return false;
        }
        GetOpsMetadataResponse other = (GetOpsMetadataResponse) obj;
        return Objects.equals(resourceId(), other.resourceId()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOpsMetadataResponse").add("ResourceId", resourceId())
                .add("Metadata", hasMetadata() ? metadata() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpsMetadataResponse, T> g) {
        return obj -> g.apply((GetOpsMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOpsMetadataResponse> {
        /**
         * <p>
         * The resource ID of the Application Manager application.
         * </p>
         * 
         * @param resourceId
         *        The resource ID of the Application Manager application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * OpsMetadata for an Application Manager application.
         * </p>
         * 
         * @param metadata
         *        OpsMetadata for an Application Manager application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, MetadataValue> metadata);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String resourceId;

        private Map<String, MetadataValue> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpsMetadataResponse model) {
            super(model);
            resourceId(model.resourceId);
            metadata(model.metadata);
            nextToken(model.nextToken);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Map<String, MetadataValue.Builder> getMetadata() {
            Map<String, MetadataValue.Builder> result = MetadataMapCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metadata(Map<String, MetadataValue> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, MetadataValue.BuilderImpl> metadata) {
            this.metadata = MetadataMapCopier.copyFromBuilder(metadata);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOpsMetadataResponse build() {
            return new GetOpsMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
