/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.PatchProperty;
import software.amazon.awssdk.services.ssm.model.PatchSet;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchPropertiesRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribePatchPropertiesRequest> {
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(DescribePatchPropertiesRequest.getter(DescribePatchPropertiesRequest::operatingSystemAsString)).setter(DescribePatchPropertiesRequest.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Property").getter(DescribePatchPropertiesRequest.getter(DescribePatchPropertiesRequest::propertyAsString)).setter(DescribePatchPropertiesRequest.setter(Builder::property)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Property").build()}).build();
    private static final SdkField<String> PATCH_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchSet").getter(DescribePatchPropertiesRequest.getter(DescribePatchPropertiesRequest::patchSetAsString)).setter(DescribePatchPropertiesRequest.setter(Builder::patchSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchSet").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribePatchPropertiesRequest.getter(DescribePatchPropertiesRequest::maxResults)).setter(DescribePatchPropertiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePatchPropertiesRequest.getter(DescribePatchPropertiesRequest::nextToken)).setter(DescribePatchPropertiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FIELD, PROPERTY_FIELD, PATCH_SET_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String operatingSystem;
    private final String property;
    private final String patchSet;
    private final Integer maxResults;
    private final String nextToken;

    private DescribePatchPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.operatingSystem = builder.operatingSystem;
        this.property = builder.property;
        this.patchSet = builder.patchSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final PatchProperty property() {
        return PatchProperty.fromValue(this.property);
    }

    public final String propertyAsString() {
        return this.property;
    }

    public final PatchSet patchSet() {
        return PatchSet.fromValue(this.patchSet);
    }

    public final String patchSetAsString() {
        return this.patchSet;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchPropertiesRequest)) {
            return false;
        }
        DescribePatchPropertiesRequest other = (DescribePatchPropertiesRequest)((Object)obj);
        return Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.propertyAsString(), other.propertyAsString()) && Objects.equals(this.patchSetAsString(), other.patchSetAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePatchPropertiesRequest").add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Property", (Object)this.propertyAsString()).add("PatchSet", (Object)this.patchSetAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Property": {
                return Optional.ofNullable(clazz.cast(this.propertyAsString()));
            }
            case "PatchSet": {
                return Optional.ofNullable(clazz.cast(this.patchSetAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchPropertiesRequest, T> g) {
        return obj -> g.apply((DescribePatchPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String operatingSystem;
        private String property;
        private String patchSet;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchPropertiesRequest model) {
            super(model);
            this.operatingSystem(model.operatingSystem);
            this.property(model.property);
            this.patchSet(model.patchSet);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getProperty() {
            return this.property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        @Transient
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        @Override
        @Transient
        public final Builder property(PatchProperty property) {
            this.property(property == null ? null : property.toString());
            return this;
        }

        public final String getPatchSet() {
            return this.patchSet;
        }

        public final void setPatchSet(String patchSet) {
            this.patchSet = patchSet;
        }

        @Override
        @Transient
        public final Builder patchSet(String patchSet) {
            this.patchSet = patchSet;
            return this;
        }

        @Override
        @Transient
        public final Builder patchSet(PatchSet patchSet) {
            this.patchSet(patchSet == null ? null : patchSet.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePatchPropertiesRequest build() {
            return new DescribePatchPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchPropertiesRequest> {
        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder property(String var1);

        public Builder property(PatchProperty var1);

        public Builder patchSet(String var1);

        public Builder patchSet(PatchSet var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

