/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMaintenanceWindowRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateMaintenanceWindowRequest.Builder, UpdateMaintenanceWindowRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowId").getter(getter(UpdateMaintenanceWindowRequest::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateMaintenanceWindowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateMaintenanceWindowRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(UpdateMaintenanceWindowRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDate").getter(getter(UpdateMaintenanceWindowRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(UpdateMaintenanceWindowRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleTimezone").getter(getter(UpdateMaintenanceWindowRequest::scheduleTimezone))
            .setter(setter(Builder::scheduleTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()).build();

    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScheduleOffset").getter(getter(UpdateMaintenanceWindowRequest::scheduleOffset))
            .setter(setter(Builder::scheduleOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(UpdateMaintenanceWindowRequest::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Cutoff").getter(getter(UpdateMaintenanceWindowRequest::cutoff)).setter(setter(Builder::cutoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()).build();

    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUnassociatedTargets").getter(getter(UpdateMaintenanceWindowRequest::allowUnassociatedTargets))
            .setter(setter(Builder::allowUnassociatedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateMaintenanceWindowRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Replace").getter(getter(UpdateMaintenanceWindowRequest::replace)).setter(setter(Builder::replace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, START_DATE_FIELD, END_DATE_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD,
            DURATION_FIELD, CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, ENABLED_FIELD, REPLACE_FIELD));

    private final String windowId;

    private final String name;

    private final String description;

    private final String startDate;

    private final String endDate;

    private final String schedule;

    private final String scheduleTimezone;

    private final Integer scheduleOffset;

    private final Integer duration;

    private final Integer cutoff;

    private final Boolean allowUnassociatedTargets;

    private final Boolean enabled;

    private final Boolean replace;

    private UpdateMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The ID of the maintenance window to update.
     * </p>
     * 
     * @return The ID of the maintenance window to update.
     */
    public final String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the maintenance window.
     * </p>
     * 
     * @return The name of the maintenance window.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the update request.
     * </p>
     * 
     * @return An optional description for the update request.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
     * the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * </p>
     * 
     * @return The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     *         Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
     *         information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
     *         website.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive.
     * <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer
     * run.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
     *         inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance
     *         window will no longer run.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The schedule of the maintenance window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the maintenance window in the form of a cron or rate expression.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
     * the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * </p>
     * 
     * @return The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     *         Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
     *         information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
     *         website.
     */
    public final String scheduleTimezone() {
        return scheduleTimezone;
    }

    /**
     * <p>
     * The number of days to wait after the date and time specified by a cron expression before running the maintenance
     * window.
     * </p>
     * <p>
     * For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month
     * at 11:30 PM.
     * </p>
     * <p>
     * <code>cron(30 23 ? * TUE#3 *)</code>
     * </p>
     * <p>
     * If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
     * </p>
     * 
     * @return The number of days to wait after the date and time specified by a cron expression before running the
     *         maintenance window.</p>
     *         <p>
     *         For example, the following cron expression schedules a maintenance window to run the third Tuesday of
     *         every month at 11:30 PM.
     *         </p>
     *         <p>
     *         <code>cron(30 23 ? * TUE#3 *)</code>
     *         </p>
     *         <p>
     *         If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
     */
    public final Integer scheduleOffset() {
        return scheduleOffset;
    }

    /**
     * <p>
     * The duration of the maintenance window in hours.
     * </p>
     * 
     * @return The duration of the maintenance window in hours.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
     * scheduling new tasks for execution.
     * </p>
     * 
     * @return The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
     *         stops scheduling new tasks for execution.
     */
    public final Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
     * </p>
     * 
     * @return Whether targets must be registered with the maintenance window before tasks can be defined for those
     *         targets.
     */
    public final Boolean allowUnassociatedTargets() {
        return allowUnassociatedTargets;
    }

    /**
     * <p>
     * Whether the maintenance window is enabled.
     * </p>
     * 
     * @return Whether the maintenance window is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation are also
     * required for this API request. Optional fields that aren't specified are set to null.
     * </p>
     * 
     * @return If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation
     *         are also required for this API request. Optional fields that aren't specified are set to null.
     */
    public final Boolean replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowRequest)) {
            return false;
        }
        UpdateMaintenanceWindowRequest other = (UpdateMaintenanceWindowRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(scheduleTimezone(), other.scheduleTimezone())
                && Objects.equals(scheduleOffset(), other.scheduleOffset()) && Objects.equals(duration(), other.duration())
                && Objects.equals(cutoff(), other.cutoff())
                && Objects.equals(allowUnassociatedTargets(), other.allowUnassociatedTargets())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(replace(), other.replace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMaintenanceWindowRequest").add("WindowId", windowId()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StartDate", startDate()).add("EndDate", endDate()).add("Schedule", schedule())
                .add("ScheduleTimezone", scheduleTimezone()).add("ScheduleOffset", scheduleOffset()).add("Duration", duration())
                .add("Cutoff", cutoff()).add("AllowUnassociatedTargets", allowUnassociatedTargets()).add("Enabled", enabled())
                .add("Replace", replace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ScheduleTimezone":
            return Optional.ofNullable(clazz.cast(scheduleTimezone()));
        case "ScheduleOffset":
            return Optional.ofNullable(clazz.cast(scheduleOffset()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Cutoff":
            return Optional.ofNullable(clazz.cast(cutoff()));
        case "AllowUnassociatedTargets":
            return Optional.ofNullable(clazz.cast(allowUnassociatedTargets()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Replace":
            return Optional.ofNullable(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceWindowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the maintenance window to update.
         * </p>
         * 
         * @param windowId
         *        The ID of the maintenance window to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the maintenance window.
         * </p>
         * 
         * @param name
         *        The name of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the update request.
         * </p>
         * 
         * @param description
         *        An optional description for the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
         * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information,
         * see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * </p>
         * 
         * @param startDate
         *        The time zone that the scheduled maintenance window executions are based on, in Internet Assigned
         *        Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
         *        information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
         *        website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive.
         * <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no
         * longer run.
         * </p>
         * 
         * @param endDate
         *        The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
         *        inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance
         *        window will no longer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The schedule of the maintenance window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the maintenance window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
         * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information,
         * see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * </p>
         * 
         * @param scheduleTimezone
         *        The time zone that the scheduled maintenance window executions are based on, in Internet Assigned
         *        Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
         *        information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
         *        website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleTimezone(String scheduleTimezone);

        /**
         * <p>
         * The number of days to wait after the date and time specified by a cron expression before running the
         * maintenance window.
         * </p>
         * <p>
         * For example, the following cron expression schedules a maintenance window to run the third Tuesday of every
         * month at 11:30 PM.
         * </p>
         * <p>
         * <code>cron(30 23 ? * TUE#3 *)</code>
         * </p>
         * <p>
         * If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
         * </p>
         * 
         * @param scheduleOffset
         *        The number of days to wait after the date and time specified by a cron expression before running the
         *        maintenance window.</p>
         *        <p>
         *        For example, the following cron expression schedules a maintenance window to run the third Tuesday of
         *        every month at 11:30 PM.
         *        </p>
         *        <p>
         *        <code>cron(30 23 ? * TUE#3 *)</code>
         *        </p>
         *        <p>
         *        If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleOffset(Integer scheduleOffset);

        /**
         * <p>
         * The duration of the maintenance window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the maintenance window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
         * scheduling new tasks for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
         *        stops scheduling new tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
         * </p>
         * 
         * @param allowUnassociatedTargets
         *        Whether targets must be registered with the maintenance window before tasks can be defined for those
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets);

        /**
         * <p>
         * Whether the maintenance window is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the maintenance window is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation are
         * also required for this API request. Optional fields that aren't specified are set to null.
         * </p>
         * 
         * @param replace
         *        If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a>
         *        operation are also required for this API request. Optional fields that aren't specified are set to
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String description;

        private String startDate;

        private String endDate;

        private String schedule;

        private String scheduleTimezone;

        private Integer scheduleOffset;

        private Integer duration;

        private Integer cutoff;

        private Boolean allowUnassociatedTargets;

        private Boolean enabled;

        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowRequest model) {
            super(model);
            windowId(model.windowId);
            name(model.name);
            description(model.description);
            startDate(model.startDate);
            endDate(model.endDate);
            schedule(model.schedule);
            scheduleTimezone(model.scheduleTimezone);
            scheduleOffset(model.scheduleOffset);
            duration(model.duration);
            cutoff(model.cutoff);
            allowUnassociatedTargets(model.allowUnassociatedTargets);
            enabled(model.enabled);
            replace(model.replace);
        }

        public final String getWindowId() {
            return windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        @Transient
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        @Transient
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        @Transient
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduleTimezone() {
            return scheduleTimezone;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        @Override
        @Transient
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final Integer getScheduleOffset() {
            return scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        @Transient
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        @Transient
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return allowUnassociatedTargets;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        @Override
        @Transient
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getReplace() {
            return replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        @Transient
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowRequest build() {
            return new UpdateMaintenanceWindowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
