/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes information about the specified association execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationExecutionTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationExecutionTarget.Builder, AssociationExecutionTarget> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(AssociationExecutionTarget::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationVersion").getter(getter(AssociationExecutionTarget::associationVersion))
            .setter(setter(Builder::associationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build())
            .build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(AssociationExecutionTarget::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(AssociationExecutionTarget::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AssociationExecutionTarget::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AssociationExecutionTarget::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(AssociationExecutionTarget::detailedStatus))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionDate").getter(getter(AssociationExecutionTarget::lastExecutionDate))
            .setter(setter(Builder::lastExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()).build();

    private static final SdkField<OutputSource> OUTPUT_SOURCE_FIELD = SdkField.<OutputSource> builder(MarshallingType.SDK_POJO)
            .memberName("OutputSource").getter(getter(AssociationExecutionTarget::outputSource))
            .setter(setter(Builder::outputSource)).constructor(OutputSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            ASSOCIATION_VERSION_FIELD, EXECUTION_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD,
            DETAILED_STATUS_FIELD, LAST_EXECUTION_DATE_FIELD, OUTPUT_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String associationVersion;

    private final String executionId;

    private final String resourceId;

    private final String resourceType;

    private final String status;

    private final String detailedStatus;

    private final Instant lastExecutionDate;

    private final OutputSource outputSource;

    private AssociationExecutionTarget(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.executionId = builder.executionId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.outputSource = builder.outputSource;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The association version.
     * </p>
     * 
     * @return The association version.
     */
    public final String associationVersion() {
        return associationVersion;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The resource ID, for example, the instance ID where the association ran.
     * </p>
     * 
     * @return The resource ID, for example, the instance ID where the association ran.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource type, for example, instance.
     * </p>
     * 
     * @return The resource type, for example, instance.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The association execution status.
     * </p>
     * 
     * @return The association execution status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Detailed information about the execution status.
     * </p>
     * 
     * @return Detailed information about the execution status.
     */
    public final String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * The date of the last execution.
     * </p>
     * 
     * @return The date of the last execution.
     */
    public final Instant lastExecutionDate() {
        return lastExecutionDate;
    }

    /**
     * <p>
     * The location where the association details are saved.
     * </p>
     * 
     * @return The location where the association details are saved.
     */
    public final OutputSource outputSource() {
        return outputSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(outputSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationExecutionTarget)) {
            return false;
        }
        AssociationExecutionTarget other = (AssociationExecutionTarget) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(associationVersion(), other.associationVersion())
                && Objects.equals(executionId(), other.executionId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(status(), other.status())
                && Objects.equals(detailedStatus(), other.detailedStatus())
                && Objects.equals(lastExecutionDate(), other.lastExecutionDate())
                && Objects.equals(outputSource(), other.outputSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationExecutionTarget").add("AssociationId", associationId())
                .add("AssociationVersion", associationVersion()).add("ExecutionId", executionId())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType()).add("Status", status())
                .add("DetailedStatus", detailedStatus()).add("LastExecutionDate", lastExecutionDate())
                .add("OutputSource", outputSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "AssociationVersion":
            return Optional.ofNullable(clazz.cast(associationVersion()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatus()));
        case "LastExecutionDate":
            return Optional.ofNullable(clazz.cast(lastExecutionDate()));
        case "OutputSource":
            return Optional.ofNullable(clazz.cast(outputSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationExecutionTarget, T> g) {
        return obj -> g.apply((AssociationExecutionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationExecutionTarget> {
        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The association version.
         * </p>
         * 
         * @param associationVersion
         *        The association version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param executionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The resource ID, for example, the instance ID where the association ran.
         * </p>
         * 
         * @param resourceId
         *        The resource ID, for example, the instance ID where the association ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource type, for example, instance.
         * </p>
         * 
         * @param resourceType
         *        The resource type, for example, instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The association execution status.
         * </p>
         * 
         * @param status
         *        The association execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Detailed information about the execution status.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed information about the execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * The date of the last execution.
         * </p>
         * 
         * @param lastExecutionDate
         *        The date of the last execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionDate(Instant lastExecutionDate);

        /**
         * <p>
         * The location where the association details are saved.
         * </p>
         * 
         * @param outputSource
         *        The location where the association details are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSource(OutputSource outputSource);

        /**
         * <p>
         * The location where the association details are saved.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputSource.Builder} avoiding the need to
         * create one manually via {@link OutputSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputSource.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSource(OutputSource)}.
         * 
         * @param outputSource
         *        a consumer that will call methods on {@link OutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSource(OutputSource)
         */
        default Builder outputSource(Consumer<OutputSource.Builder> outputSource) {
            return outputSource(OutputSource.builder().applyMutation(outputSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String associationVersion;

        private String executionId;

        private String resourceId;

        private String resourceType;

        private String status;

        private String detailedStatus;

        private Instant lastExecutionDate;

        private OutputSource outputSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationExecutionTarget model) {
            associationId(model.associationId);
            associationVersion(model.associationVersion);
            executionId(model.executionId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            status(model.status);
            detailedStatus(model.detailedStatus);
            lastExecutionDate(model.lastExecutionDate);
            outputSource(model.outputSource);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        @Transient
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        @Transient
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        @Transient
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final Instant getLastExecutionDate() {
            return lastExecutionDate;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        @Transient
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final OutputSource.Builder getOutputSource() {
            return outputSource != null ? outputSource.toBuilder() : null;
        }

        public final void setOutputSource(OutputSource.BuilderImpl outputSource) {
            this.outputSource = outputSource != null ? outputSource.build() : null;
        }

        @Override
        @Transient
        public final Builder outputSource(OutputSource outputSource) {
            this.outputSource = outputSource;
            return this;
        }

        @Override
        public AssociationExecutionTarget build() {
            return new AssociationExecutionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
